/*
 * Decompiled with CFR 0.152.
 */
package shadow.bundletool.com.android.tools.r8.graph;

import com.google.common.collect.ImmutableList;
import java.util.List;
import java.util.function.BooleanSupplier;

public abstract class AccessFlags {
    protected static final int BASE_FLAGS = 4127;
    private static final List<String> NAMES = ImmutableList.of((Object)"public", (Object)"private", (Object)"protected", (Object)"static", (Object)"final", (Object)"synthetic");
    protected int flags;

    protected List<BooleanSupplier> getPredicates() {
        return ImmutableList.of(this::isPublic, this::isPrivate, this::isProtected, this::isStatic, this::isFinal, this::isSynthetic);
    }

    protected List<String> getNames() {
        return NAMES;
    }

    protected AccessFlags(int flags) {
        this.flags = flags;
    }

    public abstract int getAsCfAccessFlags();

    public abstract int getAsDexAccessFlags();

    public boolean equals(Object other) {
        if (other instanceof AccessFlags) {
            return this.flags == ((AccessFlags)other).flags;
        }
        return false;
    }

    public int hashCode() {
        return this.flags;
    }

    public boolean isPublic() {
        return this.isSet(1);
    }

    public void setPublic() {
        assert (!this.isPrivate() && !this.isProtected());
        this.set(1);
    }

    public void unsetPublic() {
        this.unset(1);
    }

    public boolean isPrivate() {
        return this.isSet(2);
    }

    public void setPrivate() {
        assert (!this.isPublic() && !this.isProtected());
        this.set(2);
    }

    public void unsetPrivate() {
        this.unset(2);
    }

    public boolean isProtected() {
        return this.isSet(4);
    }

    public void setProtected() {
        assert (!this.isPublic() && !this.isPrivate());
        this.set(4);
    }

    public void unsetProtected() {
        this.unset(4);
    }

    public boolean isStatic() {
        return this.isSet(8);
    }

    public void setStatic() {
        this.set(8);
    }

    public boolean isFinal() {
        return this.isSet(16);
    }

    public void setFinal() {
        this.set(16);
    }

    public void unsetFinal() {
        this.unset(16);
    }

    public boolean isSynthetic() {
        return this.isSet(4096);
    }

    public void setSynthetic() {
        this.set(4096);
    }

    public void unsetSynthetic() {
        this.unset(4096);
    }

    public void promoteNonPrivateToPublic() {
        if (!this.isPrivate()) {
            this.unsetProtected();
            this.setPublic();
        }
    }

    public void promoteToPublic() {
        this.unsetProtected();
        this.unsetPrivate();
        this.setPublic();
    }

    protected boolean isSet(int flag) {
        return (this.flags & flag) != 0;
    }

    protected void set(int flag) {
        this.flags |= flag;
    }

    protected void unset(int flag) {
        this.flags &= ~flag;
    }

    public String toSmaliString() {
        return this.toStringInternal(true);
    }

    public String toString() {
        return this.toStringInternal(false);
    }

    private String toStringInternal(boolean ignoreSuper) {
        List<String> names = this.getNames();
        List<BooleanSupplier> predicates = this.getPredicates();
        StringBuilder builder = new StringBuilder();
        for (int i = 0; i < names.size(); ++i) {
            if (!predicates.get(i).getAsBoolean() || ignoreSuper && names.get(i).equals("super")) continue;
            if (builder.length() > 0) {
                builder.append(' ');
            }
            builder.append(names.get(i));
        }
        return builder.toString();
    }
}

