/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.build.bundletool.validation;

import com.android.aapt.Resources;
import com.android.tools.build.bundletool.exceptions.ValidationException;
import com.android.tools.build.bundletool.model.BundleModule;
import com.android.tools.build.bundletool.utils.ResourcesUtils;
import com.android.tools.build.bundletool.validation.SubValidator;
import com.android.tools.build.bundletool.version.BundleToolVersion;
import com.android.tools.build.bundletool.version.Version;
import com.google.common.collect.ImmutableList;
import java.util.Optional;
import java.util.Set;

public class ModuleTitleValidator
extends SubValidator {
    @Override
    public void validateAllModules(ImmutableList<BundleModule> modules) {
        ModuleTitleValidator.checkModuleTitles(modules);
    }

    private static void checkModuleTitles(ImmutableList<BundleModule> modules) {
        BundleModule baseModule = modules.stream().filter(BundleModule::isBaseModule).findFirst().get();
        if (BundleToolVersion.getVersionFromBundleConfig(baseModule.getBundleConfig()).isOlderThan(Version.of("0.4.3"))) {
            return;
        }
        Resources.ResourceTable table = baseModule.getResourceTable().orElse(Resources.ResourceTable.getDefaultInstance());
        Set<Integer> stringResourceIds = ResourcesUtils.resourceIds(table, type -> type.getName().equals("string"));
        for (BundleModule module : modules) {
            if (!module.isOnDemandModule()) continue;
            Optional<Integer> titleRefId = module.getAndroidManifest().getTitleRefId();
            if (!titleRefId.isPresent()) {
                throw ValidationException.builder().withMessage("Mandatory title is missing in manifest for on-demand module '%s'.", module.getName()).build();
            }
            if (stringResourceIds.contains(titleRefId.get())) continue;
            throw ValidationException.builder().withMessage("Title for on-demand module '%s' is missing in the base resource table.", module.getName()).build();
        }
    }
}

