/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.build.bundletool.utils.xml;

import com.android.tools.build.bundletool.exceptions.XmlParsingException;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringReader;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.sax.SAXSource;
import javax.xml.validation.Schema;
import javax.xml.validation.SchemaFactory;
import org.w3c.dom.Document;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public final class XmlValidator {
    private final Schema schema;

    public XmlValidator(URL schemaUrl) {
        SchemaFactory schemaFactory = SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema");
        try {
            this.schema = schemaFactory.newSchema(schemaUrl);
        }
        catch (SAXException e) {
            throw new RuntimeException("Unable to read the XML schema.", e);
        }
    }

    public XmlValidator(String schema) {
        SchemaFactory schemaFactory = SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema");
        try {
            this.schema = schemaFactory.newSchema(new SAXSource(new InputSource(new StringReader(schema))));
        }
        catch (SAXException e) {
            throw new RuntimeException("Unable to read the XML schema.", e);
        }
    }

    public Document validate(String xml) throws XmlParsingException {
        return this.validate(new ByteArrayInputStream(xml.getBytes(StandardCharsets.UTF_8)));
    }

    public Document validate(InputStream xmlStream) throws XmlParsingException {
        try {
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            factory.setNamespaceAware(true);
            factory.setSchema(this.schema);
            factory.setIgnoringComments(true);
            factory.setIgnoringElementContentWhitespace(true);
            factory.setValidating(false);
            DocumentBuilder documentBuilder = factory.newDocumentBuilder();
            documentBuilder.setErrorHandler(new XmlParsingErrorHandler());
            try {
                return documentBuilder.parse(xmlStream);
            }
            catch (IOException e) {
                throw new RuntimeException("Unable to read the XML", e);
            }
        }
        catch (ParserConfigurationException | SAXException e) {
            throw new RuntimeException("Unexpected error while trying to validate the XML.", e);
        }
    }

    private static class XmlParsingErrorHandler
    implements ErrorHandler {
        private XmlParsingErrorHandler() {
        }

        @Override
        public void warning(SAXParseException e) throws SAXException {
            throw new XmlParsingException("Encountered a warning during XML parsing", e);
        }

        @Override
        public void error(SAXParseException e) throws SAXException {
            throw new XmlParsingException("Encountered an error during XML parsing", e);
        }

        @Override
        public void fatalError(SAXParseException e) throws SAXException {
            throw new XmlParsingException("Encountered a fatal error during XML parsing", e);
        }
    }
}

