/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.build.bundletool.device;

import com.android.bundle.Devices;
import com.android.bundle.Targeting;
import com.android.tools.build.bundletool.device.TargetingDimensionMatcher;
import com.android.tools.build.bundletool.utils.ResourcesUtils;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import java.util.Collection;
import java.util.Set;

public class LanguageMatcher
extends TargetingDimensionMatcher<Targeting.LanguageTargeting> {
    private final ImmutableSet<String> deviceLanguages;

    public LanguageMatcher(Devices.DeviceSpec deviceSpec) {
        super(deviceSpec);
        this.deviceLanguages = (ImmutableSet)deviceSpec.getSupportedLocalesList().stream().map(ResourcesUtils::convertLocaleToLanguage).collect(ImmutableSet.toImmutableSet());
    }

    @Override
    protected Targeting.LanguageTargeting getTargetingValue(Targeting.ApkTargeting apkTargeting) {
        return apkTargeting.getLanguageTargeting();
    }

    @Override
    protected Targeting.LanguageTargeting getTargetingValue(Targeting.VariantTargeting variantTargeting) {
        return Targeting.LanguageTargeting.getDefaultInstance();
    }

    @Override
    public boolean matchesTargeting(Targeting.LanguageTargeting targetingValue) {
        if (targetingValue.equals(Targeting.LanguageTargeting.getDefaultInstance())) {
            return true;
        }
        if (targetingValue.getValueCount() > 0) {
            ImmutableSet targetingLanguages = ImmutableSet.copyOf((Collection)targetingValue.getValueList());
            return !Sets.intersection((Set)targetingLanguages, this.deviceLanguages).isEmpty();
        }
        ImmutableSet alternativeLanguages = ImmutableSet.copyOf((Collection)targetingValue.getAlternativesList());
        return !alternativeLanguages.containsAll((Collection<?>)this.deviceLanguages);
    }
}

