/*
 * Decompiled with CFR 0.152.
 */
package shadow.bundletool.com.android.tools.r8.shaking;

import com.google.common.collect.Maps;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import shadow.bundletool.com.android.tools.r8.dex.IndexedItemCollection;
import shadow.bundletool.com.android.tools.r8.errors.CompilationError;
import shadow.bundletool.com.android.tools.r8.graph.AppInfoWithSubtyping;
import shadow.bundletool.com.android.tools.r8.graph.DexAnnotationSet;
import shadow.bundletool.com.android.tools.r8.graph.DexApplication;
import shadow.bundletool.com.android.tools.r8.graph.DexCallSite;
import shadow.bundletool.com.android.tools.r8.graph.DexClass;
import shadow.bundletool.com.android.tools.r8.graph.DexEncodedMethod;
import shadow.bundletool.com.android.tools.r8.graph.DexField;
import shadow.bundletool.com.android.tools.r8.graph.DexMethod;
import shadow.bundletool.com.android.tools.r8.graph.DexMethodHandle;
import shadow.bundletool.com.android.tools.r8.graph.DexProgramClass;
import shadow.bundletool.com.android.tools.r8.graph.DexProto;
import shadow.bundletool.com.android.tools.r8.graph.DexString;
import shadow.bundletool.com.android.tools.r8.graph.DexType;
import shadow.bundletool.com.android.tools.r8.graph.UseRegistry;

public class MainDexListBuilder {
    private final Set<DexType> baseClasses;
    private final AppInfoWithSubtyping appInfo;
    private final Set<DexType> mainDexTypes = new HashSet<DexType>();
    private final DirectReferencesCollector codeDirectReferenceCollector = new DirectReferencesCollector();
    private final AnnotationDirectReferenceCollector annotationDirectReferenceCollector = new AnnotationDirectReferenceCollector();
    private final Map<DexType, Boolean> annotationTypeContainEnum;
    private final DexApplication dexApplication;

    public MainDexListBuilder(Set<DexType> baseClasses, DexApplication application) {
        this.dexApplication = application;
        this.appInfo = new AppInfoWithSubtyping(this.dexApplication);
        this.baseClasses = baseClasses.stream().filter(this::isProgramClass).collect(Collectors.toSet());
        DexClass enumType = this.appInfo.definitionFor(this.appInfo.dexItemFactory.enumType);
        if (enumType == null) {
            throw new CompilationError("Tracing for legacy multi dex is not possible without all classpath libraries (java.lang.Enum is missing)");
        }
        DexClass annotationType = this.appInfo.definitionFor(this.appInfo.dexItemFactory.annotationType);
        if (annotationType == null) {
            throw new CompilationError("Tracing for legacy multi dex is not possible without all classpath libraries (java.lang.annotation.Annotation is missing)");
        }
        this.annotationTypeContainEnum = Maps.newHashMapWithExpectedSize((int)this.appInfo.subtypes(this.appInfo.dexItemFactory.annotationType).size());
    }

    public Set<DexType> run() {
        this.traceMainDexDirectDependencies();
        this.traceRuntimeAnnotationsWithEnumForMainDex();
        return this.mainDexTypes.stream().filter(this::isProgramClass).collect(Collectors.toSet());
    }

    private void traceRuntimeAnnotationsWithEnumForMainDex() {
        for (DexProgramClass clazz : this.dexApplication.classes()) {
            DexType dexType = clazz.type;
            if (this.mainDexTypes.contains(dexType)) continue;
            if (this.isAnnotation(dexType) && this.isAnnotationWithEnum(dexType)) {
                this.addMainDexType(dexType);
                continue;
            }
            clazz.forEachAnnotation(annotation -> {
                if (!this.mainDexTypes.contains(dexType) && annotation.visibility == 1 && this.isAnnotationWithEnum(annotation.annotation.type)) {
                    this.addMainDexType(dexType);
                }
            });
        }
    }

    private boolean isAnnotationWithEnum(DexType dexType) {
        Boolean value = this.annotationTypeContainEnum.get(dexType);
        if (value == null) {
            DexClass clazz = this.appInfo.definitionFor(dexType);
            if (clazz == null) {
                value = Boolean.TRUE;
            } else {
                value = Boolean.FALSE;
                for (DexEncodedMethod method : clazz.virtualMethods()) {
                    DexProto proto = method.method.proto;
                    if (!proto.parameters.isEmpty()) continue;
                    DexType valueType = proto.returnType.toBaseType(this.appInfo.dexItemFactory);
                    if (this.isEnum(valueType)) {
                        value = Boolean.TRUE;
                        break;
                    }
                    if (!this.isAnnotation(valueType) || !this.isAnnotationWithEnum(valueType)) continue;
                    value = Boolean.TRUE;
                    break;
                }
            }
            this.annotationTypeContainEnum.put(dexType, value);
        }
        return value;
    }

    private boolean isEnum(DexType valueType) {
        return valueType.isSubtypeOf(this.appInfo.dexItemFactory.enumType, this.appInfo);
    }

    private boolean isAnnotation(DexType valueType) {
        return valueType.isSubtypeOf(this.appInfo.dexItemFactory.annotationType, this.appInfo);
    }

    private boolean isProgramClass(DexType dexType) {
        DexClass clazz = this.appInfo.definitionFor(dexType);
        return clazz != null && clazz.isProgramClass();
    }

    private void traceMainDexDirectDependencies() {
        for (DexType type : this.baseClasses) {
            DexClass clazz = this.appInfo.definitionFor(type);
            if (clazz == null) continue;
            this.addMainDexType(type);
            this.traceAnnotationsDirectDendencies(clazz.annotations);
            clazz.forEachField(field -> this.addMainDexType(field.field.type));
            clazz.forEachMethod(method -> {
                this.traceMethodDirectDependencies(method.method);
                method.registerInstructionsReferences(this.codeDirectReferenceCollector);
                method.registerCatchedTypes(this::addMainDexType);
            });
        }
    }

    private void traceAnnotationsDirectDendencies(DexAnnotationSet annotations) {
        annotations.collectIndexedItems(this.annotationDirectReferenceCollector);
    }

    private void traceMethodDirectDependencies(DexMethod method) {
        DexProto proto = method.proto;
        this.addMainDexType(proto.returnType);
        for (DexType parameterType : proto.parameters.values) {
            this.addMainDexType(parameterType);
        }
    }

    private void addMainDexType(DexType type) {
        if (!(type = type.toBaseType(this.appInfo.dexItemFactory)).isClassType()) {
            return;
        }
        DexClass clazz = this.appInfo.definitionFor(type);
        if (clazz == null) {
            return;
        }
        this.addMainDexType(clazz);
    }

    private void addMainDexType(DexClass dexClass) {
        DexType type = dexClass.type;
        if (this.mainDexTypes.add(type)) {
            if (dexClass.superType != null) {
                this.addMainDexType(dexClass.superType);
            }
            for (DexType interfaze : dexClass.interfaces.values) {
                this.addMainDexType(interfaze);
            }
        }
    }

    private class AnnotationDirectReferenceCollector
    implements IndexedItemCollection {
        private AnnotationDirectReferenceCollector() {
        }

        @Override
        public boolean addClass(DexProgramClass dexProgramClass) {
            MainDexListBuilder.this.addMainDexType(dexProgramClass.type);
            return false;
        }

        @Override
        public boolean addField(DexField field) {
            MainDexListBuilder.this.addMainDexType(field.getHolder());
            MainDexListBuilder.this.addMainDexType(field.type);
            return false;
        }

        @Override
        public boolean addMethod(DexMethod method) {
            MainDexListBuilder.this.addMainDexType(method.getHolder());
            this.addProto(method.proto);
            return false;
        }

        @Override
        public boolean addString(DexString string) {
            return false;
        }

        @Override
        public boolean addProto(DexProto proto) {
            MainDexListBuilder.this.addMainDexType(proto.returnType);
            Collections.addAll(MainDexListBuilder.this.mainDexTypes, proto.parameters.values);
            return false;
        }

        @Override
        public boolean addType(DexType type) {
            MainDexListBuilder.this.addMainDexType(type);
            return false;
        }

        @Override
        public boolean addCallSite(DexCallSite callSite) {
            throw new AssertionError((Object)"CallSite are not supported when tracing for legacy multi dex");
        }

        @Override
        public boolean addMethodHandle(DexMethodHandle methodHandle) {
            throw new AssertionError((Object)"DexMethodHandle are not supported when tracing for legacy multi dex");
        }
    }

    private class DirectReferencesCollector
    extends UseRegistry {
        private DirectReferencesCollector() {
        }

        @Override
        public boolean registerInvokeVirtual(DexMethod method) {
            return this.registerInvoke(method);
        }

        @Override
        public boolean registerInvokeDirect(DexMethod method) {
            return this.registerInvoke(method);
        }

        @Override
        public boolean registerInvokeStatic(DexMethod method) {
            return this.registerInvoke(method);
        }

        @Override
        public boolean registerInvokeInterface(DexMethod method) {
            return this.registerInvoke(method);
        }

        @Override
        public boolean registerInvokeSuper(DexMethod method) {
            return this.registerInvoke(method);
        }

        protected boolean registerInvoke(DexMethod method) {
            MainDexListBuilder.this.addMainDexType(method.getHolder());
            MainDexListBuilder.this.traceMethodDirectDependencies(method);
            return true;
        }

        @Override
        public boolean registerInstanceFieldWrite(DexField field) {
            return this.registerFieldAccess(field);
        }

        @Override
        public boolean registerInstanceFieldRead(DexField field) {
            return this.registerFieldAccess(field);
        }

        @Override
        public boolean registerStaticFieldRead(DexField field) {
            return this.registerFieldAccess(field);
        }

        @Override
        public boolean registerStaticFieldWrite(DexField field) {
            return this.registerFieldAccess(field);
        }

        protected boolean registerFieldAccess(DexField field) {
            MainDexListBuilder.this.addMainDexType(field.getHolder());
            MainDexListBuilder.this.addMainDexType(field.type);
            return true;
        }

        @Override
        public boolean registerNewInstance(DexType type) {
            MainDexListBuilder.this.addMainDexType(type);
            return true;
        }

        @Override
        public boolean registerTypeReference(DexType type) {
            MainDexListBuilder.this.addMainDexType(type);
            return true;
        }
    }
}

