/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.build.bundletool.validation;

import com.android.tools.build.bundletool.exceptions.ValidationException;
import com.android.tools.build.bundletool.model.AndroidManifest;
import com.android.tools.build.bundletool.model.BundleModule;
import com.android.tools.build.bundletool.validation.SubValidator;
import com.google.common.base.Preconditions;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Multimap;
import com.google.common.collect.Multimaps;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Optional;
import java.util.Set;

public class ModuleDependencyValidator
extends SubValidator {
    @Override
    public void validateAllModules(ImmutableList<BundleModule> modules) {
        ModuleDependencyValidator.checkHasBaseModule(modules);
        ModuleDependencyValidator.checkSplitIds(modules);
        Multimap<String, String> moduleDependenciesMap = ModuleDependencyValidator.buildAdjacencyMap(modules);
        ModuleDependencyValidator.checkNoReflexiveDependencies(moduleDependenciesMap);
        ModuleDependencyValidator.checkModulesHaveUniqueDependencies(moduleDependenciesMap);
        ModuleDependencyValidator.checkReferencedModulesExist(moduleDependenciesMap);
        ModuleDependencyValidator.checkNoCycles(moduleDependenciesMap);
    }

    private static Multimap<String, String> buildAdjacencyMap(ImmutableList<BundleModule> modules) {
        ArrayListMultimap moduleDependenciesMap = ArrayListMultimap.create();
        for (BundleModule module : modules) {
            String moduleName = module.getName().getName();
            AndroidManifest manifest = module.getAndroidManifest();
            Preconditions.checkArgument((!moduleDependenciesMap.containsKey((Object)moduleName) ? 1 : 0) != 0, (String)"Module named '%s' was passed in multiple times.", (Object)moduleName);
            moduleDependenciesMap.putAll((Object)moduleName, manifest.getUsesSplits());
            if (moduleDependenciesMap.containsEntry((Object)moduleName, (Object)"base")) {
                throw ValidationException.builder().withMessage("Module '%s' declares dependency on the '%s' module, which is implicit.", moduleName, "base").build();
            }
            moduleDependenciesMap.put((Object)moduleName, (Object)"base");
        }
        return Multimaps.unmodifiableMultimap((Multimap)moduleDependenciesMap);
    }

    private static void checkHasBaseModule(ImmutableList<BundleModule> modules) {
        if (!modules.stream().anyMatch(BundleModule::isBaseModule)) {
            throw ValidationException.builder().withMessage("Mandatory '%s' module is missing.", "base").build();
        }
    }

    private static void checkSplitIds(ImmutableList<BundleModule> modules) {
        for (BundleModule module : modules) {
            String moduleName = module.getName().getName();
            Optional<String> splitIdFromManifest = module.getAndroidManifest().getSplitId();
            if (module.isBaseModule()) {
                if (!splitIdFromManifest.isPresent()) continue;
                throw ValidationException.builder().withMessage("The base module should not declare split ID in the manifest, but it is set to '%s'.", splitIdFromManifest.get()).build();
            }
            if (!splitIdFromManifest.isPresent() || moduleName.equals(splitIdFromManifest.get())) continue;
            throw ValidationException.builder().withMessage("Module '%s' declares in its manifest that the split ID is '%s'. It needs to be either absent or equal to the module name.", moduleName, splitIdFromManifest.get()).build();
        }
    }

    private static void checkReferencedModulesExist(Multimap<String, String> moduleDependenciesMap) {
        for (String referencedModule : moduleDependenciesMap.values()) {
            if (moduleDependenciesMap.containsKey((Object)referencedModule)) continue;
            throw ValidationException.builder().withMessage("Module '%s' is referenced by <uses-split> but does not exist.", referencedModule).build();
        }
    }

    private static void checkNoReflexiveDependencies(Multimap<String, String> moduleDependenciesMap) {
        for (String moduleName : moduleDependenciesMap.keySet()) {
            if (moduleName.equals("base") || !moduleDependenciesMap.containsEntry((Object)moduleName, (Object)moduleName)) continue;
            throw ValidationException.builder().withMessage("Module '%s' depends on itself via <uses-split>.", moduleName).build();
        }
    }

    private static void checkModulesHaveUniqueDependencies(Multimap<String, String> moduleDependenciesMap) {
        for (Map.Entry entry : moduleDependenciesMap.asMap().entrySet()) {
            String moduleName = (String)entry.getKey();
            Collection moduleDeps = (Collection)entry.getValue();
            HashSet<String> alreadyReferencedModules = new HashSet<String>();
            for (String moduleDep : moduleDeps) {
                if (alreadyReferencedModules.add(moduleDep)) continue;
                throw ValidationException.builder().withMessage("Module '%s' declares dependency on module '%s' multiple times.", moduleName, moduleDep).build();
            }
        }
    }

    private static void checkNoCycles(Multimap<String, String> moduleDependenciesMap) {
        HashSet<String> safe = new HashSet<String>();
        for (String moduleName : moduleDependenciesMap.keySet()) {
            HashSet<String> visited = new HashSet<String>();
            ModuleDependencyValidator.checkNoCycles(moduleName, moduleDependenciesMap, visited, safe, new LinkedHashSet<String>());
            safe.addAll(visited);
        }
    }

    private static void checkNoCycles(String moduleName, Multimap<String, String> moduleDependenciesMap, Set<String> visited, Set<String> safe, Set<String> processing) {
        if (safe.contains(moduleName)) {
            return;
        }
        if (processing.contains(moduleName)) {
            throw ValidationException.builder().withMessage("Found cyclic dependency between modules: %s", processing).build();
        }
        visited.add(moduleName);
        processing.add(moduleName);
        for (String referencedModule : moduleDependenciesMap.get((Object)moduleName)) {
            if (moduleName.equals(referencedModule)) continue;
            ModuleDependencyValidator.checkNoCycles(referencedModule, moduleDependenciesMap, visited, safe, processing);
        }
        processing.remove(moduleName);
    }
}

