/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.build.bundletool.validation;

import com.android.tools.build.bundletool.exceptions.BundleFileTypesException;
import com.android.tools.build.bundletool.exceptions.ValidationException;
import com.android.tools.build.bundletool.model.AbiName;
import com.android.tools.build.bundletool.model.BundleModule;
import com.android.tools.build.bundletool.model.ZipPath;
import com.android.tools.build.bundletool.validation.SubValidator;
import com.google.common.collect.ImmutableSet;
import java.util.regex.Pattern;

public class BundleFilesValidator
extends SubValidator {
    private static final Pattern CLASSES_DEX_PATTERN = Pattern.compile("classes[0-9]*\\.dex");
    private static final ImmutableSet<ZipPath> RESERVED_ROOT_APK_ENTRIES = ImmutableSet.of((Object)BundleModule.LIB_DIRECTORY, (Object)BundleModule.RESOURCES_DIRECTORY, (Object)ZipPath.create("AndroidManifest.xml"), (Object)ZipPath.create("resources.arsc"), (Object)ZipPath.create("AndroidManifest.xml"), (Object)BundleModule.RESOURCES_PROTO_PATH, (Object[])new ZipPath[0]);

    @Override
    public void validateModuleFile(ZipPath file) {
        String fileName = file.getFileName().toString();
        if (!file.startsWith(BundleModule.ASSETS_DIRECTORY)) {
            if (file.startsWith(BundleModule.DEX_DIRECTORY)) {
                if (!fileName.endsWith(".dex")) {
                    throw new BundleFileTypesException.InvalidFileExtensionInDirectoryException(BundleModule.DEX_DIRECTORY, ".dex", file);
                }
                if (!CLASSES_DEX_PATTERN.matcher(fileName).matches()) {
                    throw ValidationException.builder().withMessage("Files under %s/ must match the 'classes[0-9]*.dex' pattern, found '%s'.", BundleModule.DEX_DIRECTORY, file).build();
                }
                if (file.getNameCount() != 2) {
                    throw ValidationException.builder().withMessage("The %s/ directory cannot contain directories, found '%s'.", BundleModule.DEX_DIRECTORY, file).build();
                }
            } else if (file.startsWith(BundleModule.LIB_DIRECTORY)) {
                if (file.getNameCount() != 3) {
                    throw new BundleFileTypesException.InvalidNativeLibraryPathException(BundleModule.LIB_DIRECTORY, file);
                }
                if (!fileName.endsWith(".so")) {
                    throw new BundleFileTypesException.InvalidFileExtensionInDirectoryException(BundleModule.LIB_DIRECTORY, ".so", file);
                }
                String subDirName = file.getName(1).toString();
                if (!AbiName.fromPlatformName(subDirName).isPresent()) {
                    throw new BundleFileTypesException.InvalidNativeArchitectureException(file.subpath(0, 2));
                }
            } else if (file.startsWith(BundleModule.MANIFEST_DIRECTORY)) {
                if (!fileName.equals("AndroidManifest.xml")) {
                    throw new BundleFileTypesException.InvalidFileNameInDirectoryException("AndroidManifest.xml", BundleModule.MANIFEST_DIRECTORY, file);
                }
            } else if (file.startsWith(BundleModule.RESOURCES_DIRECTORY)) {
                if (file.getNameCount() == 2) {
                    throw new BundleFileTypesException.FilesInResourceDirectoryRootException(BundleModule.RESOURCES_DIRECTORY, file);
                }
            } else if (file.startsWith(BundleModule.ROOT_DIRECTORY)) {
                ZipPath nameUnderRoot = file.getName(1);
                if (BundleFilesValidator.isReservedRootApkEntry(nameUnderRoot)) {
                    throw new BundleFileTypesException.FileUsesReservedNameException(file, nameUnderRoot);
                }
            } else {
                throw new BundleFileTypesException.UnknownFileOrDirectoryFoundInModuleException(file);
            }
        }
    }

    private static boolean isReservedRootApkEntry(ZipPath name) {
        return RESERVED_ROOT_APK_ENTRIES.contains((Object)name) || CLASSES_DEX_PATTERN.matcher(name.toString()).matches();
    }
}

