/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.build.bundletool.validation;

import com.android.bundle.Files;
import com.android.tools.build.bundletool.exceptions.ValidationException;
import com.android.tools.build.bundletool.model.BundleModule;
import com.android.tools.build.bundletool.model.ZipPath;
import com.android.tools.build.bundletool.validation.BundleValidationUtils;
import com.android.tools.build.bundletool.validation.SubValidator;
import java.util.ArrayList;

public class AssetsTargetingValidator
extends SubValidator {
    @Override
    public void validateModule(BundleModule module) {
        module.getAssetsConfig().ifPresent(targeting -> this.validateTargeting(module, (Files.Assets)targeting));
    }

    private void validateTargeting(BundleModule module, Files.Assets assets) {
        ArrayList<String> targetedDirs = new ArrayList<String>();
        for (Files.TargetedAssetsDirectory targetedDirectory : assets.getDirectoryList()) {
            ZipPath path = ZipPath.create(targetedDirectory.getPath());
            if (!path.startsWith(BundleModule.ASSETS_DIRECTORY)) {
                throw ValidationException.builder().withMessage("Path of targeted assets directory must start with 'assets/' but found '%s'.", path).build();
            }
            if (BundleValidationUtils.directoryContainsNoFiles(module, path)) {
                throw ValidationException.builder().withMessage("Targeted directory '%s' is empty.", path).build();
            }
            targetedDirs.add(path.toString());
        }
    }
}

