/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.build.bundletool.targeting;

import com.android.bundle.Files;
import com.android.bundle.Targeting;
import com.android.tools.build.bundletool.exceptions.ValidationException;
import com.android.tools.build.bundletool.model.AbiName;
import com.android.tools.build.bundletool.model.ZipPath;
import com.android.tools.build.bundletool.targeting.TargetedDirectory;
import com.android.tools.build.bundletool.targeting.TargetedDirectorySegment;
import com.android.tools.build.bundletool.targeting.TargetingDimension;
import com.android.tools.build.bundletool.targeting.TargetingUtils;
import com.android.tools.build.bundletool.utils.files.FileUtils;
import com.google.common.base.Preconditions;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Multimap;
import com.google.common.collect.Sets;
import java.util.Collection;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;

public class TargetingGenerator {
    private static final String ASSETS_DIR = "assets/";
    private static final String LIB_DIR = "lib/";

    public Files.Assets generateTargetingForAssets(Collection<ZipPath> assetDirectories) {
        for (ZipPath zipPath : assetDirectories) {
            TargetingGenerator.checkRootDirectoryName(ASSETS_DIR, zipPath + "/");
        }
        HashMultimap targetingByBaseName = HashMultimap.create();
        for (ZipPath assetDirectory : FileUtils.toPathWalkingOrder(assetDirectories)) {
            TargetedDirectory targetedDirectory = TargetedDirectory.parse(assetDirectory);
            targetingByBaseName.put((Object)targetedDirectory.getPathBaseName(), (Object)targetedDirectory.getLastSegment().getTargeting());
        }
        this.validateDimensions((Multimap<String, Targeting.AssetsDirectoryTargeting>)targetingByBaseName);
        Files.Assets.Builder builder2 = Files.Assets.newBuilder();
        for (ZipPath assetDirectory : assetDirectories) {
            Targeting.AssetsDirectoryTargeting.Builder targeting = Targeting.AssetsDirectoryTargeting.newBuilder();
            TargetedDirectory targetedDirectory = TargetedDirectory.parse(assetDirectory);
            for (int i = 0; i < targetedDirectory.getPathSegments().size(); ++i) {
                TargetedDirectorySegment segment = (TargetedDirectorySegment)targetedDirectory.getPathSegments().get(i);
                targeting.mergeFrom(segment.getTargeting());
                if (segment.getTargeting().hasLanguage()) continue;
                targeting.mergeFrom(Sets.difference((Set)targetingByBaseName.get((Object)targetedDirectory.getSubPathBaseName(i)), (Set)ImmutableSet.of((Object)segment.getTargeting())).stream().map(TargetingUtils::toAlternativeTargeting).reduce(Targeting.AssetsDirectoryTargeting.newBuilder(), (builder, targetingValue) -> builder.mergeFrom((Targeting.AssetsDirectoryTargeting)targetingValue), (builderA, builderB) -> builderA.mergeFrom(builderB.build())).build());
            }
            builder2.addDirectory(Files.TargetedAssetsDirectory.newBuilder().setPath(assetDirectory.toString()).setTargeting(targeting));
        }
        return builder2.build();
    }

    private void validateDimensions(Multimap<String, Targeting.AssetsDirectoryTargeting> targetingMultimap) {
        for (String baseName : targetingMultimap.keySet()) {
            ImmutableList distinctDimensions = (ImmutableList)targetingMultimap.get((Object)baseName).stream().map(TargetingUtils::getTargetingDimensions).flatMap(Collection::stream).distinct().collect(ImmutableList.toImmutableList());
            if (distinctDimensions.size() <= 1) continue;
            throw ValidationException.builder().withMessage("Expected at most one dimension type used for targeting of '%s'. However, the following dimensions were used: %s.", baseName, TargetingGenerator.joinDimensions((ImmutableList<TargetingDimension>)distinctDimensions)).build();
        }
    }

    private static String joinDimensions(ImmutableList<TargetingDimension> dimensions) {
        return dimensions.stream().map(dimension -> String.format("'%s'", dimension)).sorted().collect(Collectors.joining(", "));
    }

    public Files.NativeLibraries generateTargetingForNativeLibraries(Collection<String> libDirectories) {
        Files.NativeLibraries.Builder nativeLibraries = Files.NativeLibraries.newBuilder();
        for (String directory : libDirectories) {
            TargetingGenerator.checkRootDirectoryName(LIB_DIR, directory);
            String abiName = directory.substring(LIB_DIR.length());
            Targeting.Abi abi = TargetingGenerator.checkAbiName(abiName, directory);
            nativeLibraries.addDirectory(Files.TargetedNativeDirectory.newBuilder().setPath(directory).setTargeting(Targeting.NativeDirectoryTargeting.newBuilder().setAbi(abi)).build());
        }
        return nativeLibraries.build();
    }

    private static String checkRootDirectoryName(String rootName, String forDirectory) {
        Preconditions.checkArgument((boolean)rootName.endsWith("/"), (String)"'%s' does not end with '/'.", (Object)rootName);
        Preconditions.checkArgument((boolean)forDirectory.startsWith(rootName), (String)"Directory '%s' must start with '%s'.", (Object)forDirectory, (Object)rootName);
        return rootName;
    }

    private static Targeting.Abi checkAbiName(String token, String forDirectory) {
        Optional<AbiName> abiName = AbiName.fromPlatformName(token);
        if (!abiName.isPresent()) {
            Optional<AbiName> abiNameLowerCase = AbiName.fromPlatformName(token.toLowerCase());
            if (abiNameLowerCase.isPresent()) {
                throw ValidationException.builder().withMessage("Expecting ABI name in directory '%s', but found '%s' which is not recognized. Did you mean '%s'?", forDirectory, token, token.toLowerCase()).build();
            }
            throw ValidationException.builder().withMessage("Expecting ABI name in directory '%s', but found '%s' which is not recognized.", forDirectory, token).build();
        }
        return Targeting.Abi.newBuilder().setAlias(abiName.get().toProto()).build();
    }
}

