/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.build.bundletool.targeting;

import com.android.bundle.Targeting;
import com.android.tools.build.bundletool.model.GeneratedApks;
import com.android.tools.build.bundletool.model.ModuleSplit;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableCollection;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.Sets;
import com.google.protobuf.Message;
import java.util.Arrays;
import java.util.Collection;
import java.util.Set;
import javax.annotation.CheckReturnValue;

public abstract class AlternativeVariantTargetingPopulator<T extends Message> {
    public static GeneratedApks populateAlternativeVariantTargeting(GeneratedApks generatedApks) {
        ImmutableList<ModuleSplit> standaloneApks = new AbiAlternativesPopulator().addAlternativeVariantTargeting(generatedApks.getStandaloneApks());
        standaloneApks = new ScreenDensityAlternativesPopulator().addAlternativeVariantTargeting(standaloneApks);
        return GeneratedApks.fromModuleSplits(new SdkVersionAlternativesPopulator().addAlternativeVariantTargeting(generatedApks.getSplitApks(), standaloneApks));
    }

    @CheckReturnValue
    ImmutableList<ModuleSplit> addAlternativeVariantTargeting(ImmutableList<ModuleSplit> ... splits) {
        return this.addAlternativeVariantTargeting((ImmutableList<ModuleSplit>)((ImmutableList)Arrays.stream(splits).flatMap(Collection::stream).collect(ImmutableList.toImmutableList())));
    }

    @CheckReturnValue
    ImmutableList<ModuleSplit> addAlternativeVariantTargeting(ImmutableList<ModuleSplit> apks) {
        ImmutableList<Targeting.VariantTargeting> variantTargeting = (ImmutableList<Targeting.VariantTargeting>)apks.stream().map(ModuleSplit::getVariantTargeting).collect(ImmutableList.toImmutableList());
        Preconditions.checkState(((variantTargeting = this.addAlternativeVariantTargetingInternal(variantTargeting)).size() == apks.size() ? 1 : 0) != 0);
        ImmutableList.Builder result = ImmutableList.builder();
        for (int i = 0; i < apks.size(); ++i) {
            result.add((Object)((ModuleSplit)apks.get(i)).toBuilder().setVariantTargeting((Targeting.VariantTargeting)variantTargeting.get(i)).build());
        }
        return result.build();
    }

    @CheckReturnValue
    ImmutableList<Targeting.VariantTargeting> addAlternativeVariantTargetingInternal(ImmutableList<Targeting.VariantTargeting> variantTargetings) {
        ImmutableSet dimensionIsTargeted = (ImmutableSet)variantTargetings.stream().map(variantTargeting -> !this.getValues((Targeting.VariantTargeting)variantTargeting).isEmpty()).collect(ImmutableSet.toImmutableSet());
        Preconditions.checkArgument((dimensionIsTargeted.size() <= 1 ? 1 : 0) != 0, (Object)"Some variants are agnostic to the dimension, and some are not.");
        if (variantTargetings.isEmpty() || !((Boolean)Iterables.getOnlyElement((Iterable)dimensionIsTargeted)).booleanValue()) {
            return variantTargetings;
        }
        ImmutableSet allValues = (ImmutableSet)variantTargetings.stream().flatMap(variantTargeting -> this.getValues((Targeting.VariantTargeting)variantTargeting).stream()).collect(ImmutableSet.toImmutableSet());
        return (ImmutableList)variantTargetings.stream().map(variantTargeting -> {
            Targeting.VariantTargeting.Builder result = variantTargeting.toBuilder();
            this.setDimensionAlternatives(result, (ImmutableCollection<T>)ImmutableSet.copyOf((Collection)Sets.difference((Set)allValues, (Set)ImmutableSet.copyOf(this.getValues((Targeting.VariantTargeting)variantTargeting)))));
            return result.build();
        }).collect(ImmutableList.toImmutableList());
    }

    protected abstract ImmutableList<T> getValues(Targeting.VariantTargeting var1);

    protected abstract void setDimensionAlternatives(Targeting.VariantTargeting.Builder var1, ImmutableCollection<T> var2);

    @VisibleForTesting
    static class SdkVersionAlternativesPopulator
    extends AlternativeVariantTargetingPopulator<Targeting.SdkVersion> {
        SdkVersionAlternativesPopulator() {
        }

        @Override
        protected ImmutableList<Targeting.SdkVersion> getValues(Targeting.VariantTargeting targeting) {
            return ImmutableList.copyOf(targeting.getSdkVersionTargeting().getValueList());
        }

        @Override
        protected void setDimensionAlternatives(Targeting.VariantTargeting.Builder targetingBuilder, ImmutableCollection<Targeting.SdkVersion> alternatives) {
            targetingBuilder.getSdkVersionTargetingBuilder().clearAlternatives().addAllAlternatives((Iterable<? extends Targeting.SdkVersion>)alternatives);
        }
    }

    @VisibleForTesting
    static class ScreenDensityAlternativesPopulator
    extends AlternativeVariantTargetingPopulator<Targeting.ScreenDensity> {
        ScreenDensityAlternativesPopulator() {
        }

        @Override
        protected ImmutableList<Targeting.ScreenDensity> getValues(Targeting.VariantTargeting targeting) {
            return ImmutableList.copyOf(targeting.getScreenDensityTargeting().getValueList());
        }

        @Override
        protected void setDimensionAlternatives(Targeting.VariantTargeting.Builder targetingBuilder, ImmutableCollection<Targeting.ScreenDensity> alternatives) {
            targetingBuilder.getScreenDensityTargetingBuilder().clearAlternatives().addAllAlternatives((Iterable<? extends Targeting.ScreenDensity>)alternatives);
        }
    }

    @VisibleForTesting
    static class AbiAlternativesPopulator
    extends AlternativeVariantTargetingPopulator<Targeting.Abi> {
        AbiAlternativesPopulator() {
        }

        @Override
        protected ImmutableList<Targeting.Abi> getValues(Targeting.VariantTargeting targeting) {
            return ImmutableList.copyOf(targeting.getAbiTargeting().getValueList());
        }

        @Override
        protected void setDimensionAlternatives(Targeting.VariantTargeting.Builder targetingBuilder, ImmutableCollection<Targeting.Abi> alternatives) {
            targetingBuilder.getAbiTargetingBuilder().clearAlternatives().addAllAlternatives((Iterable<? extends Targeting.Abi>)alternatives);
        }
    }
}

