/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.build.bundletool.splitters;

import com.android.bundle.Targeting;
import com.android.tools.build.bundletool.exceptions.CommandExecutionException;
import com.android.tools.build.bundletool.mergers.SameTargetingMerger;
import com.android.tools.build.bundletool.model.BundleModule;
import com.android.tools.build.bundletool.model.ModuleSplit;
import com.android.tools.build.bundletool.model.OptimizationDimension;
import com.android.tools.build.bundletool.splitters.AbiNativeLibrariesSplitter;
import com.android.tools.build.bundletool.splitters.LanguageAssetsSplitter;
import com.android.tools.build.bundletool.splitters.LanguageResourcesSplitter;
import com.android.tools.build.bundletool.splitters.ModuleSplitSplitter;
import com.android.tools.build.bundletool.splitters.ScreenDensityResourcesSplitter;
import com.android.tools.build.bundletool.splitters.SplittingPipeline;
import com.android.tools.build.bundletool.version.Version;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableCollection;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.protobuf.Int32Value;
import java.util.HashSet;
import java.util.Optional;
import java.util.Set;
import javax.annotation.concurrent.GuardedBy;

public class ModuleSplitter {
    private final BundleModule module;
    private final ImmutableSet<OptimizationDimension> optimizationDimensions;
    private final SuffixManager suffixManager = new SuffixManager();
    private final Version bundleVersion;

    public ModuleSplitter(BundleModule module, ImmutableSet<OptimizationDimension> optimizationDimensions, Version bundleVersion) {
        this.optimizationDimensions = optimizationDimensions;
        this.module = module;
        this.bundleVersion = bundleVersion;
    }

    public ImmutableList<ModuleSplit> splitModule() {
        return (ImmutableList)this.splitModuleInternal().stream().map(this::addLPlusTargeting).map(this::writeSplitIdInManifest).collect(ImmutableList.toImmutableList());
    }

    private ImmutableList<ModuleSplit> splitModuleInternal() {
        if (ModuleSplitter.targetsOnlyPreL(this.module)) {
            throw CommandExecutionException.builder().withMessage("Cannot split module '%s' because it does not target devices on Android L or above.", this.module.getName()).build();
        }
        ImmutableList.Builder splits = ImmutableList.builder();
        SplittingPipeline resourcesPipeline = this.createResourcesSplittingPipeline();
        splits.addAll(resourcesPipeline.split(ModuleSplit.forResources(this.module)));
        SplittingPipeline nativePipeline = this.createNativeLibrariesSplittingPipeline();
        splits.addAll(nativePipeline.split(ModuleSplit.forNativeLibraries(this.module)));
        SplittingPipeline assetsPipeline = this.createAssetsSplittingPipeline();
        splits.addAll(assetsPipeline.split(ModuleSplit.forAssets(this.module)));
        splits.add((Object)ModuleSplit.forCode(this.module));
        splits.add((Object)ModuleSplit.forRoot(this.module));
        ImmutableList<ModuleSplit> mergedSplits = new SameTargetingMerger().merge((ImmutableCollection<ModuleSplit>)splits.build());
        ImmutableList defaultTargetingSplits = (ImmutableList)mergedSplits.stream().filter(split -> split.getApkTargeting().equals(Targeting.ApkTargeting.getDefaultInstance())).collect(ImmutableList.toImmutableList());
        Preconditions.checkState((defaultTargetingSplits.size() == 1 ? 1 : 0) != 0, (Object)"Expected one split with default targeting.");
        return mergedSplits;
    }

    public ModuleSplit writeSplitIdInManifest(ModuleSplit moduleSplit) {
        String resolvedSuffix = this.suffixManager.resolveSuffix(moduleSplit.getSuffix());
        return moduleSplit.writeSplitIdInManifest(resolvedSuffix);
    }

    private SplittingPipeline createResourcesSplittingPipeline() {
        ImmutableList.Builder resourceSplitters = ImmutableList.builder();
        if (this.optimizationDimensions.contains((Object)OptimizationDimension.SCREEN_DENSITY)) {
            resourceSplitters.add((Object)new ScreenDensityResourcesSplitter(this.bundleVersion));
        }
        if (this.optimizationDimensions.contains((Object)OptimizationDimension.LANGUAGE)) {
            resourceSplitters.add((Object)new LanguageResourcesSplitter());
        }
        return SplittingPipeline.create((ImmutableList<ModuleSplitSplitter>)resourceSplitters.build());
    }

    private SplittingPipeline createNativeLibrariesSplittingPipeline() {
        ImmutableList.Builder nativeSplitters = ImmutableList.builder();
        if (this.optimizationDimensions.contains((Object)OptimizationDimension.ABI)) {
            nativeSplitters.add((Object)new AbiNativeLibrariesSplitter());
        }
        return SplittingPipeline.create((ImmutableList<ModuleSplitSplitter>)nativeSplitters.build());
    }

    private SplittingPipeline createAssetsSplittingPipeline() {
        ImmutableList.Builder assetsSplitters = ImmutableList.builder();
        if (this.optimizationDimensions.contains((Object)OptimizationDimension.LANGUAGE)) {
            assetsSplitters.add((Object)LanguageAssetsSplitter.create());
        }
        return SplittingPipeline.create((ImmutableList<ModuleSplitSplitter>)assetsSplitters.build());
    }

    private static boolean targetsOnlyPreL(BundleModule module) {
        Optional<Integer> maxSdkVersion = module.getAndroidManifest().getMaxSdkVersion();
        return maxSdkVersion.isPresent() && maxSdkVersion.get() < 21;
    }

    private ModuleSplit addLPlusTargeting(ModuleSplit split) {
        Preconditions.checkState((!split.getApkTargeting().hasSdkVersionTargeting() ? 1 : 0) != 0, (Object)"Split already targets SDK version.");
        return split.toBuilder().setApkTargeting(split.getApkTargeting().toBuilder().setSdkVersionTargeting(Targeting.SdkVersionTargeting.newBuilder().addValue(Targeting.SdkVersion.newBuilder().setMin(Int32Value.newBuilder().setValue(21)))).build()).build();
    }

    private static class SuffixManager {
        @GuardedBy(value="this")
        private final Set<String> usedSuffixes = new HashSet<String>();

        private SuffixManager() {
        }

        synchronized String resolveSuffix(String proposedSuffix) {
            String currentProposal = proposedSuffix;
            int serialNumber = 1;
            while (this.usedSuffixes.contains(currentProposal)) {
                currentProposal = String.format("%s_%d", proposedSuffix, ++serialNumber);
            }
            this.usedSuffixes.add(currentProposal);
            return currentProposal;
        }
    }
}

