/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.build.bundletool.io;

import com.android.bundle.Commands;
import com.android.bundle.Devices;
import com.android.bundle.Targeting;
import com.android.tools.build.bundletool.device.ApkMatcher;
import com.android.tools.build.bundletool.io.ApkSetBuilderFactory;
import com.android.tools.build.bundletool.model.AppBundle;
import com.android.tools.build.bundletool.model.BundleModule;
import com.android.tools.build.bundletool.model.GeneratedApks;
import com.android.tools.build.bundletool.model.ModuleSplit;
import com.android.tools.build.bundletool.utils.ConcurrencyUtils;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableListMultimap;
import com.google.common.collect.Multimaps;
import com.google.common.util.concurrent.ListeningExecutorService;
import java.util.Collection;
import java.util.stream.Stream;

public class ApkSerializerManager {
    private static final Commands.ModuleMetadata STANDALONE_MODULE_METADATA = Commands.ModuleMetadata.newBuilder().setName("base").build();
    private final ListeningExecutorService executorService;

    public ApkSerializerManager(ListeningExecutorService executorService) {
        this.executorService = executorService;
    }

    public ImmutableList<Commands.Variant> serializeApks(GeneratedApks generatedApks, ApkSetBuilderFactory.ApkSetBuilder apkSetBuilder, AppBundle appBundle, boolean isUniversalApk) {
        Preconditions.checkArgument((generatedApks.getSplitApks().isEmpty() || !isUniversalApk ? 1 : 0) != 0, (Object)"Internal error: For universal APK expecting only standalone APKs.");
        ImmutableList<Commands.Variant> standaloneVariants = this.serializeStandaloneApks(generatedApks.getStandaloneApks(), apkSetBuilder, isUniversalApk);
        ImmutableList<Commands.Variant> splitVariants = this.serializeSplitApks(generatedApks.getSplitApks(), apkSetBuilder, appBundle);
        return (ImmutableList)Stream.of(standaloneVariants, splitVariants).flatMap(Collection::stream).collect(ImmutableList.toImmutableList());
    }

    public Commands.Variant serializeApksForDevice(Devices.DeviceSpec deviceSpec, GeneratedApks generatedApks, ApkSetBuilderFactory.ApkSetBuilder apkSetBuilder, AppBundle appBundle) {
        ImmutableList<ModuleSplit> filteredStandaloneApks = ApkSerializerManager.filterApksForDevice(generatedApks.getStandaloneApks(), deviceSpec);
        ImmutableList<Commands.Variant> variantList = !filteredStandaloneApks.isEmpty() ? this.serializeStandaloneApks(filteredStandaloneApks, apkSetBuilder, false) : this.serializeSplitApks(ApkSerializerManager.filterApksForDevice(generatedApks.getSplitApks(), deviceSpec), apkSetBuilder, appBundle);
        Preconditions.checkState((variantList.size() == 1 ? 1 : 0) != 0);
        return (Commands.Variant)variantList.get(0);
    }

    private ImmutableList<Commands.Variant> serializeSplitApks(ImmutableList<ModuleSplit> splitApks, ApkSetBuilderFactory.ApkSetBuilder apkSetBuilder, AppBundle appBundle) {
        ImmutableListMultimap targetingToSplits = Multimaps.index(splitApks, ModuleSplit::getVariantTargeting);
        ImmutableList.Builder variantsBuilder = ImmutableList.builder();
        for (Targeting.VariantTargeting variantTargeting : targetingToSplits.keySet()) {
            ImmutableListMultimap splitsByModule = Multimaps.index((Iterable)targetingToSplits.get((Object)variantTargeting), moduleSplit -> appBundle.getModule(moduleSplit.getModuleName()));
            Commands.Variant.Builder variantBuilder = Commands.Variant.newBuilder().setTargeting(variantTargeting);
            for (BundleModule module : splitsByModule.keySet()) {
                ImmutableList apkDescriptions = ConcurrencyUtils.waitForAll((Iterable)splitsByModule.get((Object)module).stream().map(splitApk -> this.executorService.submit(() -> apkSetBuilder.addSplitApk((ModuleSplit)splitApk))).collect(ImmutableList.toImmutableList()));
                variantBuilder.addApkSet(Commands.ApkSet.newBuilder().setModuleMetadata(module.getModuleMetadata()).addAllApkDescription((Iterable<? extends Commands.ApkDescription>)apkDescriptions).build());
            }
            variantsBuilder.add((Object)variantBuilder.build());
        }
        return variantsBuilder.build();
    }

    private ImmutableList<Commands.Variant> serializeStandaloneApks(ImmutableList<ModuleSplit> standaloneApks, ApkSetBuilderFactory.ApkSetBuilder apkSetBuilder, boolean isUniversalApk) {
        return ConcurrencyUtils.waitForAll((Iterable)standaloneApks.stream().map(standaloneApk -> this.executorService.submit(() -> this.writeStandaloneApkVariant((ModuleSplit)standaloneApk, isUniversalApk, apkSetBuilder))).collect(ImmutableList.toImmutableList()));
    }

    private Commands.Variant writeStandaloneApkVariant(ModuleSplit standaloneApk, boolean isUniversalApk, ApkSetBuilderFactory.ApkSetBuilder apkSetBuilder) {
        Commands.ApkDescription apkDescription = isUniversalApk ? apkSetBuilder.addStandaloneUniversalApk(standaloneApk) : apkSetBuilder.addStandaloneApk(standaloneApk);
        return Commands.Variant.newBuilder().setTargeting(standaloneApk.getVariantTargeting()).addApkSet(Commands.ApkSet.newBuilder().setModuleMetadata(STANDALONE_MODULE_METADATA).addApkDescription(apkDescription)).build();
    }

    private static ImmutableList<ModuleSplit> filterApksForDevice(ImmutableList<ModuleSplit> allApks, Devices.DeviceSpec deviceSpec) {
        ApkMatcher apkMatcher = new ApkMatcher(deviceSpec);
        return (ImmutableList)allApks.stream().filter(apkMatcher::matchesModuleSplit).collect(ImmutableList.toImmutableList());
    }
}

