/*
 * Decompiled with CFR 0.152.
 */
package shadow.bundletool.com.android.tools.r8.utils;

import java.io.IOException;
import java.nio.file.FileSystemException;
import java.nio.file.Paths;
import java.util.concurrent.ExecutionException;
import java.util.function.Consumer;
import shadow.bundletool.com.android.tools.r8.CompilationFailedException;
import shadow.bundletool.com.android.tools.r8.DiagnosticsHandler;
import shadow.bundletool.com.android.tools.r8.ResourceException;
import shadow.bundletool.com.android.tools.r8.StringConsumer;
import shadow.bundletool.com.android.tools.r8.Version;
import shadow.bundletool.com.android.tools.r8.com.google.common.collect.ObjectArrays;
import shadow.bundletool.com.android.tools.r8.errors.CompilationError;
import shadow.bundletool.com.android.tools.r8.origin.Origin;
import shadow.bundletool.com.android.tools.r8.origin.PathOrigin;
import shadow.bundletool.com.android.tools.r8.utils.AbortException;
import shadow.bundletool.com.android.tools.r8.utils.ExceptionDiagnostic;
import shadow.bundletool.com.android.tools.r8.utils.Reporter;

public abstract class ExceptionUtils {
    public static final int STATUS_ERROR = 1;

    public static void withConsumeResourceHandler(Reporter reporter, StringConsumer consumer, String data2) {
        ExceptionUtils.withConsumeResourceHandler(reporter, handler -> consumer.accept(data2, (DiagnosticsHandler)handler));
    }

    public static void withFinishedResourceHandler(Reporter reporter, StringConsumer consumer) {
        ExceptionUtils.withConsumeResourceHandler(reporter, consumer::finished);
    }

    public static void withConsumeResourceHandler(Reporter reporter, Consumer<DiagnosticsHandler> consumer) {
        consumer.accept(reporter);
        reporter.failIfPendingErrors();
    }

    public static void withD8CompilationHandler(Reporter reporter, CompileAction action) throws CompilationFailedException {
        ExceptionUtils.withCompilationHandler(reporter, action);
    }

    public static void withR8CompilationHandler(Reporter reporter, CompileAction action) throws CompilationFailedException {
        ExceptionUtils.withCompilationHandler(reporter, action);
    }

    public static void withMainDexListHandler(Reporter reporter, CompileAction action) throws CompilationFailedException {
        ExceptionUtils.withCompilationHandler(reporter, action);
    }

    public static void withCompilationHandler(Reporter reporter, CompileAction action) throws CompilationFailedException {
        try {
            try {
                action.run();
            }
            catch (IOException e) {
                throw reporter.fatalError(new ExceptionDiagnostic(e, ExceptionUtils.extractIOExceptionOrigin(e)));
            }
            catch (CompilationError e) {
                throw reporter.fatalError(e.toStringDiagnostic());
            }
            catch (ResourceException e) {
                throw reporter.fatalError(new ExceptionDiagnostic(e, e.getOrigin()));
            }
            catch (AssertionError e) {
                throw reporter.fatalError(new ExceptionDiagnostic((Throwable)((Object)e), Origin.unknown()));
            }
            catch (Exception e) {
                String filename = "Version_2.0.23.java";
                StackTraceElement versionElement = new StackTraceElement(Version.class.getSimpleName(), "fakeStackEntry", filename, 0);
                StackTraceElement[] withVersion = ObjectArrays.concat(versionElement, e.getStackTrace());
                e.setStackTrace(withVersion);
                throw e;
            }
            reporter.failIfPendingErrors();
        }
        catch (AbortException e) {
            throw new CompilationFailedException(e);
        }
    }

    public static void withMainProgramHandler(MainAction action) {
        try {
            action.run();
        }
        catch (CompilationFailedException | AbortException e) {
            System.err.println("Compilation failed");
            System.exit(1);
        }
        catch (RuntimeException e) {
            System.err.println("Compilation failed with an internal error.");
            Throwable cause = e.getCause() == null ? e : e.getCause();
            cause.printStackTrace();
            System.exit(1);
        }
    }

    public static Origin extractIOExceptionOrigin(IOException e) {
        FileSystemException fse;
        if (e instanceof FileSystemException && (fse = (FileSystemException)e).getFile() != null && !fse.getFile().isEmpty()) {
            return new PathOrigin(Paths.get(fse.getFile(), new String[0]));
        }
        return Origin.unknown();
    }

    public static RuntimeException unwrapExecutionException(ExecutionException executionException) {
        Throwable cause = executionException.getCause();
        if (cause instanceof Error) {
            cause.addSuppressed(executionException);
            throw (Error)cause;
        }
        if (cause instanceof RuntimeException) {
            cause.addSuppressed(executionException);
            throw (RuntimeException)cause;
        }
        throw new RuntimeException(executionException.getMessage(), cause);
    }

    public static interface MainAction {
        public void run() throws CompilationFailedException;
    }

    public static interface CompileAction {
        public void run() throws IOException, CompilationError, ResourceException;
    }
}

