/*
 * Decompiled with CFR 0.152.
 */
package shadow.bundletool.com.android.tools.r8.utils;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import shadow.bundletool.com.android.tools.r8.ProgramResource;
import shadow.bundletool.com.android.tools.r8.ProgramResourceProvider;
import shadow.bundletool.com.android.tools.r8.ResourceException;
import shadow.bundletool.com.android.tools.r8.it.unimi.dsi.fastutil.ints.Int2ReferenceOpenHashMap;
import shadow.bundletool.com.android.tools.r8.org.objectweb.asm.ClassReader;
import shadow.bundletool.com.android.tools.r8.org.objectweb.asm.Label;
import shadow.bundletool.com.android.tools.r8.org.objectweb.asm.MethodVisitor;
import shadow.bundletool.com.android.tools.r8.utils.AndroidApp;
import shadow.bundletool.com.android.tools.r8.utils.StreamUtils;

public class CfLineToMethodMapper {
    private final Map<String, Int2ReferenceOpenHashMap<String>> sourceMethodMapping = new HashMap<String, Int2ReferenceOpenHashMap<String>>();
    private final AndroidApp inputApp;
    private static final String NAME_DESCRIPTOR_SEPARATOR = ";;";

    public CfLineToMethodMapper(AndroidApp inputApp) {
        this.inputApp = inputApp;
    }

    public String lookupNameAndDescriptor(String binaryName, int lineNumber) throws IOException, ResourceException {
        Int2ReferenceOpenHashMap<String> lineMappings;
        if (this.sourceMethodMapping.isEmpty()) {
            this.readLineNumbersFromClassFiles();
        }
        return (lineMappings = this.sourceMethodMapping.get(binaryName)) == null ? null : lineMappings.get(lineNumber);
    }

    private void readLineNumbersFromClassFiles() throws ResourceException, IOException {
        ClassVisitor classVisitor = new ClassVisitor();
        for (ProgramResourceProvider resourceProvider : this.inputApp.getProgramResourceProviders()) {
            for (ProgramResource programResource : resourceProvider.getProgramResources()) {
                if (programResource.getKind() != ProgramResource.Kind.CF) continue;
                new ClassReader(StreamUtils.StreamToByteArrayClose(programResource.getByteStream())).accept(classVisitor, 4);
            }
        }
    }

    public static String getName(String nameAndDescriptor) {
        int index = nameAndDescriptor.indexOf(NAME_DESCRIPTOR_SEPARATOR);
        assert (index > 0);
        return nameAndDescriptor.substring(0, index);
    }

    public static String getDescriptor(String nameAndDescriptor) {
        int index = nameAndDescriptor.indexOf(NAME_DESCRIPTOR_SEPARATOR);
        assert (index > 0);
        return nameAndDescriptor.substring(index + NAME_DESCRIPTOR_SEPARATOR.length());
    }

    private static class MethodLineVisitor
    extends MethodVisitor {
        private final String nameAndDescriptor;
        private final Map<Integer, String> lineMethodMapping;

        private MethodLineVisitor(String nameAndDescriptor, Map<Integer, String> lineMethodMapping) {
            super(458752);
            this.nameAndDescriptor = nameAndDescriptor;
            this.lineMethodMapping = lineMethodMapping;
        }

        @Override
        public void visitLineNumber(int line, Label start) {
            this.lineMethodMapping.put(line, this.nameAndDescriptor);
        }
    }

    private class ClassVisitor
    extends shadow.bundletool.com.android.tools.r8.org.objectweb.asm.ClassVisitor {
        private Int2ReferenceOpenHashMap<String> currentLineNumberMapping;

        private ClassVisitor() {
            super(458752);
            this.currentLineNumberMapping = null;
        }

        @Override
        public void visit(int version, int access, String name, String signature, String superName, String[] interfaces) {
            super.visit(version, access, name, signature, superName, interfaces);
            this.currentLineNumberMapping = CfLineToMethodMapper.this.sourceMethodMapping.computeIfAbsent(name, ignored -> new Int2ReferenceOpenHashMap());
        }

        @Override
        public MethodVisitor visitMethod(int access, String name, String descriptor, String signature, String[] exceptions) {
            return new MethodLineVisitor(name + CfLineToMethodMapper.NAME_DESCRIPTOR_SEPARATOR + descriptor, this.currentLineNumberMapping);
        }
    }
}

