/*
 * Decompiled with CFR 0.152.
 */
package shadow.bundletool.com.android.tools.r8.shaking;

import java.io.PrintStream;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.Set;
import java.util.Stack;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import shadow.bundletool.com.android.tools.r8.com.google.common.base.Equivalence;
import shadow.bundletool.com.android.tools.r8.com.google.common.collect.ImmutableList;
import shadow.bundletool.com.android.tools.r8.com.google.common.collect.ImmutableMap;
import shadow.bundletool.com.android.tools.r8.com.google.common.collect.ImmutableSet;
import shadow.bundletool.com.android.tools.r8.com.google.common.collect.Lists;
import shadow.bundletool.com.android.tools.r8.com.google.common.collect.Sets;
import shadow.bundletool.com.android.tools.r8.com.google.common.collect.Streams;
import shadow.bundletool.com.android.tools.r8.errors.Unreachable;
import shadow.bundletool.com.android.tools.r8.graph.AppInfo;
import shadow.bundletool.com.android.tools.r8.graph.AppInfoWithSubtyping;
import shadow.bundletool.com.android.tools.r8.graph.AppView;
import shadow.bundletool.com.android.tools.r8.graph.BottomUpClassHierarchyTraversal;
import shadow.bundletool.com.android.tools.r8.graph.DexAnnotation;
import shadow.bundletool.com.android.tools.r8.graph.DexAnnotationSet;
import shadow.bundletool.com.android.tools.r8.graph.DexApplication;
import shadow.bundletool.com.android.tools.r8.graph.DexClass;
import shadow.bundletool.com.android.tools.r8.graph.DexDefinition;
import shadow.bundletool.com.android.tools.r8.graph.DexEncodedField;
import shadow.bundletool.com.android.tools.r8.graph.DexEncodedMethod;
import shadow.bundletool.com.android.tools.r8.graph.DexField;
import shadow.bundletool.com.android.tools.r8.graph.DexItem;
import shadow.bundletool.com.android.tools.r8.graph.DexLibraryClass;
import shadow.bundletool.com.android.tools.r8.graph.DexMethod;
import shadow.bundletool.com.android.tools.r8.graph.DexProgramClass;
import shadow.bundletool.com.android.tools.r8.graph.DexReference;
import shadow.bundletool.com.android.tools.r8.graph.DexType;
import shadow.bundletool.com.android.tools.r8.graph.DirectMappedDexApplication;
import shadow.bundletool.com.android.tools.r8.graph.ProgramMethod;
import shadow.bundletool.com.android.tools.r8.graph.ResolutionResult;
import shadow.bundletool.com.android.tools.r8.ir.analysis.proto.GeneratedMessageLiteBuilderShrinker;
import shadow.bundletool.com.android.tools.r8.logging.Log;
import shadow.bundletool.com.android.tools.r8.shaking.AppInfoWithLiveness;
import shadow.bundletool.com.android.tools.r8.shaking.ClassInlineRule;
import shadow.bundletool.com.android.tools.r8.shaking.ClassMergingRule;
import shadow.bundletool.com.android.tools.r8.shaking.ConstantArgumentRule;
import shadow.bundletool.com.android.tools.r8.shaking.DelayedRootSetActionItem;
import shadow.bundletool.com.android.tools.r8.shaking.DexStringCache;
import shadow.bundletool.com.android.tools.r8.shaking.InlineRule;
import shadow.bundletool.com.android.tools.r8.shaking.MemberValuePropagationRule;
import shadow.bundletool.com.android.tools.r8.shaking.ProguardAssumeMayHaveSideEffectsRule;
import shadow.bundletool.com.android.tools.r8.shaking.ProguardAssumeNoSideEffectRule;
import shadow.bundletool.com.android.tools.r8.shaking.ProguardAssumeValuesRule;
import shadow.bundletool.com.android.tools.r8.shaking.ProguardCheckDiscardRule;
import shadow.bundletool.com.android.tools.r8.shaking.ProguardConfigurationRule;
import shadow.bundletool.com.android.tools.r8.shaking.ProguardIdentifierNameStringRule;
import shadow.bundletool.com.android.tools.r8.shaking.ProguardIfRule;
import shadow.bundletool.com.android.tools.r8.shaking.ProguardKeepRule;
import shadow.bundletool.com.android.tools.r8.shaking.ProguardKeepRuleBase;
import shadow.bundletool.com.android.tools.r8.shaking.ProguardKeepRuleModifiers;
import shadow.bundletool.com.android.tools.r8.shaking.ProguardMemberRule;
import shadow.bundletool.com.android.tools.r8.shaking.ProguardTypeMatcher;
import shadow.bundletool.com.android.tools.r8.shaking.ProguardWhyAreYouKeepingRule;
import shadow.bundletool.com.android.tools.r8.shaking.UnusedArgumentRule;
import shadow.bundletool.com.android.tools.r8.shaking.WhyAreYouNotInliningRule;
import shadow.bundletool.com.android.tools.r8.utils.ArrayUtils;
import shadow.bundletool.com.android.tools.r8.utils.Consumer3;
import shadow.bundletool.com.android.tools.r8.utils.InternalOptions;
import shadow.bundletool.com.android.tools.r8.utils.MethodSignatureEquivalence;
import shadow.bundletool.com.android.tools.r8.utils.StringDiagnostic;
import shadow.bundletool.com.android.tools.r8.utils.ThreadUtils;

public class RootSetBuilder {
    private final AppView<? extends AppInfoWithSubtyping> appView;
    private final DirectMappedDexApplication application;
    private final Iterable<? extends ProguardConfigurationRule> rules;
    private final Map<DexReference, Set<ProguardKeepRuleBase>> noShrinking = new IdentityHashMap<DexReference, Set<ProguardKeepRuleBase>>();
    private final Set<DexReference> noOptimization = Sets.newIdentityHashSet();
    private final Set<DexReference> noObfuscation = Sets.newIdentityHashSet();
    private final LinkedHashMap<DexReference, DexReference> reasonAsked = new LinkedHashMap();
    private final LinkedHashMap<DexReference, DexReference> checkDiscarded = new LinkedHashMap();
    private final Set<DexMethod> alwaysInline = Sets.newIdentityHashSet();
    private final Set<DexMethod> forceInline = Sets.newIdentityHashSet();
    private final Set<DexMethod> neverInline = Sets.newIdentityHashSet();
    private final Set<DexMethod> bypassClinitforInlining = Sets.newIdentityHashSet();
    private final Set<DexMethod> whyAreYouNotInlining = Sets.newIdentityHashSet();
    private final Set<DexMethod> keepParametersWithConstantValue = Sets.newIdentityHashSet();
    private final Set<DexMethod> keepUnusedArguments = Sets.newIdentityHashSet();
    private final Set<DexType> alwaysClassInline = Sets.newIdentityHashSet();
    private final Set<DexType> neverClassInline = Sets.newIdentityHashSet();
    private final Set<DexType> neverMerge = Sets.newIdentityHashSet();
    private final Set<DexReference> neverPropagateValue = Sets.newIdentityHashSet();
    private final Map<DexReference, Map<DexReference, Set<ProguardKeepRuleBase>>> dependentNoShrinking = new IdentityHashMap<DexReference, Map<DexReference, Set<ProguardKeepRuleBase>>>();
    private final Map<DexType, Set<ProguardKeepRuleBase>> dependentKeepClassCompatRule = new IdentityHashMap<DexType, Set<ProguardKeepRuleBase>>();
    private final Map<DexReference, ProguardMemberRule> mayHaveSideEffects = new IdentityHashMap<DexReference, ProguardMemberRule>();
    private final Map<DexReference, ProguardMemberRule> noSideEffects = new IdentityHashMap<DexReference, ProguardMemberRule>();
    private final Map<DexReference, ProguardMemberRule> assumedValues = new IdentityHashMap<DexReference, ProguardMemberRule>();
    private final Set<DexReference> identifierNameStrings = Sets.newIdentityHashSet();
    private final Queue<DelayedRootSetActionItem> delayedRootSetActionItems = new ConcurrentLinkedQueue<DelayedRootSetActionItem>();
    private final InternalOptions options;
    private final DexStringCache dexStringCache = new DexStringCache();
    private final Set<ProguardIfRule> ifRules = Sets.newIdentityHashSet();

    public RootSetBuilder(AppView<? extends AppInfoWithSubtyping> appView, DexApplication application, Iterable<? extends ProguardConfigurationRule> rules) {
        this.appView = appView;
        this.application = application.asDirect();
        this.rules = rules;
        this.options = appView.options();
    }

    public RootSetBuilder(AppView<? extends AppInfoWithSubtyping> appView, Collection<ProguardIfRule> ifRules) {
        this(appView, appView.appInfo().app(), ifRules);
    }

    public RootSetBuilder(AppView<? extends AppInfoWithSubtyping> appView) {
        this(appView, appView.appInfo().app(), null);
    }

    private void process(DexClass clazz, ProguardConfigurationRule rule, ProguardIfRule ifRule) {
        if (!RootSetBuilder.satisfyClassType(rule, clazz)) {
            return;
        }
        if (!RootSetBuilder.satisfyAccessFlag(rule, clazz)) {
            return;
        }
        if (!RootSetBuilder.satisfyAnnotation(rule, clazz)) {
            return;
        }
        if (rule.hasInheritanceClassName() && !this.satisfyInheritanceRule(clazz, rule)) {
            return;
        }
        if (rule.getClassNames().matches(clazz.type)) {
            List<ProguardMemberRule> memberKeepRules = rule.getMemberRules();
            if (rule instanceof ProguardKeepRule) {
                if (clazz.isNotProgramClass()) {
                    return;
                }
                switch (((ProguardKeepRule)rule).getType()) {
                    case KEEP_CLASS_MEMBERS: {
                        ImmutableMap<Predicate<DexDefinition>, DexDefinition> preconditionSupplier = ImmutableMap.of(definition -> true, clazz);
                        this.markMatchingVisibleMethods(clazz, memberKeepRules, rule, preconditionSupplier, false, ifRule);
                        this.markMatchingVisibleFields(clazz, memberKeepRules, rule, preconditionSupplier, false, ifRule);
                        break;
                    }
                    case KEEP_CLASSES_WITH_MEMBERS: {
                        if (!this.allRulesSatisfied(memberKeepRules, clazz)) break;
                    }
                    case KEEP: {
                        this.markClass(clazz, rule, ifRule);
                        HashMap<Predicate<DexDefinition>, DexDefinition> preconditionSupplier = new HashMap<Predicate<DexDefinition>, DexDefinition>();
                        if (ifRule != null) {
                            preconditionSupplier.put(DexDefinition::isStaticMember, null);
                            preconditionSupplier.put(definition -> !definition.isStaticMember(), clazz);
                        } else {
                            preconditionSupplier.put(definition -> true, null);
                        }
                        this.markMatchingVisibleMethods(clazz, memberKeepRules, rule, preconditionSupplier, false, ifRule);
                        this.markMatchingVisibleFields(clazz, memberKeepRules, rule, preconditionSupplier, false, ifRule);
                        break;
                    }
                    case CONDITIONAL: {
                        throw new Unreachable("-if rule will be evaluated separately, not here.");
                    }
                }
                return;
            }
            assert (ifRule == null);
            if (rule instanceof ProguardIfRule) {
                throw new Unreachable("-if rule will be evaluated separately, not here.");
            }
            if (rule instanceof ProguardCheckDiscardRule) {
                if (memberKeepRules.isEmpty()) {
                    this.markClass(clazz, rule, ifRule);
                } else {
                    ImmutableMap<Predicate<DexDefinition>, DexDefinition> preconditionSupplier = ImmutableMap.of(definition -> true, clazz);
                    this.markMatchingVisibleMethods(clazz, memberKeepRules, rule, preconditionSupplier, true, ifRule);
                    this.markMatchingVisibleFields(clazz, memberKeepRules, rule, preconditionSupplier, true, ifRule);
                }
            } else if (rule instanceof ProguardWhyAreYouKeepingRule) {
                this.markClass(clazz, rule, ifRule);
                this.markMatchingVisibleMethods(clazz, memberKeepRules, rule, null, true, ifRule);
                this.markMatchingVisibleFields(clazz, memberKeepRules, rule, null, true, ifRule);
            } else if (rule instanceof ProguardAssumeMayHaveSideEffectsRule || rule instanceof ProguardAssumeNoSideEffectRule || rule instanceof ProguardAssumeValuesRule) {
                this.markMatchingVisibleMethods(clazz, memberKeepRules, rule, null, true, ifRule);
                this.markMatchingOverriddenMethods(this.appView.appInfo(), clazz, memberKeepRules, rule, null, true, ifRule);
                this.markMatchingVisibleFields(clazz, memberKeepRules, rule, null, true, ifRule);
            } else if (rule instanceof ClassMergingRule) {
                if (this.allRulesSatisfied(memberKeepRules, clazz)) {
                    this.markClass(clazz, rule, ifRule);
                }
            } else if (rule instanceof InlineRule || rule instanceof ConstantArgumentRule || rule instanceof UnusedArgumentRule || rule instanceof WhyAreYouNotInliningRule) {
                this.markMatchingMethods(clazz, memberKeepRules, rule, null, ifRule);
            } else if (rule instanceof ClassInlineRule) {
                if (this.allRulesSatisfied(memberKeepRules, clazz)) {
                    this.markClass(clazz, rule, ifRule);
                }
            } else if (rule instanceof MemberValuePropagationRule) {
                this.markMatchingVisibleMethods(clazz, memberKeepRules, rule, null, true, ifRule);
                this.markMatchingVisibleFields(clazz, memberKeepRules, rule, null, true, ifRule);
            } else {
                assert (rule instanceof ProguardIdentifierNameStringRule);
                this.markMatchingFields(clazz, memberKeepRules, rule, null, ifRule);
                this.markMatchingMethods(clazz, memberKeepRules, rule, null, ifRule);
            }
        }
    }

    void runPerRule(ExecutorService executorService, List<Future<?>> futures, ProguardConfigurationRule rule, ProguardIfRule ifRule) {
        List<DexType> specifics = rule.getClassNames().asSpecificDexTypes();
        if (specifics != null) {
            for (DexType type : specifics) {
                DexClass clazz = this.application.definitionFor(type);
                if (clazz == null) continue;
                this.process(clazz, rule, ifRule);
            }
            return;
        }
        futures.add(executorService.submit(() -> {
            for (DexProgramClass dexProgramClass : rule.relevantCandidatesForRule(this.appView, this.application.classes())) {
                this.process(dexProgramClass, rule, ifRule);
            }
            if (rule.applyToNonProgramClasses()) {
                for (DexLibraryClass dexLibraryClass : this.application.libraryClasses()) {
                    this.process(dexLibraryClass, rule, ifRule);
                }
            }
        }));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RootSet run(ExecutorService executorService) throws ExecutionException {
        this.application.timing.begin("Build root set...");
        try {
            ArrayList futures = new ArrayList();
            if (this.rules != null) {
                for (ProguardConfigurationRule proguardConfigurationRule : this.rules) {
                    if (proguardConfigurationRule instanceof ProguardIfRule) {
                        ProguardIfRule ifRule = (ProguardIfRule)proguardConfigurationRule;
                        this.ifRules.add(ifRule);
                        continue;
                    }
                    this.runPerRule(executorService, futures, proguardConfigurationRule, null);
                }
                ThreadUtils.awaitFutures(futures);
            }
        }
        finally {
            this.application.timing.end();
        }
        if (!this.noSideEffects.isEmpty() || !this.assumedValues.isEmpty()) {
            BottomUpClassHierarchyTraversal.forAllClasses(this.appView).visit((Iterable)this.appView.appInfo().classes(), this::propagateAssumeRules);
        }
        if (this.appView.options().protoShrinking().enableGeneratedMessageLiteBuilderShrinking) {
            GeneratedMessageLiteBuilderShrinker.addInliningHeuristicsForBuilderInlining(this.appView, this.alwaysInline, this.neverInline, this.bypassClinitforInlining);
        }
        assert (Sets.intersection(this.neverInline, this.alwaysInline).isEmpty() && Sets.intersection(this.neverInline, this.forceInline).isEmpty()) : "A method cannot be marked as both -neverinline and -forceinline/-alwaysinline.";
        return new RootSet(this.noShrinking, this.noOptimization, this.noObfuscation, ImmutableList.copyOf(this.reasonAsked.values()), ImmutableList.copyOf(this.checkDiscarded.values()), this.alwaysInline, this.forceInline, this.neverInline, this.bypassClinitforInlining, this.whyAreYouNotInlining, this.keepParametersWithConstantValue, this.keepUnusedArguments, this.alwaysClassInline, this.neverClassInline, this.neverMerge, this.neverPropagateValue, this.mayHaveSideEffects, this.noSideEffects, this.assumedValues, this.dependentNoShrinking, this.dependentKeepClassCompatRule, this.identifierNameStrings, this.ifRules, Lists.newArrayList(this.delayedRootSetActionItems));
    }

    private void propagateAssumeRules(DexClass clazz) {
        Set<DexType> subTypes = this.appView.appInfo().allImmediateSubtypes(clazz.type);
        if (subTypes.isEmpty()) {
            return;
        }
        for (DexEncodedMethod encodedMethod : clazz.virtualMethods()) {
            if (encodedMethod.hasCode()) {
                assert (!encodedMethod.shouldNotHaveCode());
                continue;
            }
            this.propagateAssumeRules(clazz.type, encodedMethod.method, subTypes, this.noSideEffects);
            this.propagateAssumeRules(clazz.type, encodedMethod.method, subTypes, this.assumedValues);
        }
    }

    private void propagateAssumeRules(DexType type, DexMethod reference, Set<DexType> subTypes, Map<DexReference, ProguardMemberRule> assumeRulePool) {
        ProguardMemberRule ruleToBePropagated = null;
        for (DexType subType : subTypes) {
            DexMethod referenceInSubType = this.appView.dexItemFactory().createMethod(subType, reference.proto, reference.name);
            DexEncodedMethod target = this.appView.appInfo().resolveMethod(subType, referenceInSubType).getSingleTarget();
            if (target == null || target.method.holder == type) continue;
            ProguardMemberRule ruleInSubType = assumeRulePool.get(target.method);
            if (ruleInSubType == null) {
                ruleToBePropagated = null;
                break;
            }
            if (ruleToBePropagated == null) {
                ruleToBePropagated = ruleInSubType;
                continue;
            }
            if (ruleToBePropagated.equals(ruleInSubType)) continue;
            ruleToBePropagated = null;
            break;
        }
        if (ruleToBePropagated != null) {
            assumeRulePool.put(reference, ruleToBePropagated);
        }
    }

    ConsequentRootSet buildConsequentRootSet() {
        return new ConsequentRootSet(this.neverInline, this.neverClassInline, this.noShrinking, this.noOptimization, this.noObfuscation, this.dependentNoShrinking, this.dependentKeepClassCompatRule, Lists.newArrayList(this.delayedRootSetActionItems));
    }

    private static DexDefinition testAndGetPrecondition(DexDefinition definition, Map<Predicate<DexDefinition>, DexDefinition> preconditionSupplier) {
        if (preconditionSupplier == null) {
            return null;
        }
        DexDefinition precondition = null;
        boolean conditionEverMatched = false;
        for (Map.Entry<Predicate<DexDefinition>, DexDefinition> entry : preconditionSupplier.entrySet()) {
            if (!entry.getKey().test(definition)) continue;
            precondition = entry.getValue();
            conditionEverMatched = true;
            break;
        }
        assert (conditionEverMatched);
        return precondition;
    }

    private void markMatchingVisibleMethods(DexClass clazz, Collection<ProguardMemberRule> memberKeepRules, ProguardConfigurationRule rule, Map<Predicate<DexDefinition>, DexDefinition> preconditionSupplier, boolean includeLibraryClasses, ProguardIfRule ifRule) {
        HashSet methodsMarked = this.options.forceProguardCompatibility ? null : new HashSet();
        Stack<DexClass> worklist = new Stack<DexClass>();
        worklist.add(clazz);
        while (!worklist.isEmpty()) {
            DexClass dexClass;
            DexClass currentClass = (DexClass)worklist.pop();
            if (!includeLibraryClasses && currentClass.isNotProgramClass()) break;
            if (currentClass == clazz || this.options.forceProguardCompatibility) {
                currentClass.directMethods().forEach(method -> {
                    DexDefinition precondition = RootSetBuilder.testAndGetPrecondition(method, preconditionSupplier);
                    this.markMethod((DexEncodedMethod)method, memberKeepRules, methodsMarked, rule, precondition, ifRule);
                });
            }
            currentClass.virtualMethods().forEach(method -> {
                DexDefinition precondition = RootSetBuilder.testAndGetPrecondition(method, preconditionSupplier);
                this.markMethod((DexEncodedMethod)method, memberKeepRules, methodsMarked, rule, precondition, ifRule);
            });
            if (currentClass.superType == null || (dexClass = this.application.definitionFor(currentClass.superType)) == null) continue;
            worklist.add(dexClass);
        }
        if (clazz.isProgramClass() && rule.isProguardKeepRule() && !rule.asProguardKeepRule().getModifiers().allowsShrinking) {
            new SynthesizeMissingInterfaceMethodsForMemberRules(clazz.asProgramClass(), memberKeepRules, rule, preconditionSupplier, ifRule).run();
        }
    }

    private boolean canInsertForwardingMethod(DexClass holder, DexEncodedMethod target) {
        return this.appView.options().isGeneratingDex() || ArrayUtils.contains(holder.interfaces.values, target.method.holder);
    }

    private void markMatchingOverriddenMethods(AppInfoWithSubtyping appInfoWithSubtyping, DexClass clazz, Collection<ProguardMemberRule> memberKeepRules, ProguardConfigurationRule rule, Map<Predicate<DexDefinition>, DexDefinition> preconditionSupplier, boolean onlyIncludeProgramClasses, ProguardIfRule ifRule) {
        HashSet<DexType> visited = new HashSet<DexType>();
        ArrayDeque<DexType> worklist = new ArrayDeque<DexType>();
        worklist.addAll(appInfoWithSubtyping.allImmediateSubtypes(clazz.type));
        while (!worklist.isEmpty()) {
            DexClass currentClazz;
            DexType currentType = (DexType)worklist.poll();
            if (!visited.add(currentType) || (currentClazz = this.appView.definitionFor(currentType)) == null || !onlyIncludeProgramClasses && currentClazz.isNotProgramClass()) continue;
            currentClazz.virtualMethods().forEach(method -> {
                DexDefinition precondition = RootSetBuilder.testAndGetPrecondition(method, preconditionSupplier);
                this.markMethod((DexEncodedMethod)method, memberKeepRules, null, rule, precondition, ifRule);
            });
            worklist.addAll(appInfoWithSubtyping.allImmediateSubtypes(currentClazz.type));
        }
    }

    private void markMatchingMethods(DexClass clazz, Collection<ProguardMemberRule> memberKeepRules, ProguardConfigurationRule rule, Map<Predicate<DexDefinition>, DexDefinition> preconditionSupplier, ProguardIfRule ifRule) {
        clazz.forEachMethod(method -> {
            DexDefinition precondition = RootSetBuilder.testAndGetPrecondition(method, preconditionSupplier);
            this.markMethod((DexEncodedMethod)method, memberKeepRules, null, rule, precondition, ifRule);
        });
    }

    private void markMatchingVisibleFields(DexClass clazz, Collection<ProguardMemberRule> memberKeepRules, ProguardConfigurationRule rule, Map<Predicate<DexDefinition>, DexDefinition> preconditionSupplier, boolean includeLibraryClasses, ProguardIfRule ifRule) {
        while (clazz != null) {
            if (!includeLibraryClasses && clazz.isNotProgramClass()) {
                return;
            }
            clazz.forEachField(field -> {
                DexDefinition precondition = RootSetBuilder.testAndGetPrecondition(field, preconditionSupplier);
                this.markField((DexEncodedField)field, memberKeepRules, rule, precondition, ifRule);
            });
            clazz = clazz.superType == null ? null : this.application.definitionFor(clazz.superType);
        }
    }

    private void markMatchingFields(DexClass clazz, Collection<ProguardMemberRule> memberKeepRules, ProguardConfigurationRule rule, Map<Predicate<DexDefinition>, DexDefinition> preconditionSupplier, ProguardIfRule ifRule) {
        clazz.forEachField(field -> {
            DexDefinition precondition = RootSetBuilder.testAndGetPrecondition(field, preconditionSupplier);
            this.markField((DexEncodedField)field, memberKeepRules, rule, precondition, ifRule);
        });
    }

    public static void writeSeeds(AppInfoWithLiveness appInfo, PrintStream out, Predicate<DexType> include) {
        for (DexReference seed : appInfo.getPinnedItems()) {
            if (seed.isDexType()) {
                if (!include.test(seed.asDexType())) continue;
                out.println(seed.toSourceString());
                continue;
            }
            if (seed.isDexField()) {
                DexField field = seed.asDexField();
                if (!include.test(field.holder)) continue;
                out.println(field.holder.toSourceString() + ": " + field.type.toSourceString() + " " + field.name.toSourceString());
                continue;
            }
            assert (seed.isDexMethod());
            DexMethod method = seed.asDexMethod();
            if (!include.test(method.holder)) continue;
            out.print(method.holder.toSourceString() + ": ");
            DexEncodedMethod encodedMethod = appInfo.definitionFor(method);
            if (encodedMethod.accessFlags.isConstructor()) {
                if (encodedMethod.accessFlags.isStatic()) {
                    out.print("<clinit>");
                } else {
                    String holderName = method.holder.toSourceString();
                    String constrName = holderName.substring(holderName.lastIndexOf(46) + 1);
                    out.print(constrName);
                }
            } else {
                out.print(method.proto.returnType.toSourceString() + " " + method.name.toSourceString());
            }
            boolean first = true;
            out.print("(");
            for (DexType param : method.proto.parameters.values) {
                if (!first) {
                    out.print(",");
                }
                first = false;
                out.print(param.toSourceString());
            }
            out.println(")");
        }
        out.close();
    }

    static boolean satisfyClassType(ProguardConfigurationRule rule, DexClass clazz) {
        return rule.getClassType().matches(clazz) != rule.getClassTypeNegated();
    }

    static boolean satisfyAccessFlag(ProguardConfigurationRule rule, DexClass clazz) {
        return rule.getClassAccessFlags().containsAll(clazz.accessFlags) && rule.getNegatedClassAccessFlags().containsNone(clazz.accessFlags);
    }

    static boolean satisfyAnnotation(ProguardConfigurationRule rule, DexClass clazz) {
        return RootSetBuilder.containsAnnotation(rule.getClassAnnotation(), clazz);
    }

    boolean satisfyInheritanceRule(DexClass clazz, ProguardConfigurationRule rule) {
        if (this.satisfyExtendsRule(clazz, rule)) {
            return true;
        }
        return this.satisfyImplementsRule(clazz, rule);
    }

    boolean satisfyExtendsRule(DexClass clazz, ProguardConfigurationRule rule) {
        if (this.anySuperTypeMatchesExtendsRule(clazz.superType, rule)) {
            return true;
        }
        return this.anySourceMatchesInheritanceRuleDirectly(clazz, rule, false);
    }

    boolean anySuperTypeMatchesExtendsRule(DexType type, ProguardConfigurationRule rule) {
        while (type != null) {
            DexClass clazz = this.application.definitionFor(type);
            if (clazz == null) {
                return false;
            }
            if (rule.getInheritanceClassName().matches(clazz.type, this.appView) && RootSetBuilder.containsAnnotation(rule.getInheritanceAnnotation(), clazz)) {
                return true;
            }
            type = clazz.superType;
        }
        return false;
    }

    boolean satisfyImplementsRule(DexClass clazz, ProguardConfigurationRule rule) {
        if (this.anyImplementedInterfaceMatchesImplementsRule(clazz, rule)) {
            return true;
        }
        return this.anySourceMatchesInheritanceRuleDirectly(clazz, rule, true);
    }

    private boolean anyImplementedInterfaceMatchesImplementsRule(DexClass clazz, ProguardConfigurationRule rule) {
        if (clazz == null) {
            return false;
        }
        for (DexType iface : clazz.interfaces.values) {
            DexClass ifaceClass = this.application.definitionFor(iface);
            if (ifaceClass == null) {
                return false;
            }
            if (rule.getInheritanceClassName().matches(iface, this.appView) && RootSetBuilder.containsAnnotation(rule.getInheritanceAnnotation(), ifaceClass)) {
                return true;
            }
            if (!this.anyImplementedInterfaceMatchesImplementsRule(ifaceClass, rule)) continue;
            return true;
        }
        if (clazz.superType == null) {
            return false;
        }
        DexClass superClass = this.application.definitionFor(clazz.superType);
        if (superClass == null) {
            return false;
        }
        return this.anyImplementedInterfaceMatchesImplementsRule(superClass, rule);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean anySourceMatchesInheritanceRuleDirectly(DexClass clazz, ProguardConfigurationRule rule, boolean isInterface) {
        if (this.appView.verticallyMergedClasses() == null) return false;
        if (!this.appView.verticallyMergedClasses().getSourcesFor(clazz.type).stream().filter(sourceType -> this.appView.definitionFor((DexType)sourceType).accessFlags.isInterface() == isInterface).anyMatch(rule.getInheritanceClassName()::matches)) return false;
        return true;
    }

    private boolean allRulesSatisfied(Collection<ProguardMemberRule> memberKeepRules, DexClass clazz) {
        for (ProguardMemberRule rule : memberKeepRules) {
            if (this.ruleSatisfied(rule, clazz)) continue;
            return false;
        }
        return true;
    }

    private boolean ruleSatisfied(ProguardMemberRule rule, DexClass clazz) {
        return this.ruleSatisfiedByMethods(rule, clazz.directMethods()) || this.ruleSatisfiedByMethods(rule, clazz.virtualMethods()) || this.ruleSatisfiedByFields(rule, clazz.staticFields()) || this.ruleSatisfiedByFields(rule, clazz.instanceFields());
    }

    boolean ruleSatisfiedByMethods(ProguardMemberRule rule, Iterable<DexEncodedMethod> methods) {
        if (rule.getRuleType().includesMethods()) {
            for (DexEncodedMethod method : methods) {
                if (!rule.matches(method, this.appView, this.dexStringCache)) continue;
                return true;
            }
        }
        return false;
    }

    boolean ruleSatisfiedByFields(ProguardMemberRule rule, Iterable<DexEncodedField> fields) {
        if (rule.getRuleType().includesFields()) {
            for (DexEncodedField field : fields) {
                if (!rule.matches(field, this.appView, this.dexStringCache)) continue;
                return true;
            }
        }
        return false;
    }

    static boolean containsAnnotation(ProguardTypeMatcher classAnnotation, DexClass clazz) {
        return RootSetBuilder.containsAnnotation(classAnnotation, clazz.annotations);
    }

    static boolean containsAnnotation(ProguardTypeMatcher classAnnotation, DexEncodedMethod method) {
        if (RootSetBuilder.containsAnnotation(classAnnotation, method.annotations)) {
            return true;
        }
        for (int i = 0; i < method.parameterAnnotationsList.size(); ++i) {
            if (!RootSetBuilder.containsAnnotation(classAnnotation, method.parameterAnnotationsList.get(i))) continue;
            return true;
        }
        return false;
    }

    static boolean containsAnnotation(ProguardTypeMatcher classAnnotation, DexEncodedField field) {
        return RootSetBuilder.containsAnnotation(classAnnotation, field.annotations);
    }

    private static boolean containsAnnotation(ProguardTypeMatcher classAnnotation, DexAnnotationSet annotations) {
        if (classAnnotation == null) {
            return true;
        }
        if (annotations.isEmpty()) {
            return false;
        }
        for (DexAnnotation annotation : annotations.annotations) {
            if (!classAnnotation.matches(annotation.annotation.type)) continue;
            return true;
        }
        return false;
    }

    private void markMethod(DexEncodedMethod method, Collection<ProguardMemberRule> rules, Set<Equivalence.Wrapper<DexMethod>> methodsMarked, ProguardConfigurationRule context, DexDefinition precondition, ProguardIfRule ifRule) {
        if (methodsMarked != null && methodsMarked.contains(MethodSignatureEquivalence.get().wrap(method.method))) {
            return;
        }
        for (ProguardMemberRule rule : rules) {
            if (!rule.matches(method, this.appView, this.dexStringCache)) continue;
            if (Log.ENABLED) {
                Log.verbose(this.getClass(), "Marking method `%s` due to `%s { %s }`.", method, context, rule);
            }
            if (methodsMarked != null) {
                methodsMarked.add(MethodSignatureEquivalence.get().wrap(method.method));
            }
            this.addItemToSets(method, context, rule, precondition, ifRule);
        }
    }

    private void markField(DexEncodedField field, Collection<ProguardMemberRule> rules, ProguardConfigurationRule context, DexDefinition precondition, ProguardIfRule ifRule) {
        for (ProguardMemberRule rule : rules) {
            if (!rule.matches(field, this.appView, this.dexStringCache)) continue;
            if (Log.ENABLED) {
                Log.verbose(this.getClass(), "Marking field `%s` due to `%s { %s }`.", field, context, rule);
            }
            this.addItemToSets(field, context, rule, precondition, ifRule);
        }
    }

    private void markClass(DexClass clazz, ProguardConfigurationRule rule, ProguardIfRule ifRule) {
        if (Log.ENABLED) {
            Log.verbose(this.getClass(), "Marking class `%s` due to `%s`.", clazz.type, rule);
        }
        this.addItemToSets(clazz, rule, null, null, ifRule);
    }

    private void includeDescriptor(DexDefinition item, DexType type, ProguardKeepRuleBase context) {
        if (type.isVoidType()) {
            return;
        }
        if (type.isArrayType()) {
            type = type.toBaseType(this.appView.dexItemFactory());
        }
        if (type.isPrimitiveType()) {
            return;
        }
        DexClass definition = this.appView.definitionFor(type);
        if (definition == null || definition.isNotProgramClass()) {
            return;
        }
        this.dependentNoShrinking.computeIfAbsent(item.toReference(), x -> new IdentityHashMap()).computeIfAbsent(type, k -> new HashSet()).add(context);
        this.noObfuscation.add(type);
    }

    private void includeDescriptorClasses(DexDefinition item, ProguardKeepRuleBase context) {
        if (item.isDexEncodedMethod()) {
            DexMethod method = item.asDexEncodedMethod().method;
            this.includeDescriptor(item, method.proto.returnType, context);
            for (DexType value : method.proto.parameters.values) {
                this.includeDescriptor(item, value, context);
            }
        } else if (item.isDexEncodedField()) {
            DexField field = item.asDexEncodedField().field;
            this.includeDescriptor(item, field.type, context);
        } else assert (item.isDexClass());
    }

    private synchronized void addItemToSets(DexDefinition item, ProguardConfigurationRule context, ProguardMemberRule rule, DexDefinition precondition, ProguardIfRule ifRule) {
        block52: {
            block62: {
                block61: {
                    block60: {
                        block59: {
                            block58: {
                                block57: {
                                    block56: {
                                        block55: {
                                            block54: {
                                                block53: {
                                                    block51: {
                                                        if (!(context instanceof ProguardKeepRule)) break block51;
                                                        if (item.isDexEncodedField()) {
                                                            DexEncodedField encodedField = item.asDexEncodedField();
                                                            if (encodedField.getOptimizationInfo().cannotBeKept()) {
                                                                assert (ifRule != null);
                                                                return;
                                                            }
                                                        } else if (item.isDexEncodedMethod()) {
                                                            DexClass holder;
                                                            DexEncodedMethod encodedMethod = item.asDexEncodedMethod();
                                                            if (encodedMethod.isClassInitializer() && !this.options.debug) {
                                                                return;
                                                            }
                                                            if (encodedMethod.getOptimizationInfo().cannotBeKept()) {
                                                                assert (ifRule != null);
                                                                return;
                                                            }
                                                            if (this.options.isGeneratingDex() && encodedMethod.method.isLambdaDeserializeMethod(this.appView.dexItemFactory())) {
                                                                return;
                                                            }
                                                            if (this.options.isInterfaceMethodDesugaringEnabled() && encodedMethod.hasCode() && (encodedMethod.isPrivateMethod() || encodedMethod.isStaticMember()) && (holder = this.appView.definitionFor(encodedMethod.method.holder)) != null && holder.isInterface()) {
                                                                if (rule.isSpecific()) {
                                                                    this.options.reporter.warning(new StringDiagnostic("The rule `" + rule + "` is ignored because the targeting interface method `" + encodedMethod.method.toSourceString() + "` will be desugared."));
                                                                }
                                                                return;
                                                            }
                                                        }
                                                        ProguardKeepRuleBase keepRule = ifRule != null ? ifRule : (ProguardKeepRuleBase)context;
                                                        ProguardKeepRuleModifiers modifiers = ((ProguardKeepRule)context).getModifiers();
                                                        if (this.options.forceProguardCompatibility && !modifiers.allowsShrinking && precondition != null && precondition.isDexClass() && !item.isDexClass() && !item.isStaticMember()) {
                                                            this.dependentKeepClassCompatRule.computeIfAbsent(precondition.asDexClass().getType(), i -> new HashSet()).add(keepRule);
                                                            context.markAsUsed();
                                                        }
                                                        if (!modifiers.allowsShrinking) {
                                                            if (precondition != null) {
                                                                this.dependentNoShrinking.computeIfAbsent(precondition.toReference(), x -> new IdentityHashMap()).computeIfAbsent(item.toReference(), i -> new HashSet()).add(keepRule);
                                                            } else {
                                                                this.noShrinking.computeIfAbsent(item.toReference(), i -> new HashSet()).add(keepRule);
                                                            }
                                                            context.markAsUsed();
                                                        }
                                                        if (!modifiers.allowsOptimization) {
                                                            this.noOptimization.add(item.toReference());
                                                            context.markAsUsed();
                                                        }
                                                        if (!modifiers.allowsObfuscation) {
                                                            this.noObfuscation.add(item.toReference());
                                                            context.markAsUsed();
                                                        }
                                                        if (modifiers.includeDescriptorClasses) {
                                                            this.includeDescriptorClasses(item, keepRule);
                                                            context.markAsUsed();
                                                        }
                                                        break block52;
                                                    }
                                                    if (!(context instanceof ProguardAssumeMayHaveSideEffectsRule)) break block53;
                                                    this.mayHaveSideEffects.put(item.toReference(), rule);
                                                    context.markAsUsed();
                                                    break block52;
                                                }
                                                if (!(context instanceof ProguardAssumeNoSideEffectRule)) break block54;
                                                this.noSideEffects.put(item.toReference(), rule);
                                                context.markAsUsed();
                                                break block52;
                                            }
                                            if (!(context instanceof ProguardWhyAreYouKeepingRule)) break block55;
                                            this.reasonAsked.computeIfAbsent(item.toReference(), i -> i);
                                            context.markAsUsed();
                                            break block52;
                                        }
                                        if (!(context instanceof ProguardAssumeValuesRule)) break block56;
                                        this.assumedValues.put(item.toReference(), rule);
                                        context.markAsUsed();
                                        break block52;
                                    }
                                    if (!(context instanceof ProguardCheckDiscardRule)) break block57;
                                    this.checkDiscarded.computeIfAbsent(item.toReference(), i -> i);
                                    context.markAsUsed();
                                    break block52;
                                }
                                if (!(context instanceof InlineRule)) break block58;
                                if (item.isDexEncodedMethod()) {
                                    switch (((InlineRule)context).getType()) {
                                        case ALWAYS: {
                                            this.alwaysInline.add(item.asDexEncodedMethod().method);
                                            break;
                                        }
                                        case FORCE: {
                                            this.forceInline.add(item.asDexEncodedMethod().method);
                                            break;
                                        }
                                        case NEVER: {
                                            this.neverInline.add(item.asDexEncodedMethod().method);
                                            break;
                                        }
                                        default: {
                                            throw new Unreachable();
                                        }
                                    }
                                    context.markAsUsed();
                                }
                                break block52;
                            }
                            if (!(context instanceof WhyAreYouNotInliningRule)) break block59;
                            if (!item.isDexEncodedMethod()) {
                                throw new Unreachable();
                            }
                            this.whyAreYouNotInlining.add(item.asDexEncodedMethod().method);
                            context.markAsUsed();
                            break block52;
                        }
                        if (!context.isClassInlineRule()) break block60;
                        ClassInlineRule classInlineRule = context.asClassInlineRule();
                        DexClass clazz = item.asDexClass();
                        if (clazz == null) {
                            throw new IllegalStateException("Unexpected -" + classInlineRule.typeString() + " rule for a non-class type: `" + item.toReference().toSourceString() + "`");
                        }
                        switch (classInlineRule.getType()) {
                            case ALWAYS: {
                                this.alwaysClassInline.add(item.asDexClass().type);
                                break;
                            }
                            case NEVER: {
                                this.neverClassInline.add(item.asDexClass().type);
                                break;
                            }
                            default: {
                                throw new Unreachable();
                            }
                        }
                        context.markAsUsed();
                        break block52;
                    }
                    if (!(context instanceof ClassMergingRule)) break block61;
                    switch (((ClassMergingRule)context).getType()) {
                        case NEVER: {
                            if (!item.isDexClass()) break;
                            this.neverMerge.add(item.asDexClass().type);
                            break;
                        }
                        default: {
                            throw new Unreachable();
                        }
                    }
                    context.markAsUsed();
                    break block52;
                }
                if (!(context instanceof MemberValuePropagationRule)) break block62;
                switch (((MemberValuePropagationRule)context).getType()) {
                    case NEVER: {
                        DexEncodedMethod method;
                        if (item.isDexEncodedField()) {
                            DexEncodedField field = item.asDexEncodedField();
                            if (field.isProgramField(this.appView)) {
                                this.neverPropagateValue.add(item.asDexEncodedField().field);
                                context.markAsUsed();
                            }
                        } else if (item.isDexEncodedMethod() && (method = item.asDexEncodedMethod()).isProgramMethod(this.appView)) {
                            this.neverPropagateValue.add(item.asDexEncodedMethod().method);
                            context.markAsUsed();
                        }
                        break block52;
                    }
                    default: {
                        throw new Unreachable();
                    }
                }
            }
            if (context instanceof ProguardIdentifierNameStringRule) {
                if (item.isDexEncodedField()) {
                    this.identifierNameStrings.add(item.asDexEncodedField().field);
                    context.markAsUsed();
                } else if (item.isDexEncodedMethod()) {
                    this.identifierNameStrings.add(item.asDexEncodedMethod().method);
                    context.markAsUsed();
                }
            } else if (context instanceof ConstantArgumentRule) {
                if (item.isDexEncodedMethod()) {
                    this.keepParametersWithConstantValue.add(item.asDexEncodedMethod().method);
                    context.markAsUsed();
                }
            } else if (context instanceof UnusedArgumentRule) {
                if (item.isDexEncodedMethod()) {
                    this.keepUnusedArguments.add(item.asDexEncodedMethod().method);
                    context.markAsUsed();
                }
            } else {
                throw new Unreachable();
            }
        }
    }

    public static class ConsequentRootSet {
        final Set<DexMethod> neverInline;
        final Set<DexType> neverClassInline;
        final Map<DexReference, Set<ProguardKeepRuleBase>> noShrinking;
        final Set<DexReference> noOptimization;
        final Set<DexReference> noObfuscation;
        final Map<DexReference, Map<DexReference, Set<ProguardKeepRuleBase>>> dependentNoShrinking;
        final Map<DexType, Set<ProguardKeepRuleBase>> dependentKeepClassCompatRule;
        final List<DelayedRootSetActionItem> delayedRootSetActionItems;

        private ConsequentRootSet(Set<DexMethod> neverInline, Set<DexType> neverClassInline, Map<DexReference, Set<ProguardKeepRuleBase>> noShrinking, Set<DexReference> noOptimization, Set<DexReference> noObfuscation, Map<DexReference, Map<DexReference, Set<ProguardKeepRuleBase>>> dependentNoShrinking, Map<DexType, Set<ProguardKeepRuleBase>> dependentKeepClassCompatRule, List<DelayedRootSetActionItem> delayedRootSetActionItems) {
            this.neverInline = Collections.unmodifiableSet(neverInline);
            this.neverClassInline = Collections.unmodifiableSet(neverClassInline);
            this.noShrinking = Collections.unmodifiableMap(noShrinking);
            this.noOptimization = Collections.unmodifiableSet(noOptimization);
            this.noObfuscation = Collections.unmodifiableSet(noObfuscation);
            this.dependentNoShrinking = Collections.unmodifiableMap(dependentNoShrinking);
            this.dependentKeepClassCompatRule = Collections.unmodifiableMap(dependentKeepClassCompatRule);
            this.delayedRootSetActionItems = Collections.unmodifiableList(delayedRootSetActionItems);
        }
    }

    public static class RootSet {
        public final Map<DexReference, Set<ProguardKeepRuleBase>> noShrinking;
        public final Set<DexReference> noOptimization;
        private final Set<DexReference> noObfuscation;
        public final ImmutableList<DexReference> reasonAsked;
        public final ImmutableList<DexReference> checkDiscarded;
        public final Set<DexMethod> alwaysInline;
        public final Set<DexMethod> forceInline;
        public final Set<DexMethod> neverInline;
        public final Set<DexMethod> bypassClinitForInlining;
        public final Set<DexMethod> whyAreYouNotInlining;
        public final Set<DexMethod> keepConstantArguments;
        public final Set<DexMethod> keepUnusedArguments;
        public final Set<DexType> alwaysClassInline;
        public final Set<DexType> neverClassInline;
        public final Set<DexType> neverMerge;
        public final Set<DexReference> neverPropagateValue;
        public final Map<DexReference, ProguardMemberRule> mayHaveSideEffects;
        public final Map<DexReference, ProguardMemberRule> noSideEffects;
        public final Map<DexReference, ProguardMemberRule> assumedValues;
        private final Map<DexReference, Map<DexReference, Set<ProguardKeepRuleBase>>> dependentNoShrinking;
        private final Map<DexType, Set<ProguardKeepRuleBase>> dependentKeepClassCompatRule;
        public final Set<DexReference> identifierNameStrings;
        public final Set<ProguardIfRule> ifRules;
        public final List<DelayedRootSetActionItem> delayedRootSetActionItems;

        private RootSet(Map<DexReference, Set<ProguardKeepRuleBase>> noShrinking, Set<DexReference> noOptimization, Set<DexReference> noObfuscation, ImmutableList<DexReference> reasonAsked, ImmutableList<DexReference> checkDiscarded, Set<DexMethod> alwaysInline, Set<DexMethod> forceInline, Set<DexMethod> neverInline, Set<DexMethod> bypassClinitForInlining, Set<DexMethod> whyAreYouNotInlining, Set<DexMethod> keepConstantArguments, Set<DexMethod> keepUnusedArguments, Set<DexType> alwaysClassInline, Set<DexType> neverClassInline, Set<DexType> neverMerge, Set<DexReference> neverPropagateValue, Map<DexReference, ProguardMemberRule> mayHaveSideEffects, Map<DexReference, ProguardMemberRule> noSideEffects, Map<DexReference, ProguardMemberRule> assumedValues, Map<DexReference, Map<DexReference, Set<ProguardKeepRuleBase>>> dependentNoShrinking, Map<DexType, Set<ProguardKeepRuleBase>> dependentKeepClassCompatRule, Set<DexReference> identifierNameStrings, Set<ProguardIfRule> ifRules, List<DelayedRootSetActionItem> delayedRootSetActionItems) {
            this.noShrinking = noShrinking;
            this.noOptimization = noOptimization;
            this.noObfuscation = noObfuscation;
            this.reasonAsked = reasonAsked;
            this.checkDiscarded = checkDiscarded;
            this.alwaysInline = Collections.unmodifiableSet(alwaysInline);
            this.forceInline = Collections.unmodifiableSet(forceInline);
            this.neverInline = neverInline;
            this.bypassClinitForInlining = bypassClinitForInlining;
            this.whyAreYouNotInlining = whyAreYouNotInlining;
            this.keepConstantArguments = keepConstantArguments;
            this.keepUnusedArguments = keepUnusedArguments;
            this.alwaysClassInline = alwaysClassInline;
            this.neverClassInline = neverClassInline;
            this.neverMerge = Collections.unmodifiableSet(neverMerge);
            this.neverPropagateValue = neverPropagateValue;
            this.mayHaveSideEffects = mayHaveSideEffects;
            this.noSideEffects = noSideEffects;
            this.assumedValues = assumedValues;
            this.dependentNoShrinking = dependentNoShrinking;
            this.dependentKeepClassCompatRule = dependentKeepClassCompatRule;
            this.identifierNameStrings = Collections.unmodifiableSet(identifierNameStrings);
            this.ifRules = Collections.unmodifiableSet(ifRules);
            this.delayedRootSetActionItems = delayedRootSetActionItems;
        }

        public void checkAllRulesAreUsed(InternalOptions options) {
            List<ProguardConfigurationRule> rules = options.getProguardConfiguration().getRules();
            if (rules != null) {
                for (ProguardConfigurationRule rule : rules) {
                    if (rule.isUsed()) continue;
                    String message = "Proguard configuration rule does not match anything: `" + rule.toString() + "`";
                    StringDiagnostic diagnostic = new StringDiagnostic(message, rule.getOrigin());
                    if (!options.testing.allowUnusedProguardConfigurationRules) {
                        throw options.reporter.fatalError(diagnostic);
                    }
                    if (!options.testing.reportUnusedProguardConfigurationRules) continue;
                    options.reporter.info(diagnostic);
                }
            }
        }

        void addConsequentRootSet(ConsequentRootSet consequentRootSet, boolean addNoShrinking) {
            this.neverInline.addAll(consequentRootSet.neverInline);
            this.neverClassInline.addAll(consequentRootSet.neverClassInline);
            this.noOptimization.addAll(consequentRootSet.noOptimization);
            this.noObfuscation.addAll(consequentRootSet.noObfuscation);
            if (addNoShrinking) {
                consequentRootSet.noShrinking.forEach((type, rules) -> this.noShrinking.computeIfAbsent((DexReference)type, k -> new HashSet()).addAll(rules));
            }
            this.addDependentItems(consequentRootSet.dependentNoShrinking);
            consequentRootSet.dependentKeepClassCompatRule.forEach((type, rules) -> this.dependentKeepClassCompatRule.computeIfAbsent((DexType)type, k -> new HashSet()).addAll(rules));
            this.delayedRootSetActionItems.addAll(consequentRootSet.delayedRootSetActionItems);
        }

        private void addDependentItems(Map<DexReference, Map<DexReference, Set<ProguardKeepRuleBase>>> dependentItems) {
            dependentItems.forEach((reference, dependence) -> this.dependentNoShrinking.computeIfAbsent((DexReference)reference, x -> new IdentityHashMap()).putAll(dependence));
        }

        Set<ProguardKeepRuleBase> getDependentKeepClassCompatRule(DexType type) {
            return this.dependentKeepClassCompatRule.get(type);
        }

        Map<DexReference, Set<ProguardKeepRuleBase>> getDependentItems(DexDefinition item) {
            return Collections.unmodifiableMap(this.dependentNoShrinking.getOrDefault(item.toReference(), Collections.emptyMap()));
        }

        public void forEachDependentStaticMember(DexDefinition item, AppView<?> appView, Consumer3<DexDefinition, DexDefinition, Set<ProguardKeepRuleBase>> fn) {
            this.getDependentItems(item).forEach((reference, reasons) -> {
                DexDefinition definition = appView.definitionFor((DexReference)reference);
                if (definition != null && !definition.isDexClass() && definition.isStaticMember()) {
                    fn.accept(item, definition, (Set<ProguardKeepRuleBase>)reasons);
                }
            });
        }

        public void forEachDependentNonStaticMember(DexDefinition item, AppView<?> appView, Consumer3<DexDefinition, DexDefinition, Set<ProguardKeepRuleBase>> fn) {
            this.getDependentItems(item).forEach((reference, reasons) -> {
                DexDefinition definition = appView.definitionFor((DexReference)reference);
                if (definition != null && !definition.isDexClass() && !definition.isStaticMember()) {
                    fn.accept(item, definition, (Set<ProguardKeepRuleBase>)reasons);
                }
            });
        }

        public void copy(DexReference original, DexReference rewritten) {
            if (this.noShrinking.containsKey(original)) {
                this.noShrinking.put(rewritten, this.noShrinking.get(original));
            }
            if (this.noOptimization.contains(original)) {
                this.noOptimization.add(rewritten);
            }
            if (this.noObfuscation.contains(original)) {
                this.noObfuscation.add(rewritten);
            }
            if (this.noSideEffects.containsKey(original)) {
                this.noSideEffects.put(rewritten, this.noSideEffects.get(original));
            }
            if (this.assumedValues.containsKey(original)) {
                this.assumedValues.put(rewritten, this.assumedValues.get(original));
            }
        }

        public void prune(DexReference reference) {
            this.noShrinking.remove(reference);
            this.noOptimization.remove(reference);
            this.noObfuscation.remove(reference);
            this.noSideEffects.remove(reference);
            this.assumedValues.remove(reference);
        }

        public void move(DexReference original, DexReference rewritten) {
            this.copy(original, rewritten);
            this.prune(original);
        }

        void shouldNotBeMinified(DexReference reference) {
            this.noObfuscation.add(reference);
        }

        public boolean mayBeMinified(DexReference reference, AppView<?> appView) {
            return !this.mayNotBeMinified(reference, appView);
        }

        public boolean mayNotBeMinified(DexReference reference, AppView<?> appView) {
            if (reference.isDexType()) {
                return this.noObfuscation.contains(appView.graphLense().getOriginalType(reference.asDexType()));
            }
            if (reference.isDexMethod()) {
                return this.noObfuscation.contains(appView.graphLense().getOriginalMethodSignature(reference.asDexMethod()));
            }
            assert (reference.isDexField());
            return this.noObfuscation.contains(appView.graphLense().getOriginalFieldSignature(reference.asDexField()));
        }

        public boolean verifyKeptFieldsAreAccessedAndLive(AppInfoWithLiveness appInfo) {
            for (DexReference reference : this.noShrinking.keySet()) {
                DexField field;
                DexEncodedField encodedField;
                if (!reference.isDexField() || (encodedField = appInfo.definitionFor(field = reference.asDexField())) == null || !encodedField.isStatic() && !this.isKeptDirectlyOrIndirectly(field.holder, appInfo)) continue;
                assert (appInfo.isFieldRead(encodedField)) : "Expected kept field `" + field.toSourceString() + "` to be read";
                assert (appInfo.isFieldWritten(encodedField)) : "Expected kept field `" + field.toSourceString() + "` to be written";
            }
            return true;
        }

        public boolean verifyKeptMethodsAreTargetedAndLive(AppInfoWithLiveness appInfo) {
            for (DexReference reference : this.noShrinking.keySet()) {
                if (!reference.isDexMethod()) continue;
                DexMethod method = reference.asDexMethod();
                assert (appInfo.targetedMethods.contains(method)) : "Expected kept method `" + method.toSourceString() + "` to be targeted";
                DexEncodedMethod encodedMethod = appInfo.definitionFor(method);
                if (!encodedMethod.accessFlags.isAbstract() && this.isKeptDirectlyOrIndirectly(method.holder, appInfo)) assert (appInfo.liveMethods.contains(method)) : "Expected non-abstract kept method `" + method.toSourceString() + "` to be live";
            }
            return true;
        }

        public boolean verifyKeptTypesAreLive(AppInfoWithLiveness appInfo) {
            for (DexReference reference : this.noShrinking.keySet()) {
                if (!reference.isDexType()) continue;
                DexType type = reference.asDexType();
                assert (appInfo.isLiveProgramType(type)) : "Expected kept type `" + type.toSourceString() + "` to be live";
            }
            return true;
        }

        private boolean isKeptDirectlyOrIndirectly(DexType type, AppInfoWithLiveness appInfo) {
            if (this.noShrinking.containsKey(type)) {
                return true;
            }
            DexClass clazz = appInfo.definitionFor(type);
            if (clazz == null) {
                return false;
            }
            if (clazz.superType != null) {
                return this.isKeptDirectlyOrIndirectly(clazz.superType, appInfo);
            }
            return false;
        }

        public boolean verifyKeptItemsAreKept(DexApplication application, AppInfo appInfo) {
            Set<DexReference> pinnedItems = appInfo.hasLiveness() ? appInfo.withLiveness().pinnedItems : null;
            IdentityHashMap<DexType, Set> requiredReferencesPerType = new IdentityHashMap<DexType, Set>();
            for (DexReference dexReference : this.noShrinking.keySet()) {
                assert (pinnedItems == null || pinnedItems.contains(dexReference)) : "Expected reference `" + dexReference.toSourceString() + "` to be pinned";
                if (dexReference.isDexType()) {
                    DexType type = dexReference.asDexType();
                    requiredReferencesPerType.putIfAbsent(type, Sets.newIdentityHashSet());
                    continue;
                }
                assert (dexReference.isDexField() || dexReference.isDexMethod());
                DexType holder = dexReference.isDexField() ? dexReference.asDexField().holder : dexReference.asDexMethod().holder;
                requiredReferencesPerType.computeIfAbsent(holder, key -> Sets.newIdentityHashSet()).add(dexReference);
            }
            for (DexProgramClass dexProgramClass : application.classes()) {
                Set requiredReferences = requiredReferencesPerType.getOrDefault(dexProgramClass.type, ImmutableSet.of());
                Set fields = null;
                Set methods = null;
                for (DexReference requiredReference : requiredReferences) {
                    if (requiredReference.isDexField()) {
                        DexField requiredField = requiredReference.asDexField();
                        if (fields == null) {
                            fields = Streams.stream(dexProgramClass.fields()).map(DexEncodedField::getKey).collect(Collectors.toSet());
                        }
                        assert (fields.contains(requiredField)) : "Expected field `" + requiredField.toSourceString() + "` from the root set to be present";
                        continue;
                    }
                    if (requiredReference.isDexMethod()) {
                        DexMethod requiredMethod = requiredReference.asDexMethod();
                        if (methods == null) {
                            methods = Streams.stream(dexProgramClass.methods()).map(DexEncodedMethod::getKey).collect(Collectors.toSet());
                        }
                        assert (methods.contains(requiredMethod)) : "Expected method `" + requiredMethod.toSourceString() + "` from the root set to be present";
                        continue;
                    }
                    assert (false);
                }
                requiredReferencesPerType.remove(dexProgramClass.type);
            }
            if (!requiredReferencesPerType.isEmpty()) {
                DexType type = (DexType)requiredReferencesPerType.keySet().iterator().next();
                DexClass dexClass = application.definitionFor(type);
                assert (dexClass == null || dexClass.isProgramClass()) : "Unexpected library type in root set: `" + type + "`";
                assert (requiredReferencesPerType.isEmpty()) : "Expected type `" + type.toSourceString() + "` to be present";
            }
            return true;
        }

        public String toString() {
            StringBuilder builder = new StringBuilder();
            builder.append("RootSet");
            builder.append("\nnoShrinking: " + this.noShrinking.size());
            builder.append("\nnoOptimization: " + this.noOptimization.size());
            builder.append("\nnoObfuscation: " + this.noObfuscation.size());
            builder.append("\nreasonAsked: " + this.reasonAsked.size());
            builder.append("\ncheckDiscarded: " + this.checkDiscarded.size());
            builder.append("\nnoSideEffects: " + this.noSideEffects.size());
            builder.append("\nassumedValues: " + this.assumedValues.size());
            builder.append("\ndependentNoShrinking: " + this.dependentNoShrinking.size());
            builder.append("\nidentifierNameStrings: " + this.identifierNameStrings.size());
            builder.append("\nifRules: " + this.ifRules.size());
            builder.append("\n\nNo Shrinking:");
            this.noShrinking.keySet().stream().sorted(Comparator.comparing(DexItem::toSourceString)).forEach(a -> builder.append("\n").append(a.toSourceString()).append(" ").append(this.noShrinking.get(a)));
            builder.append("\n");
            return builder.toString();
        }
    }

    private class SynthesizeMissingInterfaceMethodsForMemberRules {
        private final DexProgramClass originalClazz;
        private final Collection<ProguardMemberRule> memberKeepRules;
        private final ProguardConfigurationRule context;
        private final Map<Predicate<DexDefinition>, DexDefinition> preconditionSupplier;
        private final ProguardIfRule ifRule;
        private final Set<Equivalence.Wrapper<DexMethod>> seenMethods = Sets.newHashSet();
        private final Set<DexType> seenTypes = Sets.newIdentityHashSet();

        private SynthesizeMissingInterfaceMethodsForMemberRules(DexProgramClass originalClazz, Collection<ProguardMemberRule> memberKeepRules, ProguardConfigurationRule context, Map<Predicate<DexDefinition>, DexDefinition> preconditionSupplier, ProguardIfRule ifRule) {
            assert (context.isProguardKeepRule());
            assert (!context.asProguardKeepRule().getModifiers().allowsShrinking);
            this.originalClazz = originalClazz;
            this.memberKeepRules = memberKeepRules;
            this.context = context;
            this.preconditionSupplier = preconditionSupplier;
            this.ifRule = ifRule;
        }

        void run() {
            this.visitAllSuperInterfaces(this.originalClazz.type);
        }

        private void visitAllSuperInterfaces(DexType type) {
            DexClass clazz = RootSetBuilder.this.appView.definitionFor(type);
            if (clazz == null || clazz.isNotProgramClass() || !this.seenTypes.add(type)) {
                return;
            }
            for (DexType iface : clazz.interfaces.values) {
                this.visitAllSuperInterfaces(iface);
            }
            if (!clazz.isInterface()) {
                this.visitAllSuperInterfaces(clazz.superType);
                return;
            }
            if (this.originalClazz == clazz) {
                return;
            }
            for (DexEncodedMethod method : clazz.virtualMethods()) {
                Equivalence.Wrapper<DexMethod> wrapped = MethodSignatureEquivalence.get().wrap(method.method);
                if (!this.seenMethods.add(wrapped)) continue;
                for (ProguardMemberRule rule : this.memberKeepRules) {
                    if (!rule.matches(method, RootSetBuilder.this.appView, RootSetBuilder.this.dexStringCache)) continue;
                    this.tryAndKeepMethodOnClass(method, rule);
                }
            }
        }

        private void tryAndKeepMethodOnClass(DexEncodedMethod method, ProguardMemberRule rule) {
            ResolutionResult.SingleResolutionResult resolutionResult = ((AppInfoWithSubtyping)RootSetBuilder.this.appView.appInfo()).resolveMethod(this.originalClazz, method.method).asSingleResolution();
            if (resolutionResult == null || !resolutionResult.isVirtualTarget()) {
                return;
            }
            if (resolutionResult.getResolvedHolder() == this.originalClazz || resolutionResult.getResolvedHolder().isNotProgramClass()) {
                return;
            }
            if (!resolutionResult.getResolvedHolder().isInterface()) {
                return;
            }
            ProgramMethod resolutionMethod = new ProgramMethod(resolutionResult.getResolvedHolder().asProgramClass(), resolutionResult.getResolvedMethod());
            ProgramMethod methodToKeep = RootSetBuilder.this.canInsertForwardingMethod(this.originalClazz, resolutionMethod.method) ? new ProgramMethod(this.originalClazz, resolutionMethod.method.toForwardingMethod(this.originalClazz, RootSetBuilder.this.appView)) : resolutionMethod;
            RootSetBuilder.this.delayedRootSetActionItems.add(new DelayedRootSetActionItem.InterfaceMethodSyntheticBridgeAction(methodToKeep, resolutionMethod, rootSetBuilder -> {
                if (Log.ENABLED) {
                    Log.verbose(this.getClass(), "Marking method `%s` due to `%s { %s }`.", methodToKeep, this.context, rule);
                }
                DexDefinition precondition = RootSetBuilder.testAndGetPrecondition(methodToKeep.method, this.preconditionSupplier);
                ((RootSetBuilder)rootSetBuilder).addItemToSets(methodToKeep.method, this.context, rule, precondition, this.ifRule);
            }));
        }
    }
}

