/*
 * Decompiled with CFR 0.152.
 */
package shadow.bundletool.com.android.tools.r8.retrace;

import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import java.util.stream.Stream;
import shadow.bundletool.com.android.tools.r8.Keep;
import shadow.bundletool.com.android.tools.r8.naming.ClassNamingForNameMapper;
import shadow.bundletool.com.android.tools.r8.naming.MemberNaming;
import shadow.bundletool.com.android.tools.r8.naming.Range;
import shadow.bundletool.com.android.tools.r8.references.ClassReference;
import shadow.bundletool.com.android.tools.r8.references.MethodReference;
import shadow.bundletool.com.android.tools.r8.references.Reference;
import shadow.bundletool.com.android.tools.r8.references.TypeReference;
import shadow.bundletool.com.android.tools.r8.retrace.Result;
import shadow.bundletool.com.android.tools.r8.retrace.RetraceClassResult;
import shadow.bundletool.com.android.tools.r8.utils.DescriptorUtils;

@Keep
public class RetraceMethodResult
extends Result<Element, RetraceMethodResult> {
    private final String obfuscatedName;
    private final RetraceClassResult.Element classElement;
    private final ClassNamingForNameMapper.MappedRangesOfName mappedRanges;
    private Boolean isAmbiguousCached = null;

    RetraceMethodResult(RetraceClassResult.Element classElement, ClassNamingForNameMapper.MappedRangesOfName mappedRanges, String obfuscatedName) {
        this.classElement = classElement;
        this.mappedRanges = mappedRanges;
        this.obfuscatedName = obfuscatedName;
        assert (classElement != null);
    }

    public MethodReference.UnknownMethodReference getUnknownReference() {
        return new MethodReference.UnknownMethodReference(this.classElement.getClassReference(), this.obfuscatedName);
    }

    private boolean hasRetraceResult() {
        return this.mappedRanges != null && this.mappedRanges.getMappedRanges().size() > 0;
    }

    public boolean isAmbiguous() {
        if (this.isAmbiguousCached != null) {
            return this.isAmbiguousCached;
        }
        if (!this.hasRetraceResult()) {
            return false;
        }
        assert (this.mappedRanges != null);
        Range minifiedRange = null;
        boolean seenNull = false;
        for (ClassNamingForNameMapper.MappedRange mappedRange : this.mappedRanges.getMappedRanges()) {
            if (minifiedRange != null && !minifiedRange.equals(mappedRange.minifiedRange)) {
                this.isAmbiguousCached = true;
                return true;
            }
            if (minifiedRange == null) {
                if (seenNull) {
                    this.isAmbiguousCached = true;
                    return true;
                }
                seenNull = true;
            }
            minifiedRange = mappedRange.minifiedRange;
        }
        this.isAmbiguousCached = false;
        return false;
    }

    public RetraceMethodResult narrowByLine(int linePosition) {
        if (!this.hasRetraceResult()) {
            return this;
        }
        List<ClassNamingForNameMapper.MappedRange> narrowedRanges = this.mappedRanges.allRangesForLine(linePosition, false);
        if (narrowedRanges.isEmpty()) {
            narrowedRanges = new ArrayList<ClassNamingForNameMapper.MappedRange>();
            for (ClassNamingForNameMapper.MappedRange mappedRange : this.mappedRanges.getMappedRanges()) {
                if (mappedRange.minifiedRange != null) continue;
                narrowedRanges.add(mappedRange);
            }
        }
        return new RetraceMethodResult(this.classElement, new ClassNamingForNameMapper.MappedRangesOfName(narrowedRanges), this.obfuscatedName);
    }

    @Override
    public Stream<Element> stream() {
        if (!this.hasRetraceResult()) {
            return Stream.of(new Element(this, this.classElement, this.getUnknownReference(), null));
        }
        return this.mappedRanges.getMappedRanges().stream().map(mappedRange -> {
            MemberNaming.MethodSignature signature = mappedRange.signature;
            ClassReference holder = mappedRange.signature.isQualified() ? Reference.classFromDescriptor(DescriptorUtils.javaTypeToDescriptor(mappedRange.signature.toHolderFromQualified())) : this.classElement.getClassReference();
            ArrayList<TypeReference> formalTypes = new ArrayList<TypeReference>(signature.parameters.length);
            for (String parameter : signature.parameters) {
                formalTypes.add(Reference.typeFromTypeName(parameter));
            }
            TypeReference returnType = Reference.returnTypeFromDescriptor(DescriptorUtils.javaTypeToDescriptor(signature.type));
            MethodReference retracedMethod = Reference.method(holder, signature.isQualified() ? signature.toUnqualifiedName() : signature.name, formalTypes, returnType);
            return new Element(this, this.classElement, retracedMethod, (ClassNamingForNameMapper.MappedRange)mappedRange);
        });
    }

    @Override
    public RetraceMethodResult forEach(Consumer<Element> resultConsumer) {
        this.stream().forEach(resultConsumer);
        return this;
    }

    public static class Element {
        private final MethodReference methodReference;
        private final RetraceMethodResult retraceMethodResult;
        private final RetraceClassResult.Element classElement;
        private final ClassNamingForNameMapper.MappedRange mappedRange;

        private Element(RetraceMethodResult retraceMethodResult, RetraceClassResult.Element classElement, MethodReference methodReference, ClassNamingForNameMapper.MappedRange mappedRange) {
            this.classElement = classElement;
            this.retraceMethodResult = retraceMethodResult;
            this.methodReference = methodReference;
            this.mappedRange = mappedRange;
        }

        public MethodReference getMethodReference() {
            return this.methodReference;
        }

        public RetraceMethodResult getRetraceMethodResult() {
            return this.retraceMethodResult;
        }

        public RetraceClassResult.Element getClassElement() {
            return this.classElement;
        }

        public int getOriginalLineNumber(int linePosition) {
            return this.mappedRange != null ? this.mappedRange.getOriginalLineNumber(linePosition) : linePosition;
        }

        public boolean containsMinifiedLineNumber(int linePosition) {
            if (this.hasNoLineNumberRange()) {
                return false;
            }
            return this.mappedRange.minifiedRange.from <= linePosition && linePosition <= this.mappedRange.minifiedRange.to;
        }

        public boolean hasNoLineNumberRange() {
            return this.mappedRange == null || this.mappedRange.minifiedRange == null;
        }

        public int getFirstLineNumberOfOriginalRange() {
            if (this.hasNoLineNumberRange()) {
                return 0;
            }
            return this.mappedRange.getFirstLineNumberOfOriginalRange();
        }
    }
}

