/*
 * Decompiled with CFR 0.152.
 */
package shadow.bundletool.com.android.tools.r8.retrace;

import shadow.bundletool.com.android.tools.r8.Diagnostic;
import shadow.bundletool.com.android.tools.r8.Keep;
import shadow.bundletool.com.android.tools.r8.origin.Origin;
import shadow.bundletool.com.android.tools.r8.position.Position;
import shadow.bundletool.com.android.tools.r8.position.TextPosition;

@Keep
public class RetraceInvalidStackTraceLineDiagnostics
implements Diagnostic {
    private static final String NULL_STACK_TRACE_LINE_MESSAGE = "The stack trace line is <null>";
    private static final String PARSE_STACK_TRACE_LINE_MESSAGE = "Could not parse the stack trace line '%s'";
    private final int lineNumber;
    private final String message;

    private RetraceInvalidStackTraceLineDiagnostics(int lineNumber, String message) {
        this.lineNumber = lineNumber;
        this.message = message;
    }

    @Override
    public Origin getOrigin() {
        return Origin.unknown();
    }

    @Override
    public Position getPosition() {
        return new TextPosition(0L, this.lineNumber, -1);
    }

    @Override
    public String getDiagnosticMessage() {
        return this.message;
    }

    public static RetraceInvalidStackTraceLineDiagnostics createNull(int lineNumber) {
        return new RetraceInvalidStackTraceLineDiagnostics(lineNumber, NULL_STACK_TRACE_LINE_MESSAGE);
    }

    public static RetraceInvalidStackTraceLineDiagnostics createParse(int lineNumber, String line) {
        return new RetraceInvalidStackTraceLineDiagnostics(lineNumber, String.format(PARSE_STACK_TRACE_LINE_MESSAGE, line));
    }
}

