/*
 * Decompiled with CFR 0.152.
 */
package shadow.bundletool.com.android.tools.r8.retrace;

import java.util.Comparator;
import java.util.function.BiFunction;

public abstract class AmbiguousComparator<T>
implements Comparator<T> {
    private final BiFunction<T, SortKeys, String> getter;

    public AmbiguousComparator(BiFunction<T, SortKeys, String> getter) {
        this.getter = getter;
    }

    @Override
    public int compare(T o1, T o2) {
        int compare = this.getter.apply(o1, SortKeys.CLASS).compareTo(this.getter.apply(o2, SortKeys.CLASS));
        if (compare != 0) {
            return compare;
        }
        compare = this.getter.apply(o1, SortKeys.METHOD).compareTo(this.getter.apply(o2, SortKeys.METHOD));
        if (compare != 0) {
            return compare;
        }
        compare = this.getter.apply(o1, SortKeys.SOURCE).compareTo(this.getter.apply(o2, SortKeys.SOURCE));
        if (compare != 0) {
            return compare;
        }
        try {
            return Integer.compare(Integer.parseInt(this.getter.apply(o1, SortKeys.LINE)), Integer.parseInt(this.getter.apply(o2, SortKeys.SOURCE)));
        }
        catch (NumberFormatException ignore) {
            return 0;
        }
    }

    public static enum SortKeys {
        CLASS,
        METHOD,
        SOURCE,
        LINE;

    }
}

