/*
 * Decompiled with CFR 0.152.
 */
package shadow.bundletool.com.android.tools.r8.naming;

import java.util.IdentityHashMap;
import java.util.Map;
import java.util.function.BiPredicate;
import shadow.bundletool.com.android.tools.r8.graph.AppInfo;
import shadow.bundletool.com.android.tools.r8.graph.AppView;
import shadow.bundletool.com.android.tools.r8.graph.DexClass;
import shadow.bundletool.com.android.tools.r8.graph.DexEncodedField;
import shadow.bundletool.com.android.tools.r8.graph.DexField;
import shadow.bundletool.com.android.tools.r8.graph.DexString;
import shadow.bundletool.com.android.tools.r8.graph.DexType;
import shadow.bundletool.com.android.tools.r8.naming.FieldNamingStateBase;
import shadow.bundletool.com.android.tools.r8.naming.InternalNamingState;
import shadow.bundletool.com.android.tools.r8.naming.MemberNamingStrategy;
import shadow.bundletool.com.android.tools.r8.naming.ReservedFieldNamingState;

public class FieldNamingState
extends FieldNamingStateBase<InternalState>
implements Cloneable {
    private final ReservedFieldNamingState reservedNames;
    private final MemberNamingStrategy strategy;
    private final BiPredicate<DexString, DexField> isAvailable;

    public FieldNamingState(AppView<?> appView, MemberNamingStrategy strategy) {
        this(appView, strategy, new ReservedFieldNamingState(appView));
    }

    public FieldNamingState(AppView<?> appView, MemberNamingStrategy strategy, ReservedFieldNamingState reservedNames) {
        this(appView, strategy, reservedNames, new IdentityHashMap<DexType, InternalState>());
    }

    private FieldNamingState(AppView<?> appView, MemberNamingStrategy strategy, ReservedFieldNamingState reservedNames, Map<DexType, InternalState> internalStates) {
        super(appView, internalStates);
        this.reservedNames = reservedNames;
        this.strategy = strategy;
        this.isAvailable = (newName, field) -> !reservedNames.isReserved((DexString)newName, field.type);
    }

    public FieldNamingState createChildState(ReservedFieldNamingState reservedNames) {
        FieldNamingState childState = new FieldNamingState(this.appView, this.strategy, reservedNames, this.internalStates);
        childState.includeReservations(this.reservedNames);
        return childState;
    }

    public DexString getOrCreateNameFor(DexField field) {
        DexEncodedField encodedField = ((AppInfo)this.appView.appInfo()).resolveField(field);
        if (encodedField != null) {
            DexClass clazz = this.appView.definitionFor(encodedField.field.holder);
            if (clazz == null) {
                return field.name;
            }
            DexString reservedName = this.strategy.getReservedName(encodedField, clazz);
            if (reservedName != null) {
                return reservedName;
            }
        }
        return ((InternalState)this.getOrCreateInternalState(field)).createNewName(field);
    }

    public void includeReservations(ReservedFieldNamingState reservedNames) {
        this.reservedNames.includeReservations(reservedNames);
    }

    @Override
    public InternalState createInternalState() {
        return new InternalState();
    }

    public FieldNamingState clone() {
        IdentityHashMap<DexType, InternalState> internalStatesClone = new IdentityHashMap<DexType, InternalState>();
        for (Map.Entry entry : this.internalStates.entrySet()) {
            internalStatesClone.put((DexType)entry.getKey(), ((InternalState)entry.getValue()).clone());
        }
        return new FieldNamingState(this.appView, this.strategy, this.reservedNames, internalStatesClone);
    }

    class InternalState
    implements InternalNamingState,
    Cloneable {
        private int dictionaryIndex;
        private int nextNameIndex;

        public InternalState() {
            this(1, 0);
        }

        public InternalState(int nextNameIndex, int dictionaryIndex) {
            this.dictionaryIndex = dictionaryIndex;
            this.nextNameIndex = nextNameIndex;
        }

        public DexString createNewName(DexField field) {
            DexString name = FieldNamingState.this.strategy.next(field, (InternalNamingState)this, FieldNamingState.this.isAvailable);
            assert (!FieldNamingState.this.reservedNames.isReserved(name, field.type));
            return name;
        }

        public InternalState clone() {
            return new InternalState(this.nextNameIndex, this.dictionaryIndex);
        }

        @Override
        public int getDictionaryIndex() {
            return this.dictionaryIndex;
        }

        @Override
        public int incrementDictionaryIndex() {
            return this.dictionaryIndex++;
        }

        @Override
        public int incrementNameIndex(boolean isDirectMethodCall) {
            assert (!isDirectMethodCall);
            return this.nextNameIndex++;
        }
    }
}

