/*
 * Decompiled with CFR 0.152.
 */
package shadow.bundletool.com.android.tools.r8.kotlin;

import java.io.BufferedReader;
import java.io.Closeable;
import java.io.IOException;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import shadow.bundletool.com.android.tools.r8.naming.Range;
import shadow.bundletool.com.android.tools.r8.utils.SegmentTree;
import shadow.bundletool.com.android.tools.r8.utils.ThrowingConsumer;

public class KotlinSourceDebugExtensionParser {
    private static final String SMAP_IDENTIFIER = "SMAP";
    private static final String SMAP_SECTION_START = "*S";
    private static final String SMAP_SECTION_KOTLIN_START = "*S Kotlin";
    private static final String SMAP_FILES_IDENTIFIER = "*F";
    private static final String SMAP_LINES_IDENTIFIER = "*L";
    private static final String SMAP_END_IDENTIFIER = "*E";

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static Result parse(String annotationData) {
        if (annotationData == null) return null;
        if (annotationData.isEmpty()) {
            return null;
        }
        try (BufferedStringReader reader = new BufferedStringReader(annotationData);){
            ResultBuilder builder = new ResultBuilder();
            if (!reader.readExpectedLine(SMAP_IDENTIFIER)) {
                Result result = null;
                return result;
            }
            if (reader.readUntil(SMAP_SECTION_KOTLIN_START).isEOF()) {
                Result result = null;
                return result;
            }
            reader.readExpectedLineOrThrow(SMAP_FILES_IDENTIFIER);
            reader.readUntil(SMAP_LINES_IDENTIFIER, 2, block -> KotlinSourceDebugExtensionParser.addFileToBuilder((String)block.get(0), (String)block.get(1), builder));
            if (reader.isEOF()) {
                throw new KotlinSourceDebugExtensionParserException("Unexpected EOF - no debug line positions");
            }
            reader.readUntil(SMAP_END_IDENTIFIER, 1, block -> KotlinSourceDebugExtensionParser.addDebugEntryToBuilder((String)block.get(0), builder));
            if (reader.isEOF()) {
                throw new KotlinSourceDebugExtensionParserException("Unexpected EOF when parsing SMAP debug entries");
            }
            Result result = builder.build();
            return result;
        }
        catch (IOException | KotlinSourceDebugExtensionParserException e) {
            return null;
        }
    }

    private static void addFileToBuilder(String entryLine, String filePath, ResultBuilder builder) throws KotlinSourceDebugExtensionParserException {
        String[] entries = entryLine.trim().split(" ");
        if (entries.length != 3 || !entries[0].equals("+")) {
            throw new KotlinSourceDebugExtensionParserException("Wrong number of entries on line " + entryLine);
        }
        String fileName = entries[2];
        if (fileName.isEmpty()) {
            throw new KotlinSourceDebugExtensionParserException("Did not expect file name to be empty for line " + entryLine);
        }
        if (filePath == null || filePath.isEmpty()) {
            throw new KotlinSourceDebugExtensionParserException("Did not expect file path to be null or empty for " + entryLine);
        }
        int index = KotlinSourceDebugExtensionParser.asInteger(entries[1]);
        Source source = new Source(fileName, filePath);
        Source existingSource = builder.files.put(index, source);
        if (existingSource != null) {
            throw new KotlinSourceDebugExtensionParserException("File index " + index + " was already mapped to an existing source: " + source);
        }
    }

    private static int asInteger(String numberAsString) throws KotlinSourceDebugExtensionParserException {
        int number = -1;
        try {
            number = Integer.parseInt(numberAsString);
        }
        catch (NumberFormatException e) {
            throw new KotlinSourceDebugExtensionParserException("Could not parse number " + numberAsString);
        }
        return number;
    }

    private static void addDebugEntryToBuilder(String debugEntry, ResultBuilder builder) throws KotlinSourceDebugExtensionParserException {
        try {
            int targetSplit = debugEntry.indexOf(58);
            int target = Integer.parseInt(debugEntry.substring(targetSplit + 1));
            String original = debugEntry.substring(0, targetSplit);
            int fileIndexSplit = original.indexOf(35);
            int originalStart = Integer.parseInt(original.substring(0, fileIndexSplit));
            String fileAndEndRange = original.substring(fileIndexSplit + 1);
            int endRangeCharPosition = fileAndEndRange.indexOf(44);
            int size = 1;
            if (endRangeCharPosition > -1) {
                assert (endRangeCharPosition > 0);
                size = Integer.parseInt(fileAndEndRange.substring(endRangeCharPosition + 1));
            } else {
                endRangeCharPosition = fileAndEndRange.length();
            }
            int fileIndex = Integer.parseInt(fileAndEndRange.substring(0, endRangeCharPosition));
            Source thisFileSource = builder.files.get(fileIndex);
            if (thisFileSource == null) {
                throw new KotlinSourceDebugExtensionParserException("Could not find file with index " + fileIndex);
            }
            Range range = new Range(originalStart, originalStart + (size - 1));
            Position position = new Position(thisFileSource, range);
            builder.segmentTree.add(target, target + (size - 1), position);
        }
        catch (NumberFormatException e) {
            throw new KotlinSourceDebugExtensionParserException("Could not convert position to number");
        }
    }

    public static class Position {
        private final Source source;
        private final Range range;

        public Position(Source source, Range range) {
            this.source = source;
            this.range = range;
        }

        public Source getSource() {
            return this.source;
        }

        public Range getRange() {
            return this.range;
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            sb.append(this.range.from);
            sb.append("#");
            sb.append(this.source);
            if (this.range.to != this.range.from) {
                sb.append(",");
                sb.append(this.range.to);
            }
            sb.append(":");
            return sb.toString();
        }
    }

    public static class Source {
        private final String fileName;
        private final String path;

        private Source(String fileName, String path) {
            this.fileName = fileName;
            this.path = path;
        }

        public String getFileName() {
            return this.fileName;
        }

        public String getPath() {
            return this.path;
        }

        public String toString() {
            return this.path + "(" + this.fileName + ")";
        }
    }

    public static class ResultBuilder {
        SegmentTree<Position> segmentTree = new SegmentTree(false);
        Map<Integer, Source> files = new HashMap<Integer, Source>();

        public Result build() {
            return new Result(this.segmentTree);
        }
    }

    public static class Result {
        private final SegmentTree<Position> segmentTree;

        public Result(SegmentTree<Position> segmentTree) {
            this.segmentTree = segmentTree;
        }

        public Map.Entry<Integer, Position> lookup(int point) {
            return this.segmentTree.findEntry(point);
        }

        public int size() {
            return this.segmentTree.size();
        }
    }

    public static class BufferedStringReader
    implements Closeable {
        private final BufferedReader reader;
        private String readLine;

        BufferedStringReader(String data2) {
            this.reader = new BufferedReader(new StringReader(data2));
        }

        String readNextLine() throws IOException {
            this.readLine = this.reader.readLine();
            return this.readLine;
        }

        boolean readExpectedLine(String expected) throws IOException {
            return this.readNextLine().equals(expected);
        }

        void readExpectedLineOrThrow(String expected) throws KotlinSourceDebugExtensionParserException, IOException {
            if (!this.readExpectedLine(expected)) {
                throw new KotlinSourceDebugExtensionParserException("The string " + this.readLine + " does not match the expected string " + expected);
            }
        }

        boolean isEOF() {
            return this.readLine == null;
        }

        BufferedStringReader readUntil(String terminator) throws IOException {
            while (!terminator.equals(this.readLine) && !this.isEOF()) {
                this.readNextLine();
            }
            if (this.isEOF()) {
                return this;
            }
            return this;
        }

        void readUntil(String terminator, int linesInBlock, ThrowingConsumer<List<String>, KotlinSourceDebugExtensionParserException> callback) throws IOException, KotlinSourceDebugExtensionParserException {
            if (terminator.equals(this.readLine)) {
                return;
            }
            ArrayList<String> readStrings = new ArrayList<String>();
            readStrings.add(this.readNextLine());
            int linesLeft = linesInBlock;
            while (!terminator.equals(this.readLine) && !this.isEOF()) {
                if (linesLeft == 1) {
                    assert (readStrings.size() == linesInBlock);
                    callback.accept(readStrings);
                    linesLeft = linesInBlock;
                    readStrings = new ArrayList();
                } else {
                    --linesLeft;
                }
                readStrings.add(this.readNextLine());
            }
            if (readStrings.size() > 0 && !((String)readStrings.get(0)).equals(terminator)) {
                throw new KotlinSourceDebugExtensionParserException("Block size does not match linesInBlock = " + linesInBlock);
            }
        }

        @Override
        public void close() throws IOException {
            this.reader.close();
        }
    }

    public static class KotlinSourceDebugExtensionParserException
    extends Exception {
        KotlinSourceDebugExtensionParserException(String message) {
            super(message);
        }
    }
}

