/*
 * Decompiled with CFR 0.152.
 */
package shadow.bundletool.com.android.tools.r8.ir.optimize.inliner;

import java.util.Set;
import shadow.bundletool.com.android.tools.r8.graph.DexType;
import shadow.bundletool.com.android.tools.r8.ir.code.IRCode;
import shadow.bundletool.com.android.tools.r8.ir.code.Instruction;
import shadow.bundletool.com.android.tools.r8.ir.code.Monitor;
import shadow.bundletool.com.android.tools.r8.ir.code.Value;

public class InlinerUtils {
    public static void collectAllMonitorEnterValues(IRCode code, Set<DexType> constantMonitorEnterValues, Set<Value> nonConstantMonitorEnterValues) {
        assert (code.metadata().mayHaveMonitorInstruction());
        for (Monitor monitor : code.instructions(Instruction::isMonitorEnter)) {
            Value monitorEnterValue = monitor.object().getAliasedValue();
            InlinerUtils.addMonitorEnterValue(monitorEnterValue, constantMonitorEnterValues, nonConstantMonitorEnterValues);
        }
    }

    public static void addMonitorEnterValue(Value monitorEnterValue, Set<DexType> constantMonitorEnterValues, Set<Value> nonConstantMonitorEnterValues) {
        assert (!monitorEnterValue.hasAliasedValue());
        if (monitorEnterValue.isPhi() || !monitorEnterValue.definition.isConstClass()) {
            nonConstantMonitorEnterValues.add(monitorEnterValue);
        } else {
            constantMonitorEnterValues.add(monitorEnterValue.definition.asConstClass().getValue());
        }
    }
}

