/*
 * Decompiled with CFR 0.152.
 */
package shadow.bundletool.com.android.tools.r8.ir.optimize.info;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import shadow.bundletool.com.android.tools.r8.com.google.common.collect.ImmutableCollection;
import shadow.bundletool.com.android.tools.r8.com.google.common.collect.ImmutableList;
import shadow.bundletool.com.android.tools.r8.com.google.common.collect.ImmutableSet;
import shadow.bundletool.com.android.tools.r8.graph.DexMethod;
import shadow.bundletool.com.android.tools.r8.ir.code.If;
import shadow.bundletool.com.android.tools.r8.ir.code.InstanceGet;
import shadow.bundletool.com.android.tools.r8.ir.code.InstancePut;
import shadow.bundletool.com.android.tools.r8.ir.code.Instruction;
import shadow.bundletool.com.android.tools.r8.ir.code.Invoke;
import shadow.bundletool.com.android.tools.r8.ir.code.InvokeMethodWithReceiver;
import shadow.bundletool.com.android.tools.r8.ir.code.Monitor;
import shadow.bundletool.com.android.tools.r8.ir.code.Return;
import shadow.bundletool.com.android.tools.r8.ir.code.Value;
import shadow.bundletool.com.android.tools.r8.ir.optimize.info.DefaultMethodOptimizationInfo;
import shadow.bundletool.com.android.tools.r8.utils.ListUtils;
import shadow.bundletool.com.android.tools.r8.utils.Pair;

public final class ParameterUsagesInfo {
    private ImmutableList<ParameterUsage> parametersUsages;

    public ParameterUsagesInfo(List<ParameterUsage> usages) {
        assert (!usages.isEmpty());
        this.parametersUsages = ImmutableList.copyOf(usages);
        assert (this.parametersUsages.size() == this.parametersUsages.stream().map(usage -> usage.index).collect(Collectors.toSet()).size());
    }

    ParameterUsage getParameterUsage(int index) {
        for (ParameterUsage usage : this.parametersUsages) {
            if (usage.index != index) continue;
            return usage;
        }
        return null;
    }

    ParameterUsagesInfo remove(int index) {
        assert (this.parametersUsages.size() > 0);
        assert (0 <= index && index <= ListUtils.last(this.parametersUsages).index);
        ImmutableList.Builder builder = ImmutableList.builder();
        for (ParameterUsage usage : this.parametersUsages) {
            if (index < usage.index) {
                builder.add(ParameterUsage.copyAndShift(usage, 1));
                continue;
            }
            if (index == usage.index) continue;
            assert (usage.index < index);
            builder.add(usage);
        }
        ImmutableCollection adjustedUsages = builder.build();
        if (adjustedUsages.isEmpty()) {
            return DefaultMethodOptimizationInfo.UNKNOWN_PARAMETER_USAGE_INFO;
        }
        return new ParameterUsagesInfo((List<ParameterUsage>)((Object)adjustedUsages));
    }

    public static class ParameterUsageBuilder {
        private final int index;
        private final Value arg;
        private final Set<If.Type> ifZeroTestTypes = new HashSet<If.Type>();
        private final List<Pair<Invoke.Type, DexMethod>> callsOnReceiver = new ArrayList<Pair<Invoke.Type, DexMethod>>();
        private boolean hasFieldAssignment = false;
        private boolean hasFieldRead = false;
        private boolean isAssignedToField = false;
        private boolean isReturned = false;
        private boolean isUsedInMonitor = false;

        ParameterUsageBuilder(Value arg, int index) {
            this.arg = arg;
            this.index = index;
        }

        public boolean note(Instruction instruction) {
            if (instruction.isAssume()) {
                return !instruction.outValue().hasPhiUsers();
            }
            if (instruction.isIf()) {
                return this.note(instruction.asIf());
            }
            if (instruction.isInstanceGet()) {
                return this.note(instruction.asInstanceGet());
            }
            if (instruction.isInstancePut()) {
                return this.note(instruction.asInstancePut());
            }
            if (instruction.isInvokeMethodWithReceiver()) {
                return this.note(instruction.asInvokeMethodWithReceiver());
            }
            if (instruction.isReturn()) {
                return this.note(instruction.asReturn());
            }
            if (instruction.isMonitor()) {
                return this.note(instruction.asMonitor());
            }
            return false;
        }

        public ParameterUsage build() {
            return new ParameterUsage(this.index, this.ifZeroTestTypes, this.callsOnReceiver, this.hasFieldAssignment, this.hasFieldRead, this.isAssignedToField, this.isReturned, this.isUsedInMonitor);
        }

        private boolean note(If ifInstruction) {
            if (ifInstruction.asIf().isZeroTest()) {
                assert (ifInstruction.inValues().size() == 1 && ifInstruction.inValues().get(0).getAliasedValue() == this.arg);
                this.ifZeroTestTypes.add(ifInstruction.asIf().getType());
                return true;
            }
            return false;
        }

        private boolean note(InstanceGet instanceGetInstruction) {
            assert (this.arg != instanceGetInstruction.outValue());
            if (instanceGetInstruction.object().getAliasedValue() == this.arg) {
                this.hasFieldRead = true;
                return true;
            }
            return false;
        }

        private boolean note(InstancePut instancePutInstruction) {
            assert (this.arg != instancePutInstruction.outValue());
            if (instancePutInstruction.object().getAliasedValue() == this.arg) {
                this.hasFieldAssignment = true;
                this.isAssignedToField |= instancePutInstruction.value().getAliasedValue() == this.arg;
                return true;
            }
            if (instancePutInstruction.value().getAliasedValue() == this.arg) {
                this.isAssignedToField = true;
                return true;
            }
            return false;
        }

        private boolean note(InvokeMethodWithReceiver invokeInstruction) {
            if (ListUtils.lastIndexMatching(invokeInstruction.inValues(), v -> v.getAliasedValue() == this.arg) == 0) {
                this.callsOnReceiver.add(new Pair<Invoke.Type, DexMethod>(invokeInstruction.asInvokeMethodWithReceiver().getType(), invokeInstruction.asInvokeMethodWithReceiver().getInvokedMethod()));
                return true;
            }
            return false;
        }

        private boolean note(Return returnInstruction) {
            assert (returnInstruction.inValues().size() == 1 && returnInstruction.inValues().get(0).getAliasedValue() == this.arg);
            this.isReturned = true;
            return true;
        }

        private boolean note(Monitor monitorInstruction) {
            assert (monitorInstruction.inValues().size() == 1);
            assert (monitorInstruction.inValues().get(0).getAliasedValue() == this.arg);
            this.isUsedInMonitor = true;
            return true;
        }
    }

    public static final class ParameterUsage {
        public final int index;
        public final Set<If.Type> ifZeroTest;
        public final List<Pair<Invoke.Type, DexMethod>> callsReceiver;
        public final boolean hasFieldAssignment;
        public final boolean hasFieldRead;
        public final boolean isAssignedToField;
        public final boolean isReturned;
        public final boolean isUsedInMonitor;

        ParameterUsage(int index, Set<If.Type> ifZeroTest, List<Pair<Invoke.Type, DexMethod>> callsReceiver, boolean hasFieldAssignment, boolean hasFieldRead, boolean isAssignedToField, boolean isReturned, boolean isUsedInMonitor) {
            this.index = index;
            this.ifZeroTest = ifZeroTest.isEmpty() ? Collections.emptySet() : ImmutableSet.copyOf(ifZeroTest);
            this.callsReceiver = callsReceiver.isEmpty() ? Collections.emptyList() : ImmutableList.copyOf(callsReceiver);
            this.hasFieldAssignment = hasFieldAssignment;
            this.hasFieldRead = hasFieldRead;
            this.isAssignedToField = isAssignedToField;
            this.isReturned = isReturned;
            this.isUsedInMonitor = isUsedInMonitor;
        }

        static ParameterUsage copyAndShift(ParameterUsage original, int shift) {
            assert (original.index >= shift);
            return new ParameterUsage(original.index - shift, original.ifZeroTest, original.callsReceiver, original.hasFieldAssignment, original.hasFieldRead, original.isAssignedToField, original.isReturned, original.isUsedInMonitor);
        }

        public boolean notUsed() {
            return !(this.ifZeroTest != null && !this.ifZeroTest.isEmpty() || this.callsReceiver != null && !this.callsReceiver.isEmpty() || this.hasFieldAssignment || this.hasFieldRead || this.isAssignedToField || this.isReturned || this.isUsedInMonitor);
        }
    }
}

