/*
 * Decompiled with CFR 0.152.
 */
package shadow.bundletool.com.android.tools.r8.ir.optimize.classinliner;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import shadow.bundletool.com.android.tools.r8.com.google.common.collect.ImmutableSet;
import shadow.bundletool.com.android.tools.r8.com.google.common.collect.Iterables;
import shadow.bundletool.com.android.tools.r8.com.google.common.collect.Lists;
import shadow.bundletool.com.android.tools.r8.com.google.common.collect.Sets;
import shadow.bundletool.com.android.tools.r8.errors.Unreachable;
import shadow.bundletool.com.android.tools.r8.graph.AppInfoWithSubtyping;
import shadow.bundletool.com.android.tools.r8.graph.AppView;
import shadow.bundletool.com.android.tools.r8.graph.DexClass;
import shadow.bundletool.com.android.tools.r8.graph.DexEncodedField;
import shadow.bundletool.com.android.tools.r8.graph.DexEncodedMethod;
import shadow.bundletool.com.android.tools.r8.graph.DexField;
import shadow.bundletool.com.android.tools.r8.graph.DexItemFactory;
import shadow.bundletool.com.android.tools.r8.graph.DexMethod;
import shadow.bundletool.com.android.tools.r8.graph.DexProgramClass;
import shadow.bundletool.com.android.tools.r8.graph.DexType;
import shadow.bundletool.com.android.tools.r8.graph.ResolutionResult;
import shadow.bundletool.com.android.tools.r8.ir.analysis.ClassInitializationAnalysis;
import shadow.bundletool.com.android.tools.r8.ir.analysis.type.ClassTypeLatticeElement;
import shadow.bundletool.com.android.tools.r8.ir.analysis.type.TypeAnalysis;
import shadow.bundletool.com.android.tools.r8.ir.code.Assume;
import shadow.bundletool.com.android.tools.r8.ir.code.BasicBlock;
import shadow.bundletool.com.android.tools.r8.ir.code.ConstNumber;
import shadow.bundletool.com.android.tools.r8.ir.code.IRCode;
import shadow.bundletool.com.android.tools.r8.ir.code.If;
import shadow.bundletool.com.android.tools.r8.ir.code.InstanceGet;
import shadow.bundletool.com.android.tools.r8.ir.code.InstancePut;
import shadow.bundletool.com.android.tools.r8.ir.code.Instruction;
import shadow.bundletool.com.android.tools.r8.ir.code.InstructionOrPhi;
import shadow.bundletool.com.android.tools.r8.ir.code.Invoke;
import shadow.bundletool.com.android.tools.r8.ir.code.InvokeDirect;
import shadow.bundletool.com.android.tools.r8.ir.code.InvokeMethod;
import shadow.bundletool.com.android.tools.r8.ir.code.InvokeMethodWithReceiver;
import shadow.bundletool.com.android.tools.r8.ir.code.StaticGet;
import shadow.bundletool.com.android.tools.r8.ir.code.Value;
import shadow.bundletool.com.android.tools.r8.ir.desugar.LambdaRewriter;
import shadow.bundletool.com.android.tools.r8.ir.optimize.Inliner;
import shadow.bundletool.com.android.tools.r8.ir.optimize.InliningOracle;
import shadow.bundletool.com.android.tools.r8.ir.optimize.classinliner.ClassInliner;
import shadow.bundletool.com.android.tools.r8.ir.optimize.classinliner.ClassInlinerEligibilityInfo;
import shadow.bundletool.com.android.tools.r8.ir.optimize.classinliner.ClassInlinerReceiverSet;
import shadow.bundletool.com.android.tools.r8.ir.optimize.classinliner.FieldValueHelper;
import shadow.bundletool.com.android.tools.r8.ir.optimize.info.FieldOptimizationInfo;
import shadow.bundletool.com.android.tools.r8.ir.optimize.info.MethodOptimizationInfo;
import shadow.bundletool.com.android.tools.r8.ir.optimize.info.ParameterUsagesInfo;
import shadow.bundletool.com.android.tools.r8.ir.optimize.info.initializer.InstanceInitializerInfo;
import shadow.bundletool.com.android.tools.r8.ir.optimize.inliner.InliningIRProvider;
import shadow.bundletool.com.android.tools.r8.ir.optimize.inliner.NopWhyAreYouNotInliningReporter;
import shadow.bundletool.com.android.tools.r8.ir.optimize.inliner.WhyAreYouNotInliningReporter;
import shadow.bundletool.com.android.tools.r8.kotlin.KotlinInfo;
import shadow.bundletool.com.android.tools.r8.shaking.AppInfoWithLiveness;
import shadow.bundletool.com.android.tools.r8.utils.Pair;
import shadow.bundletool.com.android.tools.r8.utils.StringUtils;

final class InlineCandidateProcessor {
    private static final ImmutableSet<If.Type> ALLOWED_ZERO_TEST_TYPES = ImmutableSet.of(If.Type.EQ, If.Type.NE);
    private final AppView<AppInfoWithLiveness> appView;
    private final LambdaRewriter lambdaRewriter;
    private final Inliner inliner;
    private final Function<DexClass, ClassInliner.EligibilityStatus> isClassEligible;
    private final Predicate<DexEncodedMethod> isProcessedConcurrently;
    private final DexEncodedMethod method;
    private final Instruction root;
    private Value eligibleInstance;
    private DexType eligibleClass;
    private DexProgramClass eligibleClassDefinition;
    private boolean isDesugaredLambda;
    private final Map<InvokeMethodWithReceiver, Inliner.InliningInfo> methodCallsOnInstance = new IdentityHashMap<InvokeMethodWithReceiver, Inliner.InliningInfo>();
    private final Map<InvokeMethod, Inliner.InliningInfo> extraMethodCalls = new IdentityHashMap<InvokeMethod, Inliner.InliningInfo>();
    private final List<Pair<InvokeMethod, Integer>> unusedArguments = new ArrayList<Pair<InvokeMethod, Integer>>();
    private final Map<InvokeMethod, DexEncodedMethod> directInlinees = new IdentityHashMap<InvokeMethod, DexEncodedMethod>();
    private final List<DexEncodedMethod> indirectInlinees = new ArrayList<DexEncodedMethod>();
    private final ClassInlinerReceiverSet receivers;

    InlineCandidateProcessor(AppView<AppInfoWithLiveness> appView, LambdaRewriter lambdaRewriter, Inliner inliner, Function<DexClass, ClassInliner.EligibilityStatus> isClassEligible, Predicate<DexEncodedMethod> isProcessedConcurrently, DexEncodedMethod method, Instruction root) {
        this.appView = appView;
        this.lambdaRewriter = lambdaRewriter;
        this.inliner = inliner;
        this.isClassEligible = isClassEligible;
        this.method = method;
        this.root = root;
        this.isProcessedConcurrently = isProcessedConcurrently;
        this.receivers = new ClassInlinerReceiverSet(root.outValue());
    }

    DexProgramClass getEligibleClass() {
        return this.eligibleClassDefinition;
    }

    Map<InvokeMethod, DexEncodedMethod> getDirectInlinees() {
        return this.directInlinees;
    }

    List<DexEncodedMethod> getIndirectInlinees() {
        return this.indirectInlinees;
    }

    ClassInlinerReceiverSet getReceivers() {
        return this.receivers;
    }

    ClassInliner.EligibilityStatus isInstanceEligible() {
        this.eligibleInstance = this.root.outValue();
        if (this.eligibleInstance == null) {
            return ClassInliner.EligibilityStatus.UNUSED_INSTANCE;
        }
        if (this.root.isNewInstance()) {
            this.eligibleClass = this.root.asNewInstance().clazz;
        } else {
            assert (this.root.isStaticGet());
            StaticGet staticGet = this.root.asStaticGet();
            if (staticGet.instructionMayHaveSideEffects(this.appView, this.method.method.holder)) {
                return ClassInliner.EligibilityStatus.RETRIEVAL_MAY_HAVE_SIDE_EFFECTS;
            }
            DexEncodedField field = this.appView.appInfo().resolveField(staticGet.getField());
            FieldOptimizationInfo optimizationInfo = field.getOptimizationInfo();
            ClassTypeLatticeElement dynamicLowerBoundType = optimizationInfo.getDynamicLowerBoundType();
            if (dynamicLowerBoundType == null || !dynamicLowerBoundType.equals(optimizationInfo.getDynamicUpperBoundType())) {
                return ClassInliner.EligibilityStatus.NOT_A_SINGLETON_FIELD;
            }
            this.eligibleClass = dynamicLowerBoundType.getClassType();
        }
        if (!this.eligibleClass.isClassType()) {
            return ClassInliner.EligibilityStatus.NON_CLASS_TYPE;
        }
        if (this.lambdaRewriter != null) {
            this.eligibleClassDefinition = this.lambdaRewriter.getLambdaClass(this.eligibleClass);
            boolean bl = this.isDesugaredLambda = this.eligibleClassDefinition != null;
        }
        if (this.eligibleClassDefinition == null) {
            this.eligibleClassDefinition = DexProgramClass.asProgramClassOrNull(this.appView.definitionFor(this.eligibleClass));
        }
        if (this.eligibleClassDefinition != null) {
            return ClassInliner.EligibilityStatus.ELIGIBLE;
        }
        return ClassInliner.EligibilityStatus.UNKNOWN_TYPE;
    }

    ClassInliner.EligibilityStatus isClassAndUsageEligible() {
        ClassInliner.EligibilityStatus status = this.isClassEligible.apply(this.eligibleClassDefinition);
        if (status != ClassInliner.EligibilityStatus.ELIGIBLE) {
            return status;
        }
        if (this.root.isNewInstance()) {
            if (this.eligibleClassDefinition.classInitializationMayHaveSideEffects(this.appView, type -> this.appView.isSubtype(this.method.method.holder, (DexType)type).isTrue())) {
                return ClassInliner.EligibilityStatus.HAS_CLINIT;
            }
            return ClassInliner.EligibilityStatus.ELIGIBLE;
        }
        assert (this.root.isStaticGet());
        if (this.isDesugaredLambda) {
            return ClassInliner.EligibilityStatus.ELIGIBLE;
        }
        if (!this.eligibleClassDefinition.instanceFields().isEmpty()) {
            return ClassInliner.EligibilityStatus.HAS_INSTANCE_FIELDS;
        }
        return ClassInliner.EligibilityStatus.ELIGIBLE;
    }

    InstructionOrPhi areInstanceUsersEligible(Supplier<InliningOracle> defaultOracle) {
        if (this.eligibleInstance.hasPhiUsers()) {
            return this.eligibleInstance.firstPhiUser();
        }
        Set<Instruction> currentUsers = this.eligibleInstance.uniqueUsers();
        while (!currentUsers.isEmpty()) {
            Set<Instruction> indirectUsers = Sets.newIdentityHashSet();
            for (Instruction user : currentUsers) {
                if (user.isAssume()) {
                    Value alias = user.outValue();
                    if (this.receivers.isReceiverAlias(alias)) continue;
                    if (alias.hasPhiUsers()) {
                        return alias.firstPhiUser();
                    }
                    if (!this.receivers.addReceiverAlias(alias, AliasKind.DEFINITE)) {
                        return user;
                    }
                    indirectUsers.addAll(alias.uniqueUsers());
                    continue;
                }
                if (user.isInstanceGet() || user.isInstancePut() && this.receivers.addIllegalReceiverAlias(user.asInstancePut().value())) {
                    DexEncodedField field = this.appView.appInfo().resolveField(user.asFieldInstruction().getField());
                    if (field != null && !field.isStatic()) continue;
                    return user;
                }
                if (user.isInvokeMethod()) {
                    Inliner.InliningInfo inliningInfo;
                    InvokeMethodWithReceiver invoke;
                    InvokeMethod invokeMethod = user.asInvokeMethod();
                    DexEncodedMethod singleTarget = invokeMethod.lookupSingleTarget(this.appView, this.method.method.holder);
                    if (!this.isEligibleSingleTarget(singleTarget)) {
                        return user;
                    }
                    if (user.isInvokeDirect()) {
                        invoke = user.asInvokeDirect();
                        if (this.appView.dexItemFactory().isConstructor(invoke.getInvokedMethod())) {
                            Inliner.InliningInfo inliningInfo2;
                            boolean isCorrespondingConstructorCall;
                            boolean bl = isCorrespondingConstructorCall = this.root.isNewInstance() && !invoke.inValues().isEmpty() && this.root.outValue() == invoke.getReceiver();
                            if (isCorrespondingConstructorCall && (inliningInfo2 = this.isEligibleConstructorCall((InvokeDirect)invoke, singleTarget)) != null) {
                                this.methodCallsOnInstance.put(invoke, inliningInfo2);
                                continue;
                            }
                            assert (!this.isExtraMethodCall(invoke));
                            return user;
                        }
                    }
                    if ((user.isInvokeVirtual() || user.isInvokeInterface()) && (inliningInfo = this.isEligibleDirectVirtualMethodCall(invoke = user.asInvokeMethodWithReceiver(), singleTarget, indirectUsers, defaultOracle)) != null) {
                        this.methodCallsOnInstance.put(invoke, inliningInfo);
                        continue;
                    }
                    if (this.isExtraMethodCall(invokeMethod)) {
                        assert (!invokeMethod.isInvokeSuper());
                        assert (!invokeMethod.isInvokePolymorphic());
                        if (this.isExtraMethodCallEligible(invokeMethod, singleTarget, defaultOracle)) continue;
                    }
                    return user;
                }
                if (user.isIf()) {
                    If ifInsn = user.asIf();
                    If.Type type = ifInsn.getType();
                    if (ifInsn.isZeroTest() && (type == If.Type.EQ || type == If.Type.NE)) continue;
                }
                return user;
            }
            currentUsers = indirectUsers;
        }
        return null;
    }

    boolean processInlining(IRCode code, Supplier<InliningOracle> defaultOracle, InliningIRProvider inliningIRProvider) throws IllegalClassInlinerStateException {
        assert (this.eligibleInstance == this.eligibleInstance.getAliasedValue());
        this.replaceUsagesAsUnusedArgument(code);
        boolean anyInlinedMethods = this.forceInlineExtraMethodInvocations(code, inliningIRProvider);
        if (anyInlinedMethods) {
            this.methodCallsOnInstance.clear();
            this.extraMethodCalls.clear();
            this.unusedArguments.clear();
            this.receivers.reset();
            InstructionOrPhi ineligibleUser = this.areInstanceUsersEligible(defaultOracle);
            if (ineligibleUser != null) {
                throw new IllegalClassInlinerStateException();
            }
            assert (this.extraMethodCalls.isEmpty()) : "Remaining extra method calls: " + StringUtils.join(this.extraMethodCalls.entrySet(), ", ");
            assert (this.unusedArguments.isEmpty()) : "Remaining unused arg: " + StringUtils.join(this.unusedArguments, ", ");
        }
        anyInlinedMethods |= this.forceInlineDirectMethodInvocations(code, inliningIRProvider);
        this.removeAssumeInstructionsLinkedToEligibleInstance();
        this.removeMiscUsages(code);
        this.removeFieldReads(code);
        this.removeFieldWrites();
        this.removeInstruction(this.root);
        return anyInlinedMethods;
    }

    private void replaceUsagesAsUnusedArgument(IRCode code) {
        for (Pair<InvokeMethod, Integer> unusedArgument : this.unusedArguments) {
            InvokeMethod invoke = unusedArgument.getFirst();
            BasicBlock block = invoke.getBlock();
            ConstNumber nullValue = code.createConstNull();
            nullValue.setPosition(invoke.getPosition());
            block.listIterator(code, invoke).add(nullValue);
            assert (nullValue.getBlock() == block);
            int argIndex = unusedArgument.getSecond();
            invoke.replaceValue(argIndex, nullValue.outValue());
        }
        this.unusedArguments.clear();
    }

    private boolean forceInlineExtraMethodInvocations(IRCode code, InliningIRProvider inliningIRProvider) {
        if (this.extraMethodCalls.isEmpty()) {
            return false;
        }
        this.inliner.performForcedInlining(this.method, code, this.extraMethodCalls, inliningIRProvider);
        return true;
    }

    private boolean forceInlineDirectMethodInvocations(IRCode code, InliningIRProvider inliningIRProvider) throws IllegalClassInlinerStateException {
        if (this.methodCallsOnInstance.isEmpty()) {
            return false;
        }
        assert (this.methodCallsOnInstance.keySet().stream().map(InvokeMethodWithReceiver::getReceiver).allMatch(this.receivers::isReceiverAlias));
        this.inliner.performForcedInlining(this.method, code, this.methodCallsOnInstance, inliningIRProvider);
        if (this.root.isNewInstance()) {
            do {
                this.methodCallsOnInstance.clear();
                for (Instruction instruction : this.eligibleInstance.uniqueUsers()) {
                    DexMethod invokedMethod;
                    InvokeDirect invoke;
                    Value receiver;
                    if (!instruction.isInvokeDirect() || (receiver = (invoke = instruction.asInvokeDirect()).getReceiver().getAliasedValue()) != this.eligibleInstance || (invokedMethod = invoke.getInvokedMethod()) == this.appView.dexItemFactory().objectMethods.constructor) continue;
                    if (!this.appView.dexItemFactory().isConstructor(invokedMethod)) {
                        throw new IllegalClassInlinerStateException();
                    }
                    DexEncodedMethod singleTarget = this.appView.definitionFor(invokedMethod);
                    if (singleTarget == null || !singleTarget.isInliningCandidate(this.method, Inliner.Reason.SIMPLE, (AppInfoWithSubtyping)this.appView.appInfo(), (WhyAreYouNotInliningReporter)NopWhyAreYouNotInliningReporter.getInstance())) {
                        throw new IllegalClassInlinerStateException();
                    }
                    this.methodCallsOnInstance.put(invoke, new Inliner.InliningInfo(singleTarget, this.root.asNewInstance().clazz));
                    break;
                }
                if (this.methodCallsOnInstance.isEmpty()) continue;
                this.inliner.performForcedInlining(this.method, code, this.methodCallsOnInstance, inliningIRProvider);
            } while (!this.methodCallsOnInstance.isEmpty());
        }
        return true;
    }

    private void removeAssumeInstructionsLinkedToEligibleInstance() {
        for (Instruction user : this.eligibleInstance.aliasedUsers()) {
            if (!user.isAssume()) continue;
            Assume<?> assumeInstruction = user.asAssume();
            Value src = assumeInstruction.src();
            Value dest = assumeInstruction.outValue();
            assert (this.receivers.isReceiverAlias(dest));
            assert (!dest.hasPhiUsers());
            dest.replaceUsers(src);
            this.removeInstruction(user);
        }
        assert (this.eligibleInstance.aliasedUsers().stream().noneMatch(Instruction::isAssume));
    }

    private void removeMiscUsages(IRCode code) {
        boolean needToRemoveUnreachableBlocks = false;
        for (Instruction user : this.eligibleInstance.uniqueUsers()) {
            if (user.isInvokeDirect()) {
                InvokeDirect invoke = user.asInvokeDirect();
                if (this.root.isNewInstance() && invoke.getInvokedMethod() == this.appView.dexItemFactory().objectMethods.constructor) {
                    this.removeInstruction(invoke);
                    continue;
                }
            }
            if (user.isIf()) {
                BasicBlock blockToRemove;
                If ifInsn = user.asIf();
                assert (ifInsn.isZeroTest()) : "Unexpected usage in non-zero-test IF instruction: " + user;
                BasicBlock block = user.getBlock();
                If.Type type = ifInsn.getType();
                assert (type == If.Type.EQ || type == If.Type.NE) : "Unexpected type in zero-test IF instruction: " + user;
                BasicBlock newBlock = type == If.Type.EQ ? ifInsn.fallthroughBlock() : ifInsn.getTrueTarget();
                BasicBlock basicBlock = blockToRemove = type == If.Type.EQ ? ifInsn.getTrueTarget() : ifInsn.fallthroughBlock();
                assert (newBlock != blockToRemove);
                block.replaceSuccessor(blockToRemove, newBlock);
                blockToRemove.removePredecessor(block, null);
                assert (block.exit().isGoto());
                assert (block.exit().asGoto().getTarget() == newBlock);
                needToRemoveUnreachableBlocks = true;
                continue;
            }
            if (user.isInstanceGet() || user.isInstancePut()) continue;
            if (user.isMonitor()) {
                this.removeInstruction(user);
                continue;
            }
            throw new Unreachable("Unexpected usage left in method `" + this.method.method.toSourceString() + "` after inlining: " + user);
        }
        if (needToRemoveUnreachableBlocks) {
            code.removeUnreachableBlocks();
        }
    }

    private void removeFieldReads(IRCode code) {
        TreeSet<InstanceGet> uniqueInstanceGetUsersWithDeterministicOrder = new TreeSet<InstanceGet>(Comparator.comparingInt(x -> x.outValue().getNumber()));
        for (Instruction user : this.eligibleInstance.uniqueUsers()) {
            if (user.isInstanceGet()) {
                if (user.outValue().hasAnyUsers()) {
                    uniqueInstanceGetUsersWithDeterministicOrder.add(user.asInstanceGet());
                    continue;
                }
                this.removeInstruction(user);
                continue;
            }
            if (user.isInstancePut()) continue;
            throw new Unreachable("Unexpected usage left in method `" + this.method.method.toSourceString() + "` after inlining: " + user);
        }
        IdentityHashMap<DexField, FieldValueHelper> fieldHelpers = new IdentityHashMap<DexField, FieldValueHelper>();
        for (InstanceGet user : uniqueInstanceGetUsersWithDeterministicOrder) {
            this.replaceFieldRead(code, user, fieldHelpers);
        }
    }

    private void replaceFieldRead(IRCode code, InstanceGet fieldRead, Map<DexField, FieldValueHelper> fieldHelpers) {
        Value value = fieldRead.outValue();
        if (value != null) {
            FieldValueHelper helper = fieldHelpers.computeIfAbsent(fieldRead.getField(), field -> new FieldValueHelper((DexField)field, code, this.root, this.appView));
            Value newValue = helper.getValueForFieldRead(fieldRead.getBlock(), fieldRead);
            value.replaceUsers(newValue);
            for (FieldValueHelper fieldValueHelper : fieldHelpers.values()) {
                fieldValueHelper.replaceValue(value, newValue);
            }
            assert (!value.hasAnyUsers());
            new TypeAnalysis(this.appView).narrowing(Iterables.concat(ImmutableSet.of(newValue), newValue.affectedValues()));
        }
        this.removeInstruction(fieldRead);
    }

    private void removeFieldWrites() {
        for (Instruction user : this.eligibleInstance.uniqueUsers()) {
            if (!user.isInstancePut()) {
                throw new Unreachable("Unexpected usage left in method `" + this.method.method.toSourceString() + "` after field reads removed: " + user);
            }
            InstancePut instancePut = user.asInstancePut();
            DexEncodedField field = this.appView.appInfo().resolveFieldOn(this.eligibleClassDefinition, instancePut.getField());
            if (field == null) {
                throw new Unreachable("Unexpected field write left in method `" + this.method.method.toSourceString() + "` after field reads removed: " + user);
            }
            this.removeInstruction(user);
        }
    }

    private Inliner.InliningInfo isEligibleConstructorCall(InvokeDirect invoke, DexEncodedMethod singleTarget) {
        assert (this.appView.dexItemFactory().isConstructor(invoke.getInvokedMethod()));
        assert (this.isEligibleSingleTarget(singleTarget));
        if (!this.receivers.isDefiniteReceiverAlias(invoke.getReceiver())) {
            return null;
        }
        List<Value> inValues = invoke.inValues();
        for (int i = 1; i < inValues.size(); ++i) {
            if (this.receivers.addIllegalReceiverAlias(inValues.get(i))) continue;
            return null;
        }
        DexMethod init = invoke.getInvokedMethod();
        if (init.holder != this.eligibleClass) {
            return null;
        }
        InstanceInitializerInfo instanceInitializerInfo = singleTarget.getOptimizationInfo().getInstanceInitializerInfo();
        if (instanceInitializerInfo.receiverMayEscapeOutsideConstructorChain()) {
            return null;
        }
        if (this.isDesugaredLambda) {
            this.markSizeForInlining(invoke, singleTarget);
            return new Inliner.InliningInfo(singleTarget, this.eligibleClass);
        }
        DexItemFactory dexItemFactory = this.appView.dexItemFactory();
        DexMethod parent = instanceInitializerInfo.getParent();
        while (parent != dexItemFactory.objectMethods.constructor) {
            if (parent == null) {
                return null;
            }
            DexEncodedMethod encodedParent = this.appView.definitionFor(parent);
            if (encodedParent == null) {
                return null;
            }
            if (!encodedParent.isInliningCandidate(this.method, Inliner.Reason.SIMPLE, (AppInfoWithSubtyping)this.appView.appInfo(), (WhyAreYouNotInliningReporter)NopWhyAreYouNotInliningReporter.getInstance())) {
                return null;
            }
            parent = encodedParent.getOptimizationInfo().getInstanceInitializerInfo().getParent();
        }
        return new Inliner.InliningInfo(singleTarget, this.eligibleClass);
    }

    private boolean isEligibleInvokeWithAllUsersAsReceivers(ClassInlinerEligibilityInfo eligibility, InvokeMethodWithReceiver invoke, Set<Instruction> indirectUsers) {
        AliasKind kind;
        if (eligibility.returnsReceiver.isFalse()) {
            return true;
        }
        Value outValue = invoke.outValue();
        if (outValue == null || !outValue.hasAnyUsers()) {
            return true;
        }
        if (outValue.hasPhiUsers() || outValue.hasDebugUsers()) {
            return false;
        }
        AliasKind aliasKind = kind = eligibility.returnsReceiver.isTrue() ? AliasKind.DEFINITE : AliasKind.MAYBE;
        if (!this.receivers.addReceiverAlias(outValue, kind)) {
            return false;
        }
        Set<Instruction> currentUsers = outValue.uniqueUsers();
        while (!currentUsers.isEmpty()) {
            Set<Instruction> indirectOutValueUsers = Sets.newIdentityHashSet();
            for (Instruction instruction : currentUsers) {
                if (instruction.isAssume()) {
                    Value outValueAlias = instruction.outValue();
                    if (outValueAlias.hasPhiUsers() || outValueAlias.hasDebugUsers()) {
                        return false;
                    }
                    if (!this.receivers.addReceiverAlias(outValueAlias, kind)) {
                        return false;
                    }
                    indirectOutValueUsers.addAll(outValueAlias.uniqueUsers());
                    continue;
                }
                if (instruction.isInvokeMethodWithReceiver()) {
                    InvokeMethodWithReceiver user = instruction.asInvokeMethodWithReceiver();
                    if (user.getReceiver().getAliasedValue() != outValue) {
                        return false;
                    }
                    for (int i = 1; i < user.inValues().size(); ++i) {
                        if (user.inValues().get(i).getAliasedValue() != outValue) continue;
                        return false;
                    }
                    indirectUsers.add(user);
                    continue;
                }
                return false;
            }
            currentUsers = indirectOutValueUsers;
        }
        return true;
    }

    private Inliner.InliningInfo isEligibleDirectVirtualMethodCall(InvokeMethodWithReceiver invoke, DexEncodedMethod singleTarget, Set<Instruction> indirectUsers, Supplier<InliningOracle> defaultOracle) {
        InliningOracle inliningOracle;
        assert (this.isEligibleSingleTarget(singleTarget));
        List<Value> inValues = invoke.inValues();
        for (int i = 1; i < inValues.size(); ++i) {
            if (this.receivers.addIllegalReceiverAlias(inValues.get(i))) continue;
            return null;
        }
        if (singleTarget.isLibraryMethodOverride().isTrue() && !(inliningOracle = defaultOracle.get()).passesInliningConstraints(invoke, singleTarget, Inliner.Reason.SIMPLE, NopWhyAreYouNotInliningReporter.getInstance())) {
            return null;
        }
        return this.isEligibleVirtualMethodCall(invoke, invoke.getInvokedMethod(), singleTarget, eligibility -> this.isEligibleInvokeWithAllUsersAsReceivers((ClassInlinerEligibilityInfo)eligibility, invoke, indirectUsers));
    }

    private Inliner.InliningInfo isEligibleIndirectVirtualMethodCall(DexMethod callee) {
        DexEncodedMethod singleTarget = this.appView.appInfo().resolveMethod(this.eligibleClassDefinition, callee).getSingleTarget();
        if (this.isEligibleSingleTarget(singleTarget)) {
            return this.isEligibleVirtualMethodCall(null, callee, singleTarget, eligibility -> eligibility.returnsReceiver.isFalse());
        }
        return null;
    }

    private Inliner.InliningInfo isEligibleVirtualMethodCall(InvokeMethodWithReceiver invoke, DexMethod callee, DexEncodedMethod singleTarget, Predicate<ClassInlinerEligibilityInfo> eligibilityAcceptanceCheck) {
        assert (this.isEligibleSingleTarget(singleTarget));
        ResolutionResult resolutionResult = this.appView.appInfo().resolveMethod(callee.holder, callee);
        if (resolutionResult.isSingleResolution() && !resolutionResult.getSingleTarget().isNonPrivateVirtualMethod()) {
            return null;
        }
        if (!singleTarget.isNonPrivateVirtualMethod()) {
            return null;
        }
        if (this.method == singleTarget) {
            return null;
        }
        MethodOptimizationInfo optimizationInfo = singleTarget.getOptimizationInfo();
        ClassInlinerEligibilityInfo eligibility = optimizationInfo.getClassInlinerEligibility();
        if (eligibility == null || !eligibility.callsReceiver.isEmpty()) {
            return null;
        }
        if (this.root.isStaticGet()) {
            ParameterUsagesInfo.ParameterUsage receiverUsage = optimizationInfo.getParameterUsages(0);
            if (receiverUsage == null || receiverUsage.hasFieldRead) {
                return null;
            }
            if (eligibility.hasMonitorOnReceiver) {
                return null;
            }
        }
        if (!eligibilityAcceptanceCheck.test(eligibility)) {
            return null;
        }
        this.markSizeForInlining(invoke, singleTarget);
        return new Inliner.InliningInfo(singleTarget, this.eligibleClass);
    }

    private boolean isExtraMethodCall(InvokeMethod invoke) {
        Value receiver;
        if (invoke.isInvokeDirect() && this.appView.dexItemFactory().isConstructor(invoke.getInvokedMethod())) {
            return false;
        }
        if (invoke.isInvokeMethodWithReceiver() && !this.receivers.addIllegalReceiverAlias(receiver = invoke.asInvokeMethodWithReceiver().getReceiver())) {
            return false;
        }
        if (invoke.isInvokeSuper()) {
            return false;
        }
        return !invoke.isInvokePolymorphic();
    }

    private boolean isExtraMethodCallEligible(InvokeMethod invoke, DexEncodedMethod singleTarget, Supplier<InliningOracle> defaultOracle) {
        assert (this.isExtraMethodCall(invoke));
        assert (this.isEligibleSingleTarget(singleTarget));
        ArrayList<Value> arguments = Lists.newArrayList(invoke.inValues());
        if (invoke.isInvokeMethodWithReceiver()) {
            InvokeMethodWithReceiver invokeMethodWithReceiver = invoke.asInvokeMethodWithReceiver();
            Value receiver = invokeMethodWithReceiver.getReceiver();
            if (!this.receivers.addIllegalReceiverAlias(receiver)) {
                return false;
            }
            if (receiver.getTypeLattice().nullability().isDefinitelyNull()) {
                return false;
            }
        }
        MethodOptimizationInfo optimizationInfo = singleTarget.getOptimizationInfo();
        if (!this.isEligibleParameterUsages(invoke, arguments, singleTarget, defaultOracle)) {
            return false;
        }
        for (int argIndex = 0; argIndex < arguments.size(); ++argIndex) {
            Value argument = ((Value)arguments.get(argIndex)).getAliasedValue();
            ParameterUsagesInfo.ParameterUsage parameterUsage = optimizationInfo.getParameterUsages(argIndex);
            if (!this.receivers.isDefiniteReceiverAlias(argument) || parameterUsage == null || !parameterUsage.notUsed()) continue;
            this.unusedArguments.add(new Pair<InvokeMethod, Integer>(invoke, argIndex));
        }
        this.extraMethodCalls.put(invoke, new Inliner.InliningInfo(singleTarget, null));
        this.markSizeForInlining(invoke, singleTarget);
        return true;
    }

    private boolean isEligibleParameterUsages(InvokeMethod invoke, List<Value> arguments, DexEncodedMethod singleTarget, Supplier<InliningOracle> defaultOracle) {
        for (int argIndex = 0; argIndex < arguments.size(); ++argIndex) {
            MethodOptimizationInfo optimizationInfo = singleTarget.getOptimizationInfo();
            ParameterUsagesInfo.ParameterUsage parameterUsage = optimizationInfo.getParameterUsages(argIndex);
            Value argument = arguments.get(argIndex);
            if (this.receivers.isReceiverAlias(argument)) {
                if (this.isEligibleParameterUsage(parameterUsage, invoke, defaultOracle)) continue;
                return false;
            }
            this.receivers.addDeferredAliasValidityCheck(argument, () -> this.isEligibleParameterUsage(parameterUsage, invoke, defaultOracle));
        }
        return true;
    }

    private boolean isEligibleParameterUsage(ParameterUsagesInfo.ParameterUsage parameterUsage, InvokeMethod invoke, Supplier<InliningOracle> defaultOracle) {
        if (parameterUsage == null) {
            return false;
        }
        if (parameterUsage.notUsed()) {
            return true;
        }
        if (parameterUsage.isAssignedToField) {
            return false;
        }
        if (parameterUsage.isReturned && invoke.outValue() != null && invoke.outValue().hasAnyUsers()) {
            return false;
        }
        if (parameterUsage.isUsedInMonitor) {
            return !this.root.isStaticGet();
        }
        if (!Sets.difference(parameterUsage.ifZeroTest, ALLOWED_ZERO_TEST_TYPES).isEmpty()) {
            return false;
        }
        for (Pair<Invoke.Type, DexMethod> call : parameterUsage.callsReceiver) {
            DexEncodedMethod singleTarget;
            Invoke.Type type = call.getFirst();
            DexMethod target = call.getSecond();
            if (type == Invoke.Type.VIRTUAL || type == Invoke.Type.INTERFACE) {
                Inliner.InliningInfo potentialInliningInfo = this.isEligibleIndirectVirtualMethodCall(target);
                if (potentialInliningInfo == null) {
                    return false;
                }
            } else if (type == Invoke.Type.DIRECT) {
                if (!this.isInstanceInitializerEligibleForClassInlining(target)) {
                    return false;
                }
            } else {
                return false;
            }
            if ((singleTarget = invoke.lookupSingleTarget(this.appView, this.method.method.holder)) == null) {
                return false;
            }
            InliningOracle oracle = defaultOracle.get();
            Inliner.InlineAction inlineAction = oracle.computeInlining(invoke, singleTarget, ClassInitializationAnalysis.trivial(), NopWhyAreYouNotInliningReporter.getInstance());
            if (inlineAction != null) continue;
            return false;
        }
        return true;
    }

    private boolean isInstanceInitializerEligibleForClassInlining(DexMethod method) {
        if (method == this.appView.dexItemFactory().objectMethods.constructor) {
            return true;
        }
        DexEncodedMethod encodedMethod = this.appView.definitionFor(method);
        if (encodedMethod == null) {
            return false;
        }
        InstanceInitializerInfo initializerInfo = encodedMethod.getOptimizationInfo().getInstanceInitializerInfo();
        return initializerInfo.receiverNeverEscapesOutsideConstructorChain();
    }

    private boolean exemptFromInstructionLimit(DexEncodedMethod inlinee) {
        DexType inlineeHolder = inlinee.method.holder;
        if (this.isDesugaredLambda && inlineeHolder == this.eligibleClass) {
            return true;
        }
        if (this.appView.appInfo().isPinned(inlineeHolder)) {
            return false;
        }
        DexClass inlineeClass = this.appView.definitionFor(inlineeHolder);
        assert (inlineeClass != null);
        KotlinInfo kotlinInfo = inlineeClass.getKotlinInfo();
        return kotlinInfo != null && kotlinInfo.isSyntheticClass() && kotlinInfo.asSyntheticClass().isLambda();
    }

    private void markSizeForInlining(InvokeMethod invoke, DexEncodedMethod inlinee) {
        assert (!this.isProcessedConcurrently.test(inlinee));
        if (!this.exemptFromInstructionLimit(inlinee)) {
            if (invoke != null) {
                this.directInlinees.put(invoke, inlinee);
            } else {
                this.indirectInlinees.add(inlinee);
            }
        }
    }

    private boolean isEligibleSingleTarget(DexEncodedMethod singleTarget) {
        if (singleTarget == null) {
            return false;
        }
        if (!singleTarget.isProgramMethod(this.appView)) {
            return false;
        }
        if (this.isProcessedConcurrently.test(singleTarget)) {
            return false;
        }
        if (this.isDesugaredLambda && !singleTarget.accessFlags.isBridge()) {
            return true;
        }
        return singleTarget.isInliningCandidate(this.method, Inliner.Reason.SIMPLE, (AppInfoWithSubtyping)this.appView.appInfo(), (WhyAreYouNotInliningReporter)NopWhyAreYouNotInliningReporter.getInstance());
    }

    private void removeInstruction(Instruction instruction) {
        instruction.inValues().forEach(v -> v.removeUser(instruction));
        instruction.getBlock().removeInstruction(instruction);
    }

    static class IllegalClassInlinerStateException
    extends Exception {
        IllegalClassInlinerStateException() {
        }
    }

    static enum AliasKind {
        DEFINITE,
        MAYBE;

    }
}

