/*
 * Decompiled with CFR 0.152.
 */
package shadow.bundletool.com.android.tools.r8.ir.optimize;

import java.util.Set;
import shadow.bundletool.com.android.tools.r8.com.google.common.collect.Sets;
import shadow.bundletool.com.android.tools.r8.graph.AppView;
import shadow.bundletool.com.android.tools.r8.graph.DexClass;
import shadow.bundletool.com.android.tools.r8.graph.DexItemFactory;
import shadow.bundletool.com.android.tools.r8.graph.DexMethod;
import shadow.bundletool.com.android.tools.r8.graph.DexProgramClass;
import shadow.bundletool.com.android.tools.r8.graph.DexType;
import shadow.bundletool.com.android.tools.r8.ir.analysis.ClassInitializationAnalysis;
import shadow.bundletool.com.android.tools.r8.ir.analysis.type.ClassTypeLatticeElement;
import shadow.bundletool.com.android.tools.r8.ir.analysis.type.Nullability;
import shadow.bundletool.com.android.tools.r8.ir.analysis.type.TypeAnalysis;
import shadow.bundletool.com.android.tools.r8.ir.analysis.type.TypeLatticeElement;
import shadow.bundletool.com.android.tools.r8.ir.code.BasicBlock;
import shadow.bundletool.com.android.tools.r8.ir.code.ConstClass;
import shadow.bundletool.com.android.tools.r8.ir.code.IRCode;
import shadow.bundletool.com.android.tools.r8.ir.code.Instruction;
import shadow.bundletool.com.android.tools.r8.ir.code.InstructionListIterator;
import shadow.bundletool.com.android.tools.r8.ir.code.InvokeStatic;
import shadow.bundletool.com.android.tools.r8.ir.code.InvokeVirtual;
import shadow.bundletool.com.android.tools.r8.ir.code.Value;
import shadow.bundletool.com.android.tools.r8.ir.optimize.Inliner;
import shadow.bundletool.com.android.tools.r8.shaking.AppInfoWithLiveness;
import shadow.bundletool.com.android.tools.r8.utils.DescriptorUtils;

public class ReflectionOptimizer {
    public static void rewriteGetClassOrForNameToConstClass(AppView<AppInfoWithLiveness> appView, IRCode code) {
        Set<Value> affectedValues = Sets.newIdentityHashSet();
        DexType context = code.method.method.holder;
        ClassInitializationAnalysis classInitializationAnalysis = new ClassInitializationAnalysis(appView, code);
        for (BasicBlock block : code.blocks) {
            if (block.hasCatchHandlers()) continue;
            InstructionListIterator it = block.listIterator(code);
            while (it.hasNext()) {
                Instruction current = (Instruction)it.next();
                if (!current.hasOutValue() || !current.outValue().isUsed()) continue;
                DexType type = null;
                if (current.isInvokeVirtual()) {
                    type = ReflectionOptimizer.getTypeForGetClass(appView, context, current.asInvokeVirtual());
                } else if (current.isInvokeStatic()) {
                    type = ReflectionOptimizer.getTypeForClassForName(appView, classInitializationAnalysis, context, current.asInvokeStatic());
                }
                if (type == null) continue;
                affectedValues.addAll(current.outValue().affectedValues());
                ClassTypeLatticeElement typeLattice = TypeLatticeElement.classClassType(appView, Nullability.definitelyNotNull());
                Value value = code.createValue(typeLattice, current.getLocalInfo());
                ConstClass constClass = new ConstClass(value, type);
                it.replaceCurrentInstruction(constClass);
            }
        }
        classInitializationAnalysis.finish();
        if (!affectedValues.isEmpty()) {
            new TypeAnalysis(appView).narrowing(affectedValues);
        }
        assert (code.isConsistentSSA());
    }

    private static DexType getTypeForGetClass(AppView<AppInfoWithLiveness> appView, DexType context, InvokeVirtual invoke) {
        DexItemFactory dexItemFactory = appView.dexItemFactory();
        DexMethod invokedMethod = invoke.getInvokedMethod();
        if (invokedMethod != dexItemFactory.objectMethods.getClass) {
            return null;
        }
        Value in = invoke.getReceiver();
        if (in.hasLocalInfo()) {
            return null;
        }
        TypeLatticeElement inType = in.getTypeLattice();
        if (!inType.isClassType() && !inType.isArrayType() || inType.isNullable()) {
            return null;
        }
        DexType type = inType.isClassType() ? inType.asClassTypeLatticeElement().getClassType() : inType.asArrayTypeLatticeElement().getArrayType(dexItemFactory);
        DexType baseType = type.toBaseType(dexItemFactory);
        if (!baseType.isClassType()) {
            return null;
        }
        DexProgramClass clazz = DexProgramClass.asProgramClassOrNull(appView.definitionFor(baseType));
        if (clazz == null) {
            return null;
        }
        if (appView.appInfo().hasSubtypes(baseType) && appView.appInfo().isInstantiatedIndirectly(clazz) && (in.isPhi() || !in.definition.isCreatingInstanceOrArray())) {
            return null;
        }
        Inliner.ConstraintWithTarget constraints = Inliner.ConstraintWithTarget.classIsVisible(context, baseType, appView);
        if (constraints == Inliner.ConstraintWithTarget.NEVER) {
            return null;
        }
        return type;
    }

    private static DexType getTypeForClassForName(AppView<AppInfoWithLiveness> appView, ClassInitializationAnalysis classInitializationAnalysis, DexType context, InvokeStatic invoke) {
        DexItemFactory dexItemFactory = appView.dexItemFactory();
        DexMethod invokedMethod = invoke.getInvokedMethod();
        if (invokedMethod != dexItemFactory.classMethods.forName) {
            return null;
        }
        assert (invoke.inValues().size() == 1);
        Value in = invoke.inValues().get(0).getAliasedValue();
        if (in.hasLocalInfo() || in.isPhi()) {
            return null;
        }
        Value out = invoke.outValue();
        if (out != null && out.hasLocalInfo()) {
            return null;
        }
        DexType type = null;
        if (in.definition.isDexItemBasedConstString()) {
            if (in.definition.asDexItemBasedConstString().getItem().isDexType()) {
                type = in.definition.asDexItemBasedConstString().getItem().asDexType();
            }
        } else if (in.definition.isConstString()) {
            String name = in.definition.asConstString().getValue().toString();
            String descriptor = DescriptorUtils.javaTypeToDescriptorIfValidJavaType(name);
            if (descriptor == null && name.startsWith("[") && name.endsWith(";")) {
                descriptor = name.replace('.', '/');
            }
            if (descriptor == null || descriptor.indexOf(46) > 0) {
                return null;
            }
            type = dexItemFactory.createType(descriptor);
            if (!type.isReferenceType()) {
                return null;
            }
        } else {
            return null;
        }
        if (type == null) {
            return null;
        }
        DexType baseType = type.toBaseType(dexItemFactory);
        DexClass baseClazz = appView.definitionFor(baseType);
        if (baseClazz == null || !baseClazz.isResolvable(appView)) {
            return null;
        }
        if (baseClazz.isProgramClass() && appView.options().featureSplitConfiguration != null && appView.options().featureSplitConfiguration.isInFeature(baseClazz.asProgramClass())) {
            return null;
        }
        Inliner.ConstraintWithTarget constraints = Inliner.ConstraintWithTarget.classIsVisible(context, baseType, appView);
        if (constraints == Inliner.ConstraintWithTarget.NEVER) {
            return null;
        }
        if (type.isClassType() && !classInitializationAnalysis.isClassDefinitelyLoadedBeforeInstruction(type, invoke)) {
            return null;
        }
        return type;
    }
}

