/*
 * Decompiled with CFR 0.152.
 */
package shadow.bundletool.com.android.tools.r8.ir.optimize;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.Map;
import java.util.Set;
import shadow.bundletool.com.android.tools.r8.com.google.common.collect.Sets;
import shadow.bundletool.com.android.tools.r8.errors.Unreachable;
import shadow.bundletool.com.android.tools.r8.graph.AppInfo;
import shadow.bundletool.com.android.tools.r8.graph.AppView;
import shadow.bundletool.com.android.tools.r8.graph.DexEncodedField;
import shadow.bundletool.com.android.tools.r8.graph.DexEncodedMethod;
import shadow.bundletool.com.android.tools.r8.graph.DexField;
import shadow.bundletool.com.android.tools.r8.graph.DexType;
import shadow.bundletool.com.android.tools.r8.ir.analysis.type.TypeAnalysis;
import shadow.bundletool.com.android.tools.r8.ir.code.BasicBlock;
import shadow.bundletool.com.android.tools.r8.ir.code.DominatorTree;
import shadow.bundletool.com.android.tools.r8.ir.code.FieldInstruction;
import shadow.bundletool.com.android.tools.r8.ir.code.IRCode;
import shadow.bundletool.com.android.tools.r8.ir.code.InstanceGet;
import shadow.bundletool.com.android.tools.r8.ir.code.InstancePut;
import shadow.bundletool.com.android.tools.r8.ir.code.Instruction;
import shadow.bundletool.com.android.tools.r8.ir.code.InstructionListIterator;
import shadow.bundletool.com.android.tools.r8.ir.code.NewInstance;
import shadow.bundletool.com.android.tools.r8.ir.code.Phi;
import shadow.bundletool.com.android.tools.r8.ir.code.StaticGet;
import shadow.bundletool.com.android.tools.r8.ir.code.StaticPut;
import shadow.bundletool.com.android.tools.r8.ir.code.Value;

public class RedundantFieldLoadElimination {
    private final AppView<?> appView;
    private final DexEncodedMethod method;
    private final IRCode code;
    private final DominatorTree dominatorTree;
    private final Set<Value> affectedValues = Sets.newIdentityHashSet();
    private final Map<BasicBlock, Map<FieldAndObject, FieldInstruction>> activeInstanceFieldsAtEntry = new IdentityHashMap<BasicBlock, Map<FieldAndObject, FieldInstruction>>();
    private final Map<BasicBlock, Map<DexField, FieldInstruction>> activeStaticFieldsAtEntry = new IdentityHashMap<BasicBlock, Map<DexField, FieldInstruction>>();
    private Map<FieldAndObject, FieldInstruction> activeInstanceFields;
    private Map<DexField, FieldInstruction> activeStaticFields;

    public RedundantFieldLoadElimination(AppView<?> appView, IRCode code) {
        this.appView = appView;
        this.method = code.method;
        this.code = code;
        this.dominatorTree = new DominatorTree(code);
    }

    public static boolean shouldRun(AppView<?> appView, IRCode code) {
        return appView.options().enableRedundantFieldLoadElimination && code.metadata().mayHaveFieldGet();
    }

    private boolean couldBeVolatile(DexField field) {
        if (!this.appView.enableWholeProgramOptimizations()) {
            if (field.holder != this.method.method.holder) {
                return true;
            }
            DexEncodedField definition = this.appView.definitionFor(field);
            return definition == null || definition.accessFlags.isVolatile();
        }
        DexEncodedField definition = ((AppInfo)this.appView.appInfo()).resolveField(field);
        return definition == null || definition.accessFlags.isVolatile();
    }

    public void run() {
        DexType context = this.method.method.holder;
        for (BasicBlock block : this.dominatorTree.getSortedBlocks()) {
            this.activeInstanceFields = this.activeInstanceFieldsAtEntry.containsKey(block) ? this.activeInstanceFieldsAtEntry.get(block) : new HashMap<FieldAndObject, FieldInstruction>();
            this.activeStaticFields = this.activeStaticFieldsAtEntry.containsKey(block) ? this.activeStaticFieldsAtEntry.get(block) : new IdentityHashMap<DexField, FieldInstruction>();
            InstructionListIterator it = block.listIterator(this.code);
            while (it.hasNext()) {
                Instruction instruction = (Instruction)it.next();
                if (instruction.isFieldInstruction()) {
                    FieldAndObject fieldAndObject;
                    Value object;
                    DexField field = instruction.asFieldInstruction().getField();
                    if (this.couldBeVolatile(field)) {
                        this.killAllActiveFields();
                        continue;
                    }
                    assert (!this.couldBeVolatile(field));
                    if (instruction.isInstanceGet()) {
                        InstanceGet instanceGet = instruction.asInstanceGet();
                        if (instanceGet.outValue().hasLocalInfo()) continue;
                        object = instanceGet.object().getAliasedValue();
                        fieldAndObject = new FieldAndObject(field, object);
                        if (this.activeInstanceFields.containsKey(fieldAndObject)) {
                            FieldInstruction active = this.activeInstanceFields.get(fieldAndObject);
                            this.eliminateRedundantRead(it, instanceGet, active);
                            continue;
                        }
                        this.activeInstanceFields.put(fieldAndObject, instanceGet);
                        continue;
                    }
                    if (instruction.isInstancePut()) {
                        InstancePut instancePut = instruction.asInstancePut();
                        this.killActiveFields(instancePut);
                        object = instancePut.object().getAliasedValue();
                        fieldAndObject = new FieldAndObject(field, object);
                        this.activeInstanceFields.put(fieldAndObject, instancePut);
                        continue;
                    }
                    if (instruction.isStaticGet()) {
                        StaticGet staticGet = instruction.asStaticGet();
                        if (staticGet.outValue().hasLocalInfo()) continue;
                        if (this.activeStaticFields.containsKey(field)) {
                            FieldInstruction active = this.activeStaticFields.get(field);
                            this.eliminateRedundantRead(it, staticGet, active);
                            continue;
                        }
                        this.killActiveFields(staticGet);
                        this.activeStaticFields.put(field, staticGet);
                        continue;
                    }
                    if (!instruction.isStaticPut()) continue;
                    StaticPut staticPut = instruction.asStaticPut();
                    this.killActiveFields(staticPut);
                    this.activeStaticFields.put(field, staticPut);
                    continue;
                }
                if (instruction.isMonitor()) {
                    if (!instruction.asMonitor().isEnter()) continue;
                    this.killAllActiveFields();
                    continue;
                }
                if (instruction.isInvokeMethod() || instruction.isInvokeCustom()) {
                    this.killAllActiveFields();
                    continue;
                }
                if (instruction.isNewInstance()) {
                    NewInstance newInstance = instruction.asNewInstance();
                    if (!newInstance.clazz.classInitializationMayHaveSideEffects(this.appView, type -> this.appView.isSubtype(context, (DexType)type).isTrue())) continue;
                    this.killAllActiveFields();
                    continue;
                }
                assert (!instruction.instructionMayTriggerMethodInvocation(this.appView, context));
                assert (instruction.isArgument() || instruction.isArrayGet() || instruction.isArrayLength() || instruction.isArrayPut() || instruction.isAssume() || instruction.isBinop() || instruction.isCheckCast() || instruction.isConstClass() || instruction.isConstMethodHandle() || instruction.isConstMethodType() || instruction.isConstNumber() || instruction.isConstString() || instruction.isDebugInstruction() || instruction.isDexItemBasedConstString() || instruction.isGoto() || instruction.isIf() || instruction.isInstanceOf() || instruction.isInvokeMultiNewArray() || instruction.isInvokeNewArray() || instruction.isMoveException() || instruction.isNewArrayEmpty() || instruction.isNewArrayFilledData() || instruction.isReturn() || instruction.isSwitch() || instruction.isThrow() || instruction.isUnop()) : "Unexpected instruction of type " + instruction.getClass().getTypeName();
            }
            this.propagateActiveFieldsFrom(block);
        }
        if (!this.affectedValues.isEmpty()) {
            new TypeAnalysis(this.appView).narrowing(this.affectedValues);
        }
        assert (this.code.isConsistentSSA());
    }

    private void propagateActiveFieldsFrom(BasicBlock block) {
        for (BasicBlock successor : block.getSuccessors()) {
            Instruction exceptionalExit;
            if (successor.getPredecessors().size() != 1) continue;
            if (block.hasCatchSuccessor(successor) && (exceptionalExit = block.exceptionalExit()) != null && exceptionalExit.isFieldInstruction()) {
                this.killActiveFieldsForExceptionalExit(exceptionalExit.asFieldInstruction());
            }
            assert (!this.activeInstanceFieldsAtEntry.containsKey(successor));
            this.activeInstanceFieldsAtEntry.put(successor, new HashMap<FieldAndObject, FieldInstruction>(this.activeInstanceFields));
            assert (!this.activeStaticFieldsAtEntry.containsKey(successor));
            this.activeStaticFieldsAtEntry.put(successor, new IdentityHashMap<DexField, FieldInstruction>(this.activeStaticFields));
        }
    }

    private void killAllActiveFields() {
        this.activeInstanceFields.clear();
        this.activeStaticFields.clear();
    }

    private void killActiveFields(FieldInstruction instruction) {
        DexField field = instruction.getField();
        if (instruction.isInstancePut()) {
            ArrayList<FieldAndObject> keysToRemove = new ArrayList<FieldAndObject>();
            for (FieldAndObject key : this.activeInstanceFields.keySet()) {
                if (key.field != field) continue;
                keysToRemove.add(key);
            }
            keysToRemove.forEach(this.activeInstanceFields::remove);
        } else if (instruction.isStaticPut()) {
            if (field.holder != this.code.method.method.holder) {
                this.activeStaticFields.clear();
            } else {
                this.activeStaticFields.remove(field);
            }
        } else if (instruction.isStaticGet()) {
            if (field.holder != this.code.method.method.holder) {
                this.activeStaticFields.clear();
            }
        } else if (instruction.isInstanceGet()) {
            throw new Unreachable();
        }
    }

    private void killActiveFieldsForExceptionalExit(FieldInstruction instruction) {
        DexField field = instruction.getField();
        if (instruction.isInstanceGet()) {
            Value object = instruction.asInstanceGet().object().getAliasedValue();
            FieldAndObject fieldAndObject = new FieldAndObject(field, object);
            this.activeInstanceFields.remove(fieldAndObject);
        } else if (instruction.isStaticGet()) {
            this.activeStaticFields.remove(field);
        }
    }

    private void eliminateRedundantRead(InstructionListIterator it, FieldInstruction redundant, FieldInstruction active) {
        this.affectedValues.addAll(redundant.value().affectedValues());
        redundant.value().replaceUsers(active.value());
        it.removeOrReplaceByDebugLocalRead();
        active.value().uniquePhiUsers().forEach(Phi::removeTrivialPhi);
    }

    private static class FieldAndObject {
        private final DexField field;
        private final Value object;

        private FieldAndObject(DexField field, Value receiver) {
            assert (receiver == receiver.getAliasedValue());
            this.field = field;
            this.object = receiver;
        }

        public int hashCode() {
            return this.field.hashCode() * 7 + this.object.hashCode();
        }

        public boolean equals(Object other) {
            if (!(other instanceof FieldAndObject)) {
                return false;
            }
            FieldAndObject o = (FieldAndObject)other;
            return o.object == this.object && o.field == this.field;
        }
    }
}

