/*
 * Decompiled with CFR 0.152.
 */
package shadow.bundletool.com.android.tools.r8.ir.optimize;

import shadow.bundletool.com.android.tools.r8.graph.AppView;
import shadow.bundletool.com.android.tools.r8.graph.DexClass;
import shadow.bundletool.com.android.tools.r8.graph.DexDefinitionSupplier;
import shadow.bundletool.com.android.tools.r8.graph.DexEncodedMethod;
import shadow.bundletool.com.android.tools.r8.graph.DexMethod;
import shadow.bundletool.com.android.tools.r8.graph.DexType;
import shadow.bundletool.com.android.tools.r8.ir.code.IRCode;
import shadow.bundletool.com.android.tools.r8.ir.code.Instruction;
import shadow.bundletool.com.android.tools.r8.ir.code.InstructionListIterator;
import shadow.bundletool.com.android.tools.r8.ir.code.InvokeDirect;
import shadow.bundletool.com.android.tools.r8.ir.code.InvokeInterface;
import shadow.bundletool.com.android.tools.r8.ir.code.InvokeMethod;
import shadow.bundletool.com.android.tools.r8.ir.code.InvokeVirtual;

public class NestUtils {
    public static boolean sameNest(DexType type1, DexType type2, DexDefinitionSupplier definitions) {
        if (type1 == type2) {
            return true;
        }
        DexClass clazz1 = definitions.definitionFor(type1);
        if (clazz1 == null) {
            return false;
        }
        if (!clazz1.isInANest()) {
            return false;
        }
        DexClass clazz2 = definitions.definitionFor(type2);
        if (clazz2 == null) {
            return false;
        }
        return clazz1.getNestHost() == clazz2.getNestHost();
    }

    public static void rewriteNestCallsForInlining(IRCode code, DexType callerHolder, AppView<?> appView) {
        InstructionListIterator iterator2 = code.instructionListIterator();
        DexClass callerHolderClass = appView.definitionFor(callerHolder);
        assert (callerHolderClass != null);
        assert (code.method.method.holder != callerHolder);
        while (iterator2.hasNext()) {
            DexEncodedMethod encodedMethod;
            DexMethod method;
            InvokeMethod invoke;
            Instruction instruction = (Instruction)iterator2.next();
            if (instruction.isInvokeDirect()) {
                invoke = instruction.asInvokeDirect();
                method = invoke.getInvokedMethod();
                encodedMethod = appView.definitionFor(method);
                if (encodedMethod == null || encodedMethod.isInstanceInitializer()) continue;
                assert (encodedMethod.isPrivateMethod());
                if (((InvokeDirect)invoke).isInterface()) {
                    iterator2.replaceCurrentInstruction(new InvokeInterface(method, invoke.outValue(), invoke.inValues()));
                    continue;
                }
                iterator2.replaceCurrentInstruction(new InvokeVirtual(method, invoke.outValue(), invoke.inValues()));
                continue;
            }
            if (!instruction.isInvokeInterface() && !instruction.isInvokeVirtual()) continue;
            invoke = instruction.asInvokeMethod();
            method = invoke.getInvokedMethod();
            if (method.holder != callerHolder || (encodedMethod = appView.definitionFor(method)) == null || !encodedMethod.isPrivateMethod()) continue;
            iterator2.replaceCurrentInstruction(new InvokeDirect(method, invoke.outValue(), invoke.inValues(), callerHolderClass.isInterface()));
        }
    }
}

