/*
 * Decompiled with CFR 0.152.
 */
package shadow.bundletool.com.android.tools.r8.ir.desugar;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.function.BiConsumer;
import shadow.bundletool.com.android.tools.r8.com.google.common.collect.Sets;
import shadow.bundletool.com.android.tools.r8.graph.AppInfo;
import shadow.bundletool.com.android.tools.r8.graph.AppView;
import shadow.bundletool.com.android.tools.r8.graph.DexApplication;
import shadow.bundletool.com.android.tools.r8.graph.DexClass;
import shadow.bundletool.com.android.tools.r8.graph.DexEncodedMethod;
import shadow.bundletool.com.android.tools.r8.graph.DexMethod;
import shadow.bundletool.com.android.tools.r8.graph.DexProgramClass;
import shadow.bundletool.com.android.tools.r8.graph.DexType;
import shadow.bundletool.com.android.tools.r8.graph.GraphLense;
import shadow.bundletool.com.android.tools.r8.ir.desugar.NestBasedAccessDesugaring;
import shadow.bundletool.com.android.tools.r8.ir.desugar.NestedPrivateMethodLense;
import shadow.bundletool.com.android.tools.r8.utils.ThreadUtils;

public class R8NestBasedAccessDesugaring
extends NestBasedAccessDesugaring {
    public R8NestBasedAccessDesugaring(AppView<?> appView) {
        super(appView);
    }

    public GraphLense run(ExecutorService executorService, DexApplication.Builder<?> appBuilder) throws ExecutionException {
        assert (!this.appView.options().canUseNestBasedAccess() || this.appView.options().testing.enableForceNestBasedAccessDesugaringForTest);
        this.computeAndProcessNestsConcurrently(executorService);
        NestedPrivateMethodLense.Builder lensBuilder = NestedPrivateMethodLense.builder();
        this.addDeferredBridgesAndMapMethods(lensBuilder);
        this.clearNestAttributes();
        this.synthesizeNestConstructor(appBuilder);
        return lensBuilder.build(this.appView, this.getNestConstructorType());
    }

    private void addDeferredBridgesAndMapMethods(NestedPrivateMethodLense.Builder lensBuilder) {
        this.addDeferredBridgesAndMapMethods(this.bridges, lensBuilder::map);
        this.addDeferredBridgesAndMapMethods(this.getFieldBridges, lensBuilder::mapGetField);
        this.addDeferredBridgesAndMapMethods(this.putFieldBridges, lensBuilder::mapPutField);
    }

    private <E> void addDeferredBridgesAndMapMethods(Map<E, DexEncodedMethod> bridges, BiConsumer<E, DexMethod> lensInserter) {
        for (Map.Entry<E, DexEncodedMethod> entry : bridges.entrySet()) {
            DexClass holder = this.definitionFor(entry.getValue().method.holder);
            assert (holder != null && holder.isProgramClass());
            holder.asProgramClass().addMethod(entry.getValue());
            lensInserter.accept(entry.getKey(), entry.getValue().method);
        }
        bridges.clear();
    }

    private void clearNestAttributes() {
        for (DexClass dexClass : ((AppInfo)this.appView.appInfo()).classes()) {
            dexClass.clearNestHost();
            dexClass.getNestMembersClassAttributes().clear();
        }
    }

    private void computeAndProcessNestsConcurrently(ExecutorService executorService) throws ExecutionException {
        Set<DexType> nestHosts = Sets.newIdentityHashSet();
        ArrayList futures = new ArrayList();
        for (DexProgramClass clazz : ((AppInfo)this.appView.appInfo()).classes()) {
            DexType hostType;
            if (!clazz.isInANest() || nestHosts.contains(hostType = clazz.getNestHost())) continue;
            nestHosts.add(hostType);
            futures.add(this.asyncProcessNest(clazz, executorService));
        }
        ThreadUtils.awaitFutures(futures);
    }

    @Override
    protected boolean shouldProcessClassInNest(DexClass clazz, List<DexType> nest) {
        return true;
    }

    @Override
    void reportMissingNestHost(DexClass clazz) {
        if (this.appView.options().ignoreMissingClasses) {
            this.appView.options().nestDesugaringWarningMissingNestHost(clazz);
        } else {
            this.appView.options().errorMissingClassMissingNestHost(clazz);
        }
    }

    @Override
    void reportIncompleteNest(List<DexType> nest) {
        if (this.appView.options().ignoreMissingClasses) {
            this.appView.options().nestDesugaringWarningIncompleteNest(nest, this.appView);
        } else {
            this.appView.options().errorMissingClassIncompleteNest(nest, this.appView);
        }
    }
}

