/*
 * Decompiled with CFR 0.152.
 */
package shadow.bundletool.com.android.tools.r8.ir.code;

import java.util.ArrayList;
import java.util.Deque;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import shadow.bundletool.com.android.tools.r8.cf.TypeVerificationHelper;
import shadow.bundletool.com.android.tools.r8.com.google.common.collect.Sets;
import shadow.bundletool.com.android.tools.r8.errors.CompilationError;
import shadow.bundletool.com.android.tools.r8.errors.InvalidDebugInfoException;
import shadow.bundletool.com.android.tools.r8.graph.AppInfoWithSubtyping;
import shadow.bundletool.com.android.tools.r8.graph.AppView;
import shadow.bundletool.com.android.tools.r8.graph.DebugLocalInfo;
import shadow.bundletool.com.android.tools.r8.graph.DexMethod;
import shadow.bundletool.com.android.tools.r8.graph.DexType;
import shadow.bundletool.com.android.tools.r8.ir.analysis.type.TypeLatticeElement;
import shadow.bundletool.com.android.tools.r8.ir.code.BasicBlock;
import shadow.bundletool.com.android.tools.r8.ir.code.InstructionOrPhi;
import shadow.bundletool.com.android.tools.r8.ir.code.Value;
import shadow.bundletool.com.android.tools.r8.ir.code.ValueTypeConstraint;
import shadow.bundletool.com.android.tools.r8.ir.conversion.IRBuilder;
import shadow.bundletool.com.android.tools.r8.ir.conversion.TypeConstraintResolver;
import shadow.bundletool.com.android.tools.r8.origin.Origin;
import shadow.bundletool.com.android.tools.r8.utils.CfgPrinter;
import shadow.bundletool.com.android.tools.r8.utils.DequeUtils;
import shadow.bundletool.com.android.tools.r8.utils.ListUtils;
import shadow.bundletool.com.android.tools.r8.utils.Reporter;
import shadow.bundletool.com.android.tools.r8.utils.SetUtils;
import shadow.bundletool.com.android.tools.r8.utils.StringUtils;

public class Phi
extends Value
implements InstructionOrPhi {
    private final BasicBlock block;
    private final List<Value> operands = new ArrayList<Value>();
    private RegisterReadType readType;
    private boolean isStackPhi;
    private List<Map<Integer, Value>> definitionUsers = new ArrayList<Map<Integer, Value>>();

    public Phi(int number, BasicBlock block, TypeLatticeElement typeLattice, DebugLocalInfo local, RegisterReadType readType) {
        super(number, typeLattice, local);
        this.block = block;
        this.readType = readType;
        block.addPhi(this);
    }

    @Override
    public boolean isPhi() {
        return true;
    }

    @Override
    public Phi asPhi() {
        return this;
    }

    @Override
    public BasicBlock getBlock() {
        return this.block;
    }

    @Override
    public void constrainType(ValueTypeConstraint constraint, DexMethod method, Origin origin, Reporter reporter) {
        if (this.readType == RegisterReadType.DEBUG) {
            this.abortOnInvalidDebugInfo(constraint);
        }
        super.constrainType(constraint, method, origin, reporter);
    }

    private void abortOnInvalidDebugInfo(ValueTypeConstraint constraint) {
        if (this.constrainedType(constraint) == null) {
            throw new InvalidDebugInfoException("Type information in locals-table is inconsistent. Cannot constrain type: " + this.typeLattice + " for value: " + this + " by constraint " + (Object)((Object)constraint) + ".");
        }
    }

    public void addOperands(IRBuilder builder, int register) {
        assert (this.operands.isEmpty());
        if (this.block.getPredecessors().size() == 0) {
            this.throwUndefinedValueError();
        }
        ValueTypeConstraint readConstraint = TypeConstraintResolver.constraintForType(this.typeLattice);
        ArrayList<Value> operands = new ArrayList<Value>(this.block.getPredecessors().size());
        for (BasicBlock pred : this.block.getPredecessors()) {
            BasicBlock.EdgeType edgeType = pred.getEdgeType(this.block);
            Value operand = builder.readRegister(register, readConstraint, pred, edgeType, this.readType);
            operands.add(operand);
        }
        if (this.readType != RegisterReadType.NORMAL) {
            for (Value operand : operands) {
                TypeLatticeElement type = operand.getTypeLattice();
                ValueTypeConstraint constraint = TypeConstraintResolver.constraintForType(type);
                this.abortOnInvalidDebugInfo(constraint);
            }
        }
        for (Value operand : operands) {
            builder.constrainType(operand, readConstraint);
            this.appendOperand(operand);
        }
        this.removeTrivialPhi(builder, null);
    }

    public void addOperands(List<Value> operands) {
        this.addOperands(operands, true);
    }

    public void addOperands(List<Value> operands, boolean removeTrivialPhi) {
        assert (this.operands.isEmpty());
        if (operands.size() == 0) {
            this.throwUndefinedValueError();
        }
        for (Value operand : operands) {
            this.appendOperand(operand);
        }
        if (removeTrivialPhi) {
            this.removeTrivialPhi();
        }
    }

    @Override
    public void markNonDebugLocalRead() {
        this.readType = RegisterReadType.NORMAL;
    }

    private void throwUndefinedValueError() {
        throw new CompilationError("Undefined value encountered during compilation. This is typically caused by invalid dex input that uses a register that is not defined on all control-flow paths leading to the use.");
    }

    private void appendOperand(Value operand) {
        this.operands.add(operand);
        operand.addPhiUser(this);
    }

    public Value getOperand(int predIndex) {
        return this.operands.get(predIndex);
    }

    public List<Value> getOperands() {
        return this.operands;
    }

    public void removeOperand(int index) {
        this.operands.get(index).removePhiUser(this);
        this.operands.remove(index);
    }

    public void removeOperandsByIndex(List<Integer> operandsToRemove) {
        if (operandsToRemove.isEmpty()) {
            return;
        }
        ArrayList<Value> copy = new ArrayList<Value>(this.operands);
        this.operands.clear();
        int current = 0;
        for (int i : operandsToRemove) {
            this.operands.addAll(copy.subList(current, i));
            ((Value)copy.get(i)).removePhiUser(this);
            current = i + 1;
        }
        this.operands.addAll(copy.subList(current, copy.size()));
    }

    public void replaceOperandAt(int predIndex, Value newValue) {
        Value current = this.operands.get(predIndex);
        this.operands.set(predIndex, newValue);
        newValue.addPhiUser(this);
        current.removePhiUser(this);
    }

    void replaceOperand(Value current, Value newValue) {
        for (int i = 0; i < this.operands.size(); ++i) {
            if (this.operands.get(i) != current) continue;
            this.operands.set(i, newValue);
            newValue.addPhiUser(this);
        }
    }

    public boolean isTrivialPhi() {
        Value same = null;
        for (Value op : this.operands) {
            if (op == same || op == this) continue;
            if (same != null) {
                return false;
            }
            same = op;
        }
        return true;
    }

    public boolean removeTrivialPhi() {
        return this.removeTrivialPhi(null, null);
    }

    public boolean removeTrivialPhi(IRBuilder builder, Set<Value> affectedValues) {
        Value same = null;
        for (Value value : this.operands) {
            if (value == same || value == this) continue;
            if (same != null) {
                assert (!this.isTrivialPhi());
                return false;
            }
            same = value;
        }
        assert (this.isTrivialPhi());
        if (same == null) {
            return false;
        }
        if (builder != null && this.typeLattice.isPreciseType() && !this.typeLattice.isBottom()) {
            builder.constrainType(same, ValueTypeConstraint.fromTypeLattice(this.typeLattice));
        }
        if (affectedValues != null) {
            affectedValues.addAll(this.affectedValues());
        }
        for (Value value : this.operands) {
            value.removePhiUser(this);
        }
        if (this.definitionUsers != null) {
            for (Map map2 : this.definitionUsers) {
                for (Map.Entry entry : map2.entrySet()) {
                    if (entry.getValue() != this) continue;
                    entry.setValue(same);
                    if (!same.isPhi()) continue;
                    same.asPhi().addDefinitionsUser(map2);
                }
            }
        }
        Set<Phi> phiUsersToSimplify = this.uniquePhiUsers();
        this.replaceUsers(same);
        for (Phi user : phiUsersToSimplify) {
            user.removeTrivialPhi(builder, affectedValues);
        }
        this.block.removePhi(this);
        return true;
    }

    public void removeDeadPhi() {
        assert (!this.hasUsers());
        for (Value operand : this.getOperands()) {
            operand.removePhiUser(this);
        }
        this.getBlock().removePhi(this);
    }

    public String printPhi() {
        StringBuilder builder = new StringBuilder();
        builder.append("v");
        builder.append(this.number);
        if (this.hasLocalInfo()) {
            builder.append("(").append(this.getLocalInfo()).append(")");
        }
        builder.append(" <- phi");
        StringUtils.append(builder, ListUtils.map(this.operands, Value::toString));
        builder.append(" : ").append(this.getTypeLattice());
        return builder.toString();
    }

    public void print(CfgPrinter printer) {
        int uses = this.numberOfPhiUsers() + this.numberOfUsers();
        printer.print("0 ").append(uses).append(" v").append(this.number).append(" Phi");
        for (Value operand : this.operands) {
            printer.append(" v").append(operand.number);
        }
    }

    public void addDefinitionsUser(Map<Integer, Value> currentDefinitions) {
        this.definitionUsers.add(currentDefinitions);
    }

    public void removeDefinitionsUser(Map<Integer, Value> currentDefinitions) {
        this.definitionUsers.remove(currentDefinitions);
    }

    public void clearDefinitionsUsers() {
        this.definitionUsers = null;
    }

    @Override
    public boolean isConstant() {
        return false;
    }

    @Override
    public boolean isValueOnStack() {
        assert (this.verifyIsStackPhi(Sets.newIdentityHashSet()));
        return this.isStackPhi;
    }

    public void setIsStackPhi(boolean isStackPhi) {
        this.isStackPhi = isStackPhi;
    }

    private boolean verifyIsStackPhi(Set<Phi> seenPhis) {
        seenPhis.add(this);
        this.operands.forEach(v -> {
            if (v.isPhi() ? !$assertionsDisabled && !seenPhis.contains(v) && !v.asPhi().verifyIsStackPhi(seenPhis) : !$assertionsDisabled && v.isValueOnStack() != this.isStackPhi) {
                throw new AssertionError();
            }
        });
        return true;
    }

    @Override
    public boolean needsRegister() {
        return !this.isValueOnStack();
    }

    public boolean usesValueOneTime(Value usedValue) {
        return this.operands.indexOf(usedValue) == this.operands.lastIndexOf(usedValue);
    }

    public DexType computeVerificationType(TypeVerificationHelper helper) {
        assert (this.outType().isObject());
        HashSet<DexType> operandTypes = new HashSet<DexType>(this.operands.size());
        for (Value operand : this.operands) {
            DexType operandType = helper.getDexType(operand);
            if (operandType == null) continue;
            operandTypes.add(operandType);
        }
        return helper.join(operandTypes);
    }

    public TypeLatticeElement computePhiType(AppView<?> appView) {
        TypeLatticeElement result = TypeLatticeElement.BOTTOM;
        for (Value operand : this.getOperands()) {
            result = result.join(operand.getTypeLattice(), appView);
        }
        return result;
    }

    @Override
    public TypeLatticeElement getDynamicUpperBoundType(AppView<? extends AppInfoWithSubtyping> appView) {
        Set<Phi> reachablePhis = SetUtils.newIdentityHashSet(this);
        Deque<Phi> worklist = DequeUtils.newArrayDeque(this);
        while (!worklist.isEmpty()) {
            Phi phi = worklist.removeFirst();
            assert (reachablePhis.contains(phi));
            for (Value operand : phi.getOperands()) {
                Phi candidate = operand.getAliasedValue().asPhi();
                if (candidate == null || !reachablePhis.add(candidate)) continue;
                worklist.addLast(candidate);
            }
        }
        Set<Value> visitedOperands = Sets.newIdentityHashSet();
        TypeLatticeElement result = TypeLatticeElement.BOTTOM;
        for (Phi phi : reachablePhis) {
            for (Value operand : phi.getOperands()) {
                if (operand.getAliasedValue().isPhi() || !visitedOperands.add(operand)) continue;
                result = result.join(operand.getDynamicUpperBoundType(appView), appView);
            }
        }
        return result;
    }

    public static enum RegisterReadType {
        NORMAL,
        DEBUG;

    }
}

