/*
 * Decompiled with CFR 0.152.
 */
package shadow.bundletool.com.android.tools.r8.ir.code;

import java.util.Set;
import shadow.bundletool.com.android.tools.r8.cf.code.CfNumberConversion;
import shadow.bundletool.com.android.tools.r8.code.DoubleToFloat;
import shadow.bundletool.com.android.tools.r8.code.DoubleToInt;
import shadow.bundletool.com.android.tools.r8.code.DoubleToLong;
import shadow.bundletool.com.android.tools.r8.code.FloatToDouble;
import shadow.bundletool.com.android.tools.r8.code.FloatToInt;
import shadow.bundletool.com.android.tools.r8.code.FloatToLong;
import shadow.bundletool.com.android.tools.r8.code.Format12x;
import shadow.bundletool.com.android.tools.r8.code.IntToByte;
import shadow.bundletool.com.android.tools.r8.code.IntToChar;
import shadow.bundletool.com.android.tools.r8.code.IntToDouble;
import shadow.bundletool.com.android.tools.r8.code.IntToFloat;
import shadow.bundletool.com.android.tools.r8.code.IntToLong;
import shadow.bundletool.com.android.tools.r8.code.IntToShort;
import shadow.bundletool.com.android.tools.r8.code.LongToDouble;
import shadow.bundletool.com.android.tools.r8.code.LongToFloat;
import shadow.bundletool.com.android.tools.r8.code.LongToInt;
import shadow.bundletool.com.android.tools.r8.errors.Unreachable;
import shadow.bundletool.com.android.tools.r8.graph.AppView;
import shadow.bundletool.com.android.tools.r8.ir.analysis.type.PrimitiveTypeLatticeElement;
import shadow.bundletool.com.android.tools.r8.ir.analysis.type.TypeLatticeElement;
import shadow.bundletool.com.android.tools.r8.ir.code.Instruction;
import shadow.bundletool.com.android.tools.r8.ir.code.InstructionVisitor;
import shadow.bundletool.com.android.tools.r8.ir.code.NumericType;
import shadow.bundletool.com.android.tools.r8.ir.code.Phi;
import shadow.bundletool.com.android.tools.r8.ir.code.Unop;
import shadow.bundletool.com.android.tools.r8.ir.code.Value;
import shadow.bundletool.com.android.tools.r8.ir.conversion.CfBuilder;
import shadow.bundletool.com.android.tools.r8.ir.conversion.DexBuilder;

public class NumberConversion
extends Unop {
    public final NumericType from;
    public final NumericType to;

    public NumberConversion(NumericType from, NumericType to, Value dest, Value source) {
        super(dest, source);
        this.from = from;
        this.to = to;
    }

    @Override
    public int opcode() {
        return 50;
    }

    @Override
    public <T> T accept(InstructionVisitor<T> visitor) {
        return visitor.visit(this);
    }

    public boolean isLongToIntConversion() {
        return this.from == NumericType.LONG && this.to == NumericType.INT;
    }

    @Override
    public void buildDex(DexBuilder builder) {
        Format12x instruction;
        int dest = builder.allocatedRegister(this.dest(), this.getNumber());
        int src = builder.allocatedRegister(this.source(), this.getNumber());
        block0 : switch (this.from) {
            case INT: {
                switch (this.to) {
                    case BYTE: {
                        instruction = new IntToByte(dest, src);
                        break block0;
                    }
                    case CHAR: {
                        instruction = new IntToChar(dest, src);
                        break block0;
                    }
                    case SHORT: {
                        instruction = new IntToShort(dest, src);
                        break block0;
                    }
                    case LONG: {
                        instruction = new IntToLong(dest, src);
                        break block0;
                    }
                    case FLOAT: {
                        instruction = new IntToFloat(dest, src);
                        break block0;
                    }
                    case DOUBLE: {
                        instruction = new IntToDouble(dest, src);
                        break block0;
                    }
                }
                throw new Unreachable("Unexpected types " + (Object)((Object)this.from) + ", " + (Object)((Object)this.to));
            }
            case LONG: {
                switch (this.to) {
                    case INT: {
                        instruction = new LongToInt(dest, src);
                        break block0;
                    }
                    case FLOAT: {
                        instruction = new LongToFloat(dest, src);
                        break block0;
                    }
                    case DOUBLE: {
                        instruction = new LongToDouble(dest, src);
                        break block0;
                    }
                }
                throw new Unreachable("Unexpected types " + (Object)((Object)this.from) + ", " + (Object)((Object)this.to));
            }
            case FLOAT: {
                switch (this.to) {
                    case INT: {
                        instruction = new FloatToInt(dest, src);
                        break block0;
                    }
                    case LONG: {
                        instruction = new FloatToLong(dest, src);
                        break block0;
                    }
                    case DOUBLE: {
                        instruction = new FloatToDouble(dest, src);
                        break block0;
                    }
                }
                throw new Unreachable("Unexpected types " + (Object)((Object)this.from) + ", " + (Object)((Object)this.to));
            }
            case DOUBLE: {
                switch (this.to) {
                    case INT: {
                        instruction = new DoubleToInt(dest, src);
                        break block0;
                    }
                    case LONG: {
                        instruction = new DoubleToLong(dest, src);
                        break block0;
                    }
                    case FLOAT: {
                        instruction = new DoubleToFloat(dest, src);
                        break block0;
                    }
                }
                throw new Unreachable("Unexpected types " + (Object)((Object)this.from) + ", " + (Object)((Object)this.to));
            }
            default: {
                throw new Unreachable("Unexpected types " + (Object)((Object)this.from) + ", " + (Object)((Object)this.to));
            }
        }
        builder.add((Instruction)this, (shadow.bundletool.com.android.tools.r8.code.Instruction)instruction);
    }

    @Override
    public boolean identicalNonValueNonPositionParts(Instruction other) {
        if (!other.isNumberConversion()) {
            return false;
        }
        NumberConversion o = other.asNumberConversion();
        return o.from == this.from && o.to == this.to;
    }

    @Override
    public boolean isNumberConversion() {
        return true;
    }

    @Override
    public NumberConversion asNumberConversion() {
        return this;
    }

    @Override
    public TypeLatticeElement evaluate(AppView<?> appView) {
        return PrimitiveTypeLatticeElement.fromNumericType(this.to);
    }

    @Override
    public void buildCf(CfBuilder builder) {
        builder.add(new CfNumberConversion(this.from, this.to));
    }

    @Override
    public boolean outTypeKnownToBeBoolean(Set<Phi> seen) {
        return this.to == NumericType.BYTE && this.source().knownToBeBoolean(seen);
    }
}

