/*
 * Decompiled with CFR 0.152.
 */
package shadow.bundletool.com.android.tools.r8.ir.code;

import shadow.bundletool.com.android.tools.r8.errors.Unreachable;
import shadow.bundletool.com.android.tools.r8.ir.analysis.type.TypeLatticeElement;
import shadow.bundletool.com.android.tools.r8.ir.code.Value;
import shadow.bundletool.com.android.tools.r8.ir.code.ValueType;

public class FixedRegisterValue
extends Value {
    private final int register;

    public FixedRegisterValue(TypeLatticeElement moveType, int register) {
        super(-1, moveType, null);
        this.setNeedsRegister(true);
        this.register = register;
    }

    @Override
    public ValueType outType() {
        TypeLatticeElement type = this.getTypeLattice();
        if (type.isPrimitive()) {
            if (type.isSinglePrimitive()) {
                if (type.isInt()) {
                    return ValueType.INT;
                }
                if (type.isFloat()) {
                    return ValueType.FLOAT;
                }
            } else {
                assert (type.isWidePrimitive());
                if (type.isDouble()) {
                    return ValueType.DOUBLE;
                }
                if (type.isLong()) {
                    return ValueType.LONG;
                }
            }
        } else {
            assert (type.isReference());
            return ValueType.OBJECT;
        }
        throw new Unreachable("Unexpected imprecise type: " + type);
    }

    public int getRegister() {
        return this.register;
    }

    @Override
    public boolean isFixedRegisterValue() {
        return true;
    }

    @Override
    public FixedRegisterValue asFixedRegisterValue() {
        return this;
    }

    @Override
    public boolean isConstant() {
        return false;
    }

    @Override
    public String toString() {
        return "r" + this.register;
    }
}

