/*
 * Decompiled with CFR 0.152.
 */
package shadow.bundletool.com.android.tools.r8.ir.code;

import java.util.Objects;
import java.util.Set;
import shadow.bundletool.com.android.tools.r8.cf.LoadStoreHelper;
import shadow.bundletool.com.android.tools.r8.cf.TypeVerificationHelper;
import shadow.bundletool.com.android.tools.r8.errors.Unimplemented;
import shadow.bundletool.com.android.tools.r8.errors.Unreachable;
import shadow.bundletool.com.android.tools.r8.graph.AppInfo;
import shadow.bundletool.com.android.tools.r8.graph.AppView;
import shadow.bundletool.com.android.tools.r8.graph.DexType;
import shadow.bundletool.com.android.tools.r8.ir.analysis.type.ClassTypeLatticeElement;
import shadow.bundletool.com.android.tools.r8.ir.analysis.type.TypeLatticeElement;
import shadow.bundletool.com.android.tools.r8.ir.code.Instruction;
import shadow.bundletool.com.android.tools.r8.ir.code.InstructionListIterator;
import shadow.bundletool.com.android.tools.r8.ir.code.InstructionVisitor;
import shadow.bundletool.com.android.tools.r8.ir.code.Phi;
import shadow.bundletool.com.android.tools.r8.ir.code.Value;
import shadow.bundletool.com.android.tools.r8.ir.conversion.CfBuilder;
import shadow.bundletool.com.android.tools.r8.ir.conversion.DexBuilder;
import shadow.bundletool.com.android.tools.r8.ir.optimize.Inliner;
import shadow.bundletool.com.android.tools.r8.ir.optimize.InliningConstraints;

public class Assume<An extends Assumption>
extends Instruction {
    private static final String ERROR_MESSAGE = "Expected Assume instructions to be removed after IR processing.";
    private final An assumption;
    private final Instruction origin;

    private Assume(An assumption, Value dest, Value src, Instruction origin, AppView<?> appView) {
        super(dest, src);
        assert (assumption != null);
        assert (((Assumption)assumption).verifyCorrectnessOfValues(dest, src, appView));
        assert (dest != null);
        this.assumption = assumption;
        this.origin = origin;
    }

    public static Assume<NoAssumption> createAssumeNoneInstruction(Value dest, Value src, Instruction origin, AppView<?> appView) {
        return new Assume<NoAssumption>(NoAssumption.get(), dest, src, origin, appView);
    }

    public static Assume<NonNullAssumption> createAssumeNonNullInstruction(Value dest, Value src, Instruction origin, AppView<?> appView) {
        return new Assume<NonNullAssumption>(NonNullAssumption.get(), dest, src, origin, appView);
    }

    public static Assume<DynamicTypeAssumption> createAssumeDynamicTypeInstruction(TypeLatticeElement dynamicUpperBoundType, ClassTypeLatticeElement dynamicLowerBoundType, Value dest, Value src, Instruction origin, AppView<?> appView) {
        return new Assume<DynamicTypeAssumption>(new DynamicTypeAssumption(dynamicUpperBoundType, dynamicLowerBoundType), dest, src, origin, appView);
    }

    @Override
    public int opcode() {
        return 9;
    }

    public boolean verifyInstructionIsNeeded(AppView<?> appView) {
        if (this.isAssumeDynamicType()) assert (((Assumption)this.assumption).verifyCorrectnessOfValues(this.outValue(), this.src(), appView));
        return true;
    }

    @Override
    public <T> T accept(InstructionVisitor<T> visitor) {
        return visitor.visit(this);
    }

    public An getAssumption() {
        return this.assumption;
    }

    public Value src() {
        return (Value)this.inValues.get(0);
    }

    public Instruction origin() {
        return this.origin;
    }

    @Override
    public boolean outTypeKnownToBeBoolean(Set<Phi> seen) {
        return this.src().knownToBeBoolean(seen);
    }

    @Override
    public String getInstructionName() {
        if (this.isAssumeNone()) {
            return "AssumeNone";
        }
        if (this.isAssumeDynamicType()) {
            return "AssumeDynamicType";
        }
        if (this.isAssumeNonNull()) {
            return "AssumeNonNull";
        }
        throw new Unimplemented();
    }

    @Override
    public boolean isAssume() {
        return true;
    }

    public Assume<An> asAssume() {
        return this;
    }

    @Override
    public boolean isAssumeNone() {
        return ((Assumption)this.assumption).isAssumeNone();
    }

    @Override
    public Assume<NoAssumption> asAssumeNone() {
        assert (this.isAssumeNone());
        Assume self = this;
        return self;
    }

    @Override
    public boolean isAssumeDynamicType() {
        return ((Assumption)this.assumption).isAssumeDynamicType();
    }

    @Override
    public Assume<DynamicTypeAssumption> asAssumeDynamicType() {
        assert (this.isAssumeDynamicType());
        Assume self = this;
        return self;
    }

    @Override
    public boolean isAssumeNonNull() {
        return ((Assumption)this.assumption).isAssumeNonNull();
    }

    @Override
    public Assume<NonNullAssumption> asAssumeNonNull() {
        assert (this.isAssumeNonNull());
        Assume self = this;
        return self;
    }

    public boolean mayAffectStaticType() {
        return this.isAssumeNonNull();
    }

    @Override
    public boolean couldIntroduceAnAlias(AppView<?> appView, Value root) {
        assert (root != null && root.getTypeLattice().isReference());
        assert (this.outValue != null);
        TypeLatticeElement outType = this.outValue.getTypeLattice();
        if (outType.isPrimitive()) {
            return false;
        }
        if (((Assumption)this.assumption).isAssumeNone()) {
            return true;
        }
        if (((Assumption)this.assumption).isAssumeDynamicType()) {
            outType = ((DynamicTypeAssumption)this.asAssumeDynamicType().assumption).getDynamicUpperBoundType();
        }
        if (((AppInfo)appView.appInfo()).hasSubtyping() && outType.isClassType() && root.getTypeLattice().isClassType() && ((AppInfo)appView.appInfo()).withSubtyping().inDifferentHierarchy(outType.asClassTypeLatticeElement().getClassType(), root.getTypeLattice().asClassTypeLatticeElement().getClassType())) {
            return false;
        }
        return outType.isReference();
    }

    @Override
    public boolean isIntroducingAnAlias() {
        return true;
    }

    @Override
    public Value getAliasForOutValue() {
        return this.src();
    }

    @Override
    public void buildDex(DexBuilder builder) {
        throw new Unreachable(ERROR_MESSAGE);
    }

    @Override
    public void buildCf(CfBuilder builder) {
        throw new Unreachable(ERROR_MESSAGE);
    }

    @Override
    public int maxInValueRegister() {
        throw new Unreachable(ERROR_MESSAGE);
    }

    @Override
    public int maxOutValueRegister() {
        throw new Unreachable(ERROR_MESSAGE);
    }

    @Override
    public boolean isOutConstant() {
        return false;
    }

    @Override
    public boolean identicalNonValueNonPositionParts(Instruction other) {
        if (!other.isAssume()) {
            return false;
        }
        Assume<?> assumeInstruction = other.asAssume();
        return this.assumption.equals(assumeInstruction.assumption);
    }

    @Override
    public Inliner.ConstraintWithTarget inliningConstraint(InliningConstraints inliningConstraints, DexType invocationContext) {
        return inliningConstraints.forAssume();
    }

    @Override
    public TypeLatticeElement evaluate(AppView<?> appView) {
        if (((Assumption)this.assumption).isAssumeNone() || ((Assumption)this.assumption).isAssumeDynamicType()) {
            return this.src().getTypeLattice();
        }
        if (((Assumption)this.assumption).isAssumeNonNull()) {
            assert (this.src().getTypeLattice().isReference());
            return this.src().getTypeLattice().asReferenceTypeLatticeElement().asMeetWithNotNull();
        }
        throw new Unimplemented();
    }

    @Override
    public DexType computeVerificationType(AppView<?> appView, TypeVerificationHelper helper) {
        return helper.getDexType(this.src());
    }

    @Override
    public boolean hasInvariantOutType() {
        return false;
    }

    @Override
    public void insertLoadAndStores(InstructionListIterator it, LoadStoreHelper helper) {
        throw new Unreachable(ERROR_MESSAGE);
    }

    @Override
    public boolean instructionMayTriggerMethodInvocation(AppView<?> appView, DexType context) {
        return false;
    }

    @Override
    public boolean verifyTypes(AppView<?> appView) {
        assert (super.verifyTypes(appView));
        TypeLatticeElement inType = this.src().getTypeLattice();
        TypeLatticeElement outType = this.outValue().getTypeLattice();
        if (this.isAssumeNone() || this.isAssumeDynamicType()) {
            assert (inType.isReference()) : inType;
            assert (outType.equals(inType)) : "At " + this + System.lineSeparator() + outType + " != " + inType;
        } else {
            assert (this.isAssumeNonNull()) : this;
            assert (inType.isReference()) : inType;
            assert (inType.isNullType() || outType.equals(inType.asReferenceTypeLatticeElement().asMeetWithNotNull())) : "At " + this + System.lineSeparator() + outType + " != " + inType;
        }
        return true;
    }

    @Override
    public String toString() {
        String originString;
        String string = originString = this.origin.hasBlock() ? " (origin: `" + this.origin.toString() + "`)" : " (obsolete origin)";
        if (this.isAssumeNone() || this.isAssumeNonNull()) {
            return super.toString() + originString;
        }
        if (this.isAssumeDynamicType()) {
            DynamicTypeAssumption assumption = this.asAssumeDynamicType().getAssumption();
            return super.toString() + "; upper bound: " + assumption.dynamicUpperBoundType + (assumption.dynamicLowerBoundType != null ? "; lower bound: " + assumption.dynamicLowerBoundType : "") + originString;
        }
        return super.toString();
    }

    public static class NonNullAssumption
    extends Assumption {
        private static final NonNullAssumption instance = new NonNullAssumption();

        private NonNullAssumption() {
        }

        public static NonNullAssumption get() {
            return instance;
        }

        @Override
        public boolean isAssumeNonNull() {
            return true;
        }

        @Override
        public boolean verifyCorrectnessOfValues(Value dest, Value src, AppView<?> appView) {
            assert (!src.isNeverNull());
            return true;
        }
    }

    public static class DynamicTypeAssumption
    extends Assumption {
        private final TypeLatticeElement dynamicUpperBoundType;
        private final ClassTypeLatticeElement dynamicLowerBoundType;

        private DynamicTypeAssumption(TypeLatticeElement dynamicUpperBoundType, ClassTypeLatticeElement dynamicLowerBoundType) {
            this.dynamicUpperBoundType = dynamicUpperBoundType;
            this.dynamicLowerBoundType = dynamicLowerBoundType;
        }

        public TypeLatticeElement getDynamicUpperBoundType() {
            return this.dynamicUpperBoundType;
        }

        public ClassTypeLatticeElement getDynamicLowerBoundType() {
            return this.dynamicLowerBoundType;
        }

        @Override
        public boolean isAssumeDynamicType() {
            return true;
        }

        @Override
        public boolean verifyCorrectnessOfValues(Value dest, Value src, AppView<?> appView) {
            assert (this.dynamicUpperBoundType.lessThanOrEqualUpToNullability(src.getTypeLattice(), appView));
            return true;
        }

        public boolean equals(Object other) {
            if (other == null) {
                return false;
            }
            if (this.getClass() != other.getClass()) {
                return false;
            }
            DynamicTypeAssumption assumption = (DynamicTypeAssumption)other;
            return this.dynamicUpperBoundType == assumption.dynamicUpperBoundType && this.dynamicLowerBoundType == assumption.dynamicLowerBoundType;
        }

        public int hashCode() {
            return Objects.hash(this.dynamicUpperBoundType, this.dynamicLowerBoundType);
        }
    }

    public static class NoAssumption
    extends Assumption {
        private static final NoAssumption instance = new NoAssumption();

        private NoAssumption() {
        }

        static NoAssumption get() {
            return instance;
        }

        @Override
        public boolean isAssumeNone() {
            return true;
        }

        @Override
        public boolean verifyCorrectnessOfValues(Value dest, Value src, AppView<?> appView) {
            assert (dest.getTypeLattice() == src.getTypeLattice());
            return true;
        }
    }

    static abstract class Assumption {
        Assumption() {
        }

        public boolean isAssumeNone() {
            return false;
        }

        public boolean isAssumeDynamicType() {
            return false;
        }

        public boolean isAssumeNonNull() {
            return false;
        }

        public boolean verifyCorrectnessOfValues(Value dest, Value src, AppView<?> appView) {
            return true;
        }
    }
}

