/*
 * Decompiled with CFR 0.152.
 */
package shadow.bundletool.com.android.tools.r8.ir.analysis.proto.schema;

import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Predicate;
import shadow.bundletool.com.android.tools.r8.com.google.common.collect.Sets;
import shadow.bundletool.com.android.tools.r8.graph.AppInfo;
import shadow.bundletool.com.android.tools.r8.graph.AppView;
import shadow.bundletool.com.android.tools.r8.graph.DexClass;
import shadow.bundletool.com.android.tools.r8.graph.DexEncodedField;
import shadow.bundletool.com.android.tools.r8.graph.DexEncodedMethod;
import shadow.bundletool.com.android.tools.r8.graph.DexField;
import shadow.bundletool.com.android.tools.r8.graph.DexProgramClass;
import shadow.bundletool.com.android.tools.r8.graph.DexType;
import shadow.bundletool.com.android.tools.r8.graph.analysis.EnqueuerAnalysis;
import shadow.bundletool.com.android.tools.r8.ir.analysis.proto.GeneratedMessageLiteShrinker;
import shadow.bundletool.com.android.tools.r8.ir.analysis.proto.ProtoEnqueuerUseRegistry;
import shadow.bundletool.com.android.tools.r8.ir.analysis.proto.ProtoReferences;
import shadow.bundletool.com.android.tools.r8.ir.analysis.proto.ProtoShrinker;
import shadow.bundletool.com.android.tools.r8.ir.analysis.proto.RawMessageInfoDecoder;
import shadow.bundletool.com.android.tools.r8.ir.analysis.proto.schema.ProtoFieldInfo;
import shadow.bundletool.com.android.tools.r8.ir.analysis.proto.schema.ProtoFieldObject;
import shadow.bundletool.com.android.tools.r8.ir.analysis.proto.schema.ProtoFieldType;
import shadow.bundletool.com.android.tools.r8.ir.analysis.proto.schema.ProtoFieldTypeFactory;
import shadow.bundletool.com.android.tools.r8.ir.analysis.proto.schema.ProtoMessageInfo;
import shadow.bundletool.com.android.tools.r8.ir.analysis.proto.schema.ProtoObject;
import shadow.bundletool.com.android.tools.r8.ir.analysis.proto.schema.ProtoOneOfObjectPair;
import shadow.bundletool.com.android.tools.r8.ir.code.IRCode;
import shadow.bundletool.com.android.tools.r8.ir.code.InvokeMethod;
import shadow.bundletool.com.android.tools.r8.ir.optimize.info.FieldOptimizationInfo;
import shadow.bundletool.com.android.tools.r8.shaking.Enqueuer;
import shadow.bundletool.com.android.tools.r8.shaking.EnqueuerWorklist;
import shadow.bundletool.com.android.tools.r8.shaking.KeepReason;
import shadow.bundletool.com.android.tools.r8.utils.BitUtils;
import shadow.bundletool.com.android.tools.r8.utils.OptionalBool;

public class ProtoEnqueuerExtension
extends EnqueuerAnalysis {
    private final AppView<?> appView;
    private final RawMessageInfoDecoder decoder;
    private final ProtoFieldTypeFactory factory;
    private final ProtoReferences references;
    private final Map<DexType, ProtoMessageInfo> liveProtos = new IdentityHashMap<DexType, ProtoMessageInfo>();
    private final Map<DexType, ProtoMessageInfo> seenButNotLiveProtos = new IdentityHashMap<DexType, ProtoMessageInfo>();
    private final Map<ProtoMessageInfo, OptionalBool> reachesMapOrRequiredFieldFromMessageCache = new IdentityHashMap<ProtoMessageInfo, OptionalBool>();
    private final Set<DexEncodedMethod> dynamicMethodsWithTracedProtoObjects = Sets.newIdentityHashSet();

    public ProtoEnqueuerExtension(AppView<?> appView) {
        ProtoShrinker protoShrinker = appView.protoShrinker();
        this.appView = appView;
        this.decoder = protoShrinker.decoder;
        this.factory = protoShrinker.factory;
        this.references = protoShrinker.references;
    }

    @Override
    public void processNewlyLiveMethod(DexEncodedMethod encodedMethod) {
        if (!this.references.isDynamicMethod(encodedMethod)) {
            return;
        }
        DexType holder = encodedMethod.method.holder;
        if (this.seenButNotLiveProtos.containsKey(holder)) {
            this.liveProtos.put(holder, this.seenButNotLiveProtos.remove(holder));
            return;
        }
        assert (!this.liveProtos.containsKey(holder));
        this.createProtoMessageInfoFromDynamicMethod(encodedMethod, this.liveProtos);
    }

    private void createProtoMessageInfoFromDynamicMethod(DexEncodedMethod dynamicMethod, Map<DexType, ProtoMessageInfo> protos) {
        DexType holder = dynamicMethod.method.holder;
        assert (!protos.containsKey(holder));
        DexClass context = this.appView.definitionFor(holder);
        if (context == null || !context.isProgramClass()) {
            assert (false);
            return;
        }
        IRCode code = dynamicMethod.buildIR(this.appView, context.origin);
        InvokeMethod newMessageInfoInvoke = GeneratedMessageLiteShrinker.getNewMessageInfoInvoke(code, this.references);
        ProtoMessageInfo protoMessageInfo = newMessageInfoInvoke != null ? this.decoder.run(dynamicMethod, context, newMessageInfoInvoke) : null;
        protos.put(holder, protoMessageInfo);
    }

    @Override
    public void notifyFixpoint(Enqueuer enqueuer, EnqueuerWorklist worklist) {
        this.markMapOrRequiredFieldsAsReachable(enqueuer, worklist);
        if (enqueuer.getUseRegistryFactory() == ProtoEnqueuerUseRegistry.getFactory()) {
            assert (enqueuer.getMode().isFinalTreeShaking());
            if (worklist.isEmpty()) {
                this.tracePendingInstructionsInDynamicMethods(enqueuer, worklist);
            }
        }
    }

    private void markMapOrRequiredFieldsAsReachable(Enqueuer enqueuer, EnqueuerWorklist worklist) {
        for (ProtoMessageInfo protoMessageInfo : this.liveProtos.values()) {
            if (protoMessageInfo == null || !protoMessageInfo.hasFields()) continue;
            DexEncodedMethod dynamicMethod = protoMessageInfo.getDynamicMethod();
            DexProgramClass clazz = this.appView.definitionFor(dynamicMethod.method.holder).asProgramClass();
            for (ProtoFieldInfo protoFieldInfo : protoMessageInfo.getFields()) {
                boolean valueStorageIsLive;
                DexEncodedField valueStorage = protoFieldInfo.getValueStorage(this.appView, protoMessageInfo);
                if (valueStorage == null) continue;
                if (enqueuer.isFieldLive(valueStorage)) {
                    if (enqueuer.isFieldRead(valueStorage) || enqueuer.isFieldWrittenOutsideDefaultConstructor(valueStorage) || this.reachesMapOrRequiredField(protoFieldInfo)) {
                        enqueuer.registerFieldAccess(valueStorage.field, dynamicMethod);
                    }
                    valueStorageIsLive = true;
                } else if (this.reachesMapOrRequiredField(protoFieldInfo)) {
                    enqueuer.registerFieldAccess(valueStorage.field, dynamicMethod);
                    worklist.enqueueMarkReachableFieldAction(clazz, valueStorage, KeepReason.reflectiveUseIn(dynamicMethod));
                    valueStorageIsLive = true;
                } else {
                    valueStorageIsLive = false;
                }
                DexEncodedField newlyLiveField = null;
                if (valueStorageIsLive) {
                    if (protoFieldInfo.getType().isOneOf()) {
                        newlyLiveField = protoFieldInfo.getOneOfCaseField(this.appView, protoMessageInfo);
                    } else if (protoFieldInfo.hasHazzerBitField(protoMessageInfo)) {
                        newlyLiveField = protoFieldInfo.getHazzerBitField(this.appView, protoMessageInfo);
                    }
                } else if (protoFieldInfo.getType().isOneOf()) {
                    DexEncodedField oneOfCaseField = protoFieldInfo.getOneOfCaseField(this.appView, protoMessageInfo);
                    if (oneOfCaseField != null && enqueuer.isFieldLive(oneOfCaseField)) {
                        newlyLiveField = valueStorage;
                    }
                } else if (protoFieldInfo.hasHazzerBitField(protoMessageInfo)) {
                    DexEncodedField hazzerBitField = protoFieldInfo.getHazzerBitField(this.appView, protoMessageInfo);
                    if (hazzerBitField == null || !enqueuer.isFieldLive(hazzerBitField)) continue;
                    if (this.appView.options().enableFieldBitAccessAnalysis && this.appView.isAllCodeProcessed()) {
                        FieldOptimizationInfo optimizationInfo = hazzerBitField.getOptimizationInfo();
                        int hazzerBitIndex = protoFieldInfo.getHazzerBitFieldIndex(protoMessageInfo);
                        if (!BitUtils.isBitSet(optimizationInfo.getReadBits(), hazzerBitIndex)) continue;
                    }
                    newlyLiveField = valueStorage;
                }
                if (newlyLiveField == null) continue;
                DexEncodedMethod defaultInitializer = clazz.getDefaultInitializer();
                assert (defaultInitializer != null);
                Predicate<DexEncodedMethod> neitherDefaultConstructorNorDynamicMethod = writer -> writer != defaultInitializer && writer != dynamicMethod;
                if (enqueuer.isFieldWrittenInMethodSatisfying(newlyLiveField, neitherDefaultConstructorNorDynamicMethod)) {
                    enqueuer.registerFieldRead(newlyLiveField.field, dynamicMethod);
                }
                if (!enqueuer.registerFieldWrite(newlyLiveField.field, dynamicMethod)) continue;
                worklist.enqueueMarkReachableFieldAction(clazz, newlyLiveField, KeepReason.reflectiveUseIn(dynamicMethod));
            }
            this.registerWriteToOneOfObjectsWithLiveOneOfCaseObject(protoMessageInfo, enqueuer, worklist);
        }
    }

    private void tracePendingInstructionsInDynamicMethods(Enqueuer enqueuer, EnqueuerWorklist worklist) {
        for (ProtoMessageInfo protoMessageInfo : this.liveProtos.values()) {
            DexEncodedMethod dynamicMethod;
            if (protoMessageInfo == null || !protoMessageInfo.hasFields() || !this.dynamicMethodsWithTracedProtoObjects.add(dynamicMethod = protoMessageInfo.getDynamicMethod())) continue;
            for (ProtoFieldInfo protoFieldInfo : protoMessageInfo.getFields()) {
                DexEncodedField valueStorage;
                List<ProtoObject> objects = protoFieldInfo.getObjects();
                if (objects == null || objects.isEmpty() || (valueStorage = protoFieldInfo.getValueStorage(this.appView, protoMessageInfo)) == null || !enqueuer.isFieldLive(valueStorage)) continue;
                for (ProtoObject object : objects) {
                    if (object.isProtoObjectFromStaticGet()) {
                        worklist.enqueueTraceStaticFieldRead(object.asProtoObjectFromStaticGet().getField(), dynamicMethod);
                        continue;
                    }
                    if (!object.isProtoTypeObject()) continue;
                    worklist.enqueueTraceConstClassAction(object.asProtoTypeObject().getType(), dynamicMethod);
                }
            }
        }
    }

    private void registerWriteToOneOfObjectsWithLiveOneOfCaseObject(ProtoMessageInfo protoMessageInfo, Enqueuer enqueuer, EnqueuerWorklist worklist) {
        if (protoMessageInfo.numberOfOneOfObjects() == 0) {
            return;
        }
        for (ProtoOneOfObjectPair oneOfObjectPair : protoMessageInfo.getOneOfObjects()) {
            this.registerWriteToOneOfObjectIfOneOfCaseObjectIsLive(oneOfObjectPair, enqueuer, worklist);
        }
    }

    private void registerWriteToOneOfObjectIfOneOfCaseObjectIsLive(ProtoOneOfObjectPair oneOfObjectPair, Enqueuer enqueuer, EnqueuerWorklist worklist) {
        ProtoFieldObject oneOfCaseObject = oneOfObjectPair.getOneOfCaseObject();
        if (!oneOfCaseObject.isLiveProtoFieldObject()) {
            assert (false);
            return;
        }
        DexField oneOfCaseField = oneOfCaseObject.asLiveProtoFieldObject().getField();
        DexEncodedField encodedOneOfCaseField = ((AppInfo)this.appView.appInfo()).resolveField(oneOfCaseField);
        if (encodedOneOfCaseField == null) {
            assert (false);
            return;
        }
        DexClass clazz = this.appView.definitionFor(encodedOneOfCaseField.field.holder);
        if (clazz == null || !clazz.isProgramClass()) {
            assert (false);
            return;
        }
        DexEncodedMethod dynamicMethod = clazz.lookupVirtualMethod(this.references::isDynamicMethod);
        if (dynamicMethod == null) {
            assert (false);
            return;
        }
        if (!enqueuer.isFieldLive(encodedOneOfCaseField)) {
            return;
        }
        ProtoFieldObject oneOfObject = oneOfObjectPair.getOneOfObject();
        if (!oneOfObject.isLiveProtoFieldObject()) {
            assert (false);
            return;
        }
        DexField oneOfField = oneOfObject.asLiveProtoFieldObject().getField();
        DexEncodedField encodedOneOfField = ((AppInfo)this.appView.appInfo()).resolveField(oneOfField);
        if (encodedOneOfField == null) {
            assert (false);
            return;
        }
        if (encodedOneOfField.field.holder != encodedOneOfCaseField.field.holder) {
            assert (false);
            return;
        }
        if (enqueuer.registerFieldWrite(encodedOneOfField.field, dynamicMethod)) {
            worklist.enqueueMarkReachableFieldAction(clazz.asProgramClass(), encodedOneOfField, KeepReason.reflectiveUseIn(dynamicMethod));
        }
    }

    private boolean reachesMapOrRequiredField(ProtoFieldInfo protoFieldInfo) {
        ProtoFieldType protoFieldType = protoFieldInfo.getType();
        if (protoFieldType.isMap() || protoFieldType.isRequired()) {
            return true;
        }
        if (!this.appView.options().protoShrinking().traverseOneOfAndRepeatedProtoFields && (protoFieldType.isOneOf() || protoFieldType.isRepeated())) {
            return false;
        }
        DexType baseMessageType = protoFieldInfo.getBaseMessageType(this.factory);
        if (baseMessageType != null) {
            ProtoMessageInfo protoMessageInfo = this.getOrCreateProtoMessageInfo(baseMessageType);
            assert (protoMessageInfo != null);
            return this.reachesMapOrRequiredField(protoMessageInfo);
        }
        return false;
    }

    private boolean reachesMapOrRequiredField(ProtoMessageInfo protoMessageInfo) {
        if (!protoMessageInfo.hasFields()) {
            return false;
        }
        OptionalBool cache = this.reachesMapOrRequiredFieldFromMessageCache.getOrDefault(protoMessageInfo, OptionalBool.unknown());
        if (!cache.isUnknown()) {
            return cache.isTrue();
        }
        this.reachesMapOrRequiredFieldFromMessageCache.put(protoMessageInfo, OptionalBool.of(false));
        for (ProtoFieldInfo protoFieldInfo : protoMessageInfo.getFields()) {
            if (!this.reachesMapOrRequiredField(protoFieldInfo)) continue;
            this.reachesMapOrRequiredFieldFromMessageCache.put(protoMessageInfo, OptionalBool.of(true));
            return true;
        }
        return false;
    }

    private ProtoMessageInfo getOrCreateProtoMessageInfo(DexType type) {
        if (this.liveProtos.containsKey(type)) {
            return this.liveProtos.get(type);
        }
        if (this.seenButNotLiveProtos.containsKey(type)) {
            return this.seenButNotLiveProtos.get(type);
        }
        DexClass clazz = this.appView.definitionFor(type);
        if (clazz == null || !clazz.isProgramClass()) {
            this.seenButNotLiveProtos.put(type, null);
            return null;
        }
        DexEncodedMethod dynamicMethod = clazz.lookupVirtualMethod(this.references::isDynamicMethod);
        if (dynamicMethod == null) {
            this.seenButNotLiveProtos.put(type, null);
            return null;
        }
        this.createProtoMessageInfoFromDynamicMethod(dynamicMethod, this.seenButNotLiveProtos);
        return this.seenButNotLiveProtos.get(type);
    }
}

