/*
 * Decompiled with CFR 0.152.
 */
package shadow.bundletool.com.android.tools.r8.ir.analysis;

import shadow.bundletool.com.android.tools.r8.graph.AppView;
import shadow.bundletool.com.android.tools.r8.graph.DexEncodedMethod;
import shadow.bundletool.com.android.tools.r8.ir.code.IRCode;
import shadow.bundletool.com.android.tools.r8.ir.code.Instruction;
import shadow.bundletool.com.android.tools.r8.shaking.AppInfoWithLiveness;

public class DeterminismAnalysis {
    public static boolean returnValueOnlyDependsOnArguments(AppView<AppInfoWithLiveness> appView, IRCode code) {
        for (Instruction instr : code.instructions()) {
            if (instr.outValue() == null || !instr.outValue().isUsed()) continue;
            if (instr.isStaticGet()) {
                return false;
            }
            if (instr.isInstanceGet()) {
                return false;
            }
            if (instr.isArrayGet() || instr.isArrayLength()) {
                return false;
            }
            if (instr.isInvokeMethod()) {
                DexEncodedMethod target = instr.asInvokeMethod().lookupSingleTarget(appView, code.method.method.holder);
                if (target != null && target.getOptimizationInfo().returnValueOnlyDependsOnArguments()) continue;
                return false;
            }
            if (instr.isInvokeCustom() || instr.isInvokePolymorphic()) {
                return false;
            }
            if (instr.isCreatingInstanceOrArray()) {
                return false;
            }
            if (instr.isMoveException()) {
                return false;
            }
            assert (instr.isArgument() || instr.isAssume() || instr.isBinop() || instr.isUnop() || instr.isMonitor() || instr.isMove() || instr.isCheckCast() || instr.isInstanceOf() || instr.isConstInstruction() || instr.isJumpInstruction() || instr.isDebugInstruction()) : "Instruction that impacts determinism: " + instr;
        }
        return true;
    }
}

