/*
 * Decompiled with CFR 0.152.
 */
package shadow.bundletool.com.android.tools.r8.graph.analysis;

import java.util.List;
import shadow.bundletool.com.android.tools.r8.cf.code.CfConstNumber;
import shadow.bundletool.com.android.tools.r8.cf.code.CfFieldInstruction;
import shadow.bundletool.com.android.tools.r8.cf.code.CfGoto;
import shadow.bundletool.com.android.tools.r8.cf.code.CfIf;
import shadow.bundletool.com.android.tools.r8.cf.code.CfInstruction;
import shadow.bundletool.com.android.tools.r8.cf.code.CfInvoke;
import shadow.bundletool.com.android.tools.r8.cf.code.CfLogicalBinop;
import shadow.bundletool.com.android.tools.r8.com.google.common.collect.ImmutableList;
import shadow.bundletool.com.android.tools.r8.graph.CfCode;
import shadow.bundletool.com.android.tools.r8.graph.DexEncodedMethod;
import shadow.bundletool.com.android.tools.r8.graph.DexItemFactory;
import shadow.bundletool.com.android.tools.r8.graph.analysis.EnqueuerAnalysis;
import shadow.bundletool.com.android.tools.r8.ir.optimize.info.OptimizationFeedback;

public class ClassInitializerAssertionEnablingAnalysis
extends EnqueuerAnalysis {
    private final DexItemFactory dexItemFactory;
    private final OptimizationFeedback feedback;
    private static List<Class<?>> javacInstructionSequence = ImmutableList.of(CfIf.class, CfConstNumber.class, CfGoto.class, CfConstNumber.class, CfFieldInstruction.class);
    private static List<Class<?>> r8InstructionSequence = ImmutableList.of(CfConstNumber.class, CfLogicalBinop.class, CfFieldInstruction.class);

    public ClassInitializerAssertionEnablingAnalysis(DexItemFactory dexItemFactory, OptimizationFeedback feedback) {
        this.dexItemFactory = dexItemFactory;
        this.feedback = feedback;
    }

    @Override
    public void processNewlyLiveMethod(DexEncodedMethod method) {
        if (method.isClassInitializer() && method.getCode().isCfCode() && this.hasJavacClinitAssertionCode(method.getCode().asCfCode())) {
            this.feedback.setInitializerEnablingJavaAssertions(method);
        }
    }

    private boolean hasJavacClinitAssertionCode(CfCode code) {
        for (int i = 0; i < code.instructions.size(); ++i) {
            CfInvoke invoke;
            CfInstruction instruction = code.instructions.get(i);
            if (instruction.isInvoke() && (invoke = instruction.asInvoke()).getOpcode() == 182 && invoke.getMethod() == this.dexItemFactory.classMethods.desiredAssertionStatus) {
                CfFieldInstruction fieldInstruction = this.isJavacInstructionSequence(code, i + 1);
                if (fieldInstruction == null) {
                    fieldInstruction = this.isR8InstructionSequence(code, i + 1);
                }
                if (fieldInstruction != null) {
                    return fieldInstruction.getOpcode() == 179 && fieldInstruction.getField().name == this.dexItemFactory.assertionsDisabled;
                }
            }
            if (!instruction.isJump()) continue;
            return false;
        }
        return false;
    }

    private CfFieldInstruction isJavacInstructionSequence(CfCode code, int fromIndex) {
        List<Class<?>> sequence = javacInstructionSequence;
        int nextExpectedInstructionIndex = 0;
        CfInstruction instruction = null;
        for (int i = fromIndex; i < code.instructions.size() && nextExpectedInstructionIndex < sequence.size(); ++i) {
            instruction = code.instructions.get(i);
            if (instruction.isLabel()) continue;
            if (instruction.getClass() != sequence.get(nextExpectedInstructionIndex)) break;
            ++nextExpectedInstructionIndex;
        }
        return nextExpectedInstructionIndex == sequence.size() ? instruction.asFieldInstruction() : null;
    }

    private CfFieldInstruction isR8InstructionSequence(CfCode code, int fromIndex) {
        List<Class<?>> sequence = r8InstructionSequence;
        int nextExpectedInstructionIndex = 0;
        CfInstruction instruction = null;
        for (int i = fromIndex; i < code.instructions.size() && nextExpectedInstructionIndex < sequence.size(); ++i) {
            instruction = code.instructions.get(i);
            if (instruction.isStore() || instruction.isLoad()) continue;
            if (instruction.getClass() != sequence.get(nextExpectedInstructionIndex)) break;
            ++nextExpectedInstructionIndex;
        }
        return nextExpectedInstructionIndex == sequence.size() ? instruction.asFieldInstruction() : null;
    }
}

