/*
 * Decompiled with CFR 0.152.
 */
package shadow.bundletool.com.android.tools.r8.graph;

import java.util.Arrays;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import shadow.bundletool.com.android.tools.r8.dex.IndexedItemCollection;
import shadow.bundletool.com.android.tools.r8.dex.MixedSectionCollection;
import shadow.bundletool.com.android.tools.r8.graph.DexAnnotation;
import shadow.bundletool.com.android.tools.r8.graph.DexAnnotationSet;
import shadow.bundletool.com.android.tools.r8.graph.DexItem;
import shadow.bundletool.com.android.tools.r8.graph.DexMethod;
import shadow.bundletool.com.android.tools.r8.utils.ArrayUtils;

public class ParameterAnnotationsList
extends DexItem {
    private static final ParameterAnnotationsList EMPTY_PARAMETER_ANNOTATIONS_LIST = new ParameterAnnotationsList();
    private final DexAnnotationSet[] values;
    private final int missingParameterAnnotations;

    public static ParameterAnnotationsList empty() {
        return EMPTY_PARAMETER_ANNOTATIONS_LIST;
    }

    private ParameterAnnotationsList() {
        this.values = DexAnnotationSet.EMPTY_ARRAY;
        this.missingParameterAnnotations = 0;
    }

    public ParameterAnnotationsList(DexAnnotationSet[] values2) {
        this(values2, 0);
    }

    public ParameterAnnotationsList(DexAnnotationSet[] values2, int missingParameterAnnotations) {
        assert (values2 != null && values2.length > 0);
        this.values = values2;
        this.missingParameterAnnotations = missingParameterAnnotations;
    }

    public int getAnnotableParameterCount() {
        return this.size();
    }

    public int hashCode() {
        return Arrays.hashCode(this.values);
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other instanceof ParameterAnnotationsList) {
            return Arrays.equals(this.values, ((ParameterAnnotationsList)other).values);
        }
        return false;
    }

    @Override
    public void collectIndexedItems(IndexedItemCollection indexedItems, DexMethod method, int instructionOffset) {
        ParameterAnnotationsList.collectAll((IndexedItemCollection)indexedItems, (DexItem[])this.values);
    }

    @Override
    void collectMixedSectionItems(MixedSectionCollection mixedItems) {
        ParameterAnnotationsList.collectAll((MixedSectionCollection)mixedItems, (DexItem[])this.values);
        mixedItems.add(this);
    }

    public boolean isEmpty() {
        return this.values.length == 0;
    }

    public void forEachAnnotation(Consumer<DexAnnotation> consumer) {
        for (DexAnnotationSet parameterAnnotations : this.values) {
            for (DexAnnotation annotation : parameterAnnotations.annotations) {
                consumer.accept(annotation);
            }
        }
    }

    public int size() {
        return this.missingParameterAnnotations + this.values.length;
    }

    public int countNonMissing() {
        return this.values.length;
    }

    public boolean isMissing(int i) {
        assert (i >= 0);
        return i < this.missingParameterAnnotations;
    }

    public DexAnnotationSet get(int i) {
        assert (i >= 0);
        int adjustedIndex = i - this.missingParameterAnnotations;
        return 0 <= adjustedIndex && adjustedIndex < this.values.length ? this.values[adjustedIndex] : DexAnnotationSet.empty();
    }

    public ParameterAnnotationsList withParameterCount(int parameterCount) {
        if (this == EMPTY_PARAMETER_ANNOTATIONS_LIST || parameterCount == this.size()) {
            return this;
        }
        if (parameterCount < this.size()) {
            DexAnnotationSet[] trimmedValues = new DexAnnotationSet[parameterCount];
            System.arraycopy(this.values, 0, trimmedValues, 0, parameterCount);
            return new ParameterAnnotationsList(trimmedValues, 0);
        }
        return new ParameterAnnotationsList(this.values, parameterCount - this.values.length);
    }

    public ParameterAnnotationsList keepIf(Predicate<DexAnnotation> filter) {
        DexAnnotationSet[] filtered = null;
        boolean allEmpty = true;
        for (int i = 0; i < this.values.length; ++i) {
            DexAnnotationSet updated = this.values[i].keepIf(filter);
            if (updated != this.values[i]) {
                if (filtered == null) {
                    filtered = (DexAnnotationSet[])this.values.clone();
                }
                filtered[i] = updated;
            }
            if (updated.isEmpty()) continue;
            allEmpty = false;
        }
        if (filtered == null) {
            return this;
        }
        if (allEmpty) {
            return ParameterAnnotationsList.empty();
        }
        return new ParameterAnnotationsList(filtered, this.missingParameterAnnotations);
    }

    public ParameterAnnotationsList rewrite(Function<DexAnnotationSet, DexAnnotationSet> mapper) {
        DexAnnotationSet[] rewritten = ArrayUtils.map(DexAnnotationSet[].class, this.values, mapper);
        if (rewritten != this.values) {
            return new ParameterAnnotationsList(rewritten, this.missingParameterAnnotations);
        }
        return this;
    }
}

