/*
 * Decompiled with CFR 0.152.
 */
package shadow.bundletool.com.android.tools.r8.graph;

import java.util.Collection;
import java.util.Collections;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import shadow.bundletool.com.android.tools.r8.DataResourceProvider;
import shadow.bundletool.com.android.tools.r8.com.google.common.collect.ImmutableList;
import shadow.bundletool.com.android.tools.r8.com.google.common.collect.ImmutableSet;
import shadow.bundletool.com.android.tools.r8.graph.Code;
import shadow.bundletool.com.android.tools.r8.graph.DexApplication;
import shadow.bundletool.com.android.tools.r8.graph.DexClass;
import shadow.bundletool.com.android.tools.r8.graph.DexClasspathClass;
import shadow.bundletool.com.android.tools.r8.graph.DexDefinition;
import shadow.bundletool.com.android.tools.r8.graph.DexDefinitionSupplier;
import shadow.bundletool.com.android.tools.r8.graph.DexEncodedField;
import shadow.bundletool.com.android.tools.r8.graph.DexEncodedMethod;
import shadow.bundletool.com.android.tools.r8.graph.DexField;
import shadow.bundletool.com.android.tools.r8.graph.DexItemFactory;
import shadow.bundletool.com.android.tools.r8.graph.DexLibraryClass;
import shadow.bundletool.com.android.tools.r8.graph.DexMethod;
import shadow.bundletool.com.android.tools.r8.graph.DexProgramClass;
import shadow.bundletool.com.android.tools.r8.graph.DexReference;
import shadow.bundletool.com.android.tools.r8.graph.DexString;
import shadow.bundletool.com.android.tools.r8.graph.DexType;
import shadow.bundletool.com.android.tools.r8.graph.GraphLense;
import shadow.bundletool.com.android.tools.r8.graph.LazyLoadedDexApplication;
import shadow.bundletool.com.android.tools.r8.naming.ClassNameMapper;
import shadow.bundletool.com.android.tools.r8.utils.InternalOptions;
import shadow.bundletool.com.android.tools.r8.utils.Timing;

public class DirectMappedDexApplication
extends DexApplication
implements DexDefinitionSupplier {
    private final Map<Code, DexEncodedMethod> codeOwners = new IdentityHashMap<Code, DexEncodedMethod>();
    private final Map<DexType, DexClass> allClasses;
    private final ImmutableList<DexProgramClass> programClasses;
    private final ImmutableList<DexClasspathClass> classpathClasses;
    private final ImmutableList<DexLibraryClass> libraryClasses;

    private DirectMappedDexApplication(ClassNameMapper proguardMap, Map<DexType, DexClass> allClasses, ImmutableList<DexProgramClass> programClasses, ImmutableList<DexClasspathClass> classpathClasses, ImmutableList<DexLibraryClass> libraryClasses, ImmutableList<DataResourceProvider> dataResourceProviders, ImmutableSet<DexType> mainDexList, InternalOptions options, DexString highestSortingString, Timing timing) {
        super(proguardMap, dataResourceProviders, mainDexList, options, highestSortingString, timing);
        this.allClasses = Collections.unmodifiableMap(allClasses);
        this.programClasses = programClasses;
        this.classpathClasses = classpathClasses;
        this.libraryClasses = libraryClasses;
    }

    public Collection<DexClass> allClasses() {
        return this.allClasses.values();
    }

    @Override
    List<DexProgramClass> programClasses() {
        return this.programClasses;
    }

    public Collection<DexLibraryClass> libraryClasses() {
        return this.libraryClasses;
    }

    @Override
    public DexDefinition definitionFor(DexReference reference) {
        if (reference.isDexType()) {
            return this.definitionFor(reference.asDexType());
        }
        if (reference.isDexMethod()) {
            return this.definitionFor(reference.asDexMethod());
        }
        assert (reference.isDexField());
        return this.definitionFor(reference.asDexField());
    }

    @Override
    public DexEncodedField definitionFor(DexField field) {
        DexClass clazz = this.definitionFor(field.holder);
        return clazz != null ? clazz.lookupField(field) : null;
    }

    @Override
    public DexEncodedMethod definitionFor(DexMethod method) {
        DexClass clazz = this.definitionFor(method.holder);
        return clazz != null ? clazz.lookupMethod(method) : null;
    }

    @Override
    public DexClass definitionFor(DexType type) {
        assert (type.isClassType()) : "Cannot lookup definition for type: " + type;
        return this.allClasses.get(type);
    }

    @Override
    public DexProgramClass definitionForProgramType(DexType type) {
        return this.programDefinitionFor(type);
    }

    @Override
    public DexItemFactory dexItemFactory() {
        return this.dexItemFactory;
    }

    @Override
    public DexProgramClass programDefinitionFor(DexType type) {
        DexClass clazz = this.definitionFor(type);
        return clazz instanceof DexProgramClass ? clazz.asProgramClass() : null;
    }

    public Builder builder() {
        return new Builder(this);
    }

    @Override
    public DirectMappedDexApplication toDirect() {
        return this;
    }

    @Override
    public DirectMappedDexApplication asDirect() {
        return this;
    }

    @Override
    public String toString() {
        return "DexApplication (direct)";
    }

    public DirectMappedDexApplication rewrittenWithLense(GraphLense graphLense) {
        DirectMappedDexApplication rewrittenApplication = this.builder().build().asDirect();
        assert (rewrittenApplication.mappingIsValid(graphLense, this.allClasses.keySet()));
        assert (rewrittenApplication.verifyCodeObjectsOwners());
        return rewrittenApplication;
    }

    private boolean mappingIsValid(GraphLense graphLense, Iterable<DexType> types) {
        for (DexType type : types) {
            DexType renamed = graphLense.lookupType(type);
            if (renamed != type && (this.definitionFor(type) != null || this.definitionFor(renamed) == null)) assert (this.definitionFor((DexType)type).type == renamed || this.definitionFor(renamed) != null);
        }
        return true;
    }

    public Map<Code, DexEncodedMethod> computeCodeObjectOwnersForDebugging() {
        this.verifyCodeObjectsOwners();
        return this.codeOwners;
    }

    public DexEncodedMethod getCodeOwnerForDebugging(Code code) {
        return this.computeCodeObjectOwnersForDebugging().get(code);
    }

    private boolean verifyCodeObjectsOwners() {
        this.codeOwners.clear();
        for (DexProgramClass clazz : this.programClasses) {
            for (DexEncodedMethod method : clazz.methods(DexEncodedMethod::isNonAbstractNonNativeMethod)) {
                Code code = method.getCode();
                assert (code != null);
                if (code.isCfCode()) {
                    code = code.asCfCode();
                }
                DexEncodedMethod otherMethod = this.codeOwners.put(code, method);
                assert (otherMethod == null);
            }
        }
        return true;
    }

    private static <T extends DexClass> void addAll(Map<DexType, DexClass> allClasses, Iterable<T> toAdd) {
        for (DexClass clazz : toAdd) {
            DexClass old = allClasses.put(clazz.type, clazz);
            assert (old == null);
        }
    }

    public static class Builder
    extends DexApplication.Builder<Builder> {
        private final ImmutableList<DexLibraryClass> libraryClasses;
        private final ImmutableList<DexClasspathClass> classpathClasses;

        Builder(LazyLoadedDexApplication application) {
            super(application);
            LazyLoadedDexApplication.AllClasses allClasses = application.loadAllClasses();
            this.libraryClasses = allClasses.getLibraryClasses();
            this.classpathClasses = allClasses.getClasspathClasses();
            this.replaceProgramClasses(allClasses.getProgramClasses());
        }

        private Builder(DirectMappedDexApplication application) {
            super(application);
            this.libraryClasses = application.libraryClasses;
            this.classpathClasses = application.classpathClasses;
        }

        @Override
        Builder self() {
            return this;
        }

        @Override
        public DexApplication build() {
            IdentityHashMap allClasses = new IdentityHashMap(this.programClasses.size() + this.classpathClasses.size() + this.libraryClasses.size());
            DirectMappedDexApplication.addAll(allClasses, this.libraryClasses);
            DirectMappedDexApplication.addAll(allClasses, this.classpathClasses);
            DirectMappedDexApplication.addAll(allClasses, this.programClasses);
            return new DirectMappedDexApplication(this.proguardMap, allClasses, ImmutableList.copyOf(this.programClasses), this.classpathClasses, this.libraryClasses, ImmutableList.copyOf(this.dataResourceProviders), ImmutableSet.copyOf(this.mainDexList), this.options, this.highestSortingString, this.timing);
        }
    }
}

