/*
 * Decompiled with CFR 0.152.
 */
package shadow.bundletool.com.android.tools.r8.graph;

import shadow.bundletool.com.android.tools.r8.dex.IndexedItemCollection;
import shadow.bundletool.com.android.tools.r8.dex.MixedSectionCollection;
import shadow.bundletool.com.android.tools.r8.graph.AppView;
import shadow.bundletool.com.android.tools.r8.graph.DebugLocalInfo;
import shadow.bundletool.com.android.tools.r8.graph.DexAnnotationSet;
import shadow.bundletool.com.android.tools.r8.graph.DexClass;
import shadow.bundletool.com.android.tools.r8.graph.DexDefinitionSupplier;
import shadow.bundletool.com.android.tools.r8.graph.DexField;
import shadow.bundletool.com.android.tools.r8.graph.DexMethod;
import shadow.bundletool.com.android.tools.r8.graph.DexReference;
import shadow.bundletool.com.android.tools.r8.graph.DexType;
import shadow.bundletool.com.android.tools.r8.graph.DexValue;
import shadow.bundletool.com.android.tools.r8.graph.FieldAccessFlags;
import shadow.bundletool.com.android.tools.r8.graph.KeyedDexItem;
import shadow.bundletool.com.android.tools.r8.ir.analysis.type.Nullability;
import shadow.bundletool.com.android.tools.r8.ir.analysis.type.TypeLatticeElement;
import shadow.bundletool.com.android.tools.r8.ir.analysis.value.AbstractValue;
import shadow.bundletool.com.android.tools.r8.ir.analysis.value.SingleValue;
import shadow.bundletool.com.android.tools.r8.ir.code.IRCode;
import shadow.bundletool.com.android.tools.r8.ir.code.Instruction;
import shadow.bundletool.com.android.tools.r8.ir.code.TypeAndLocalInfoSupplier;
import shadow.bundletool.com.android.tools.r8.ir.optimize.info.DefaultFieldOptimizationInfo;
import shadow.bundletool.com.android.tools.r8.ir.optimize.info.FieldOptimizationInfo;
import shadow.bundletool.com.android.tools.r8.ir.optimize.info.MutableFieldOptimizationInfo;
import shadow.bundletool.com.android.tools.r8.shaking.AppInfoWithLiveness;

public class DexEncodedField
extends KeyedDexItem<DexField> {
    public static final DexEncodedField[] EMPTY_ARRAY = new DexEncodedField[0];
    public final DexField field;
    public final FieldAccessFlags accessFlags;
    public DexAnnotationSet annotations;
    private DexValue staticValue;
    private FieldOptimizationInfo optimizationInfo = DefaultFieldOptimizationInfo.getInstance();

    public DexEncodedField(DexField field, FieldAccessFlags accessFlags, DexAnnotationSet annotations, DexValue staticValue) {
        this.field = field;
        this.accessFlags = accessFlags;
        this.annotations = annotations;
        this.staticValue = staticValue;
    }

    public boolean isProgramField(DexDefinitionSupplier definitions) {
        if (this.field.holder.isClassType()) {
            DexClass clazz = definitions.definitionFor(this.field.holder);
            return clazz != null && clazz.isProgramClass();
        }
        return false;
    }

    public FieldOptimizationInfo getOptimizationInfo() {
        return this.optimizationInfo;
    }

    public synchronized MutableFieldOptimizationInfo getMutableOptimizationInfo() {
        if (this.optimizationInfo.isDefaultFieldOptimizationInfo()) {
            MutableFieldOptimizationInfo mutableOptimizationInfo = new MutableFieldOptimizationInfo();
            this.optimizationInfo = mutableOptimizationInfo;
            return mutableOptimizationInfo;
        }
        assert (this.optimizationInfo.isMutableFieldOptimizationInfo());
        return this.optimizationInfo.asMutableFieldOptimizationInfo();
    }

    public void setOptimizationInfo(MutableFieldOptimizationInfo info) {
        this.optimizationInfo = info;
    }

    @Override
    public void collectIndexedItems(IndexedItemCollection indexedItems, DexMethod method, int instructionOffset) {
        this.field.collectIndexedItems(indexedItems, method, instructionOffset);
        this.annotations.collectIndexedItems(indexedItems, method, instructionOffset);
        if (this.accessFlags.isStatic()) {
            this.getStaticValue().collectIndexedItems(indexedItems, method, instructionOffset);
        }
    }

    @Override
    void collectMixedSectionItems(MixedSectionCollection mixedItems) {
        this.annotations.collectMixedSectionItems(mixedItems);
    }

    public String toString() {
        return "Encoded field " + this.field;
    }

    @Override
    public String toSmaliString() {
        return this.field.toSmaliString();
    }

    @Override
    public String toSourceString() {
        return this.field.toSourceString();
    }

    @Override
    public DexField getKey() {
        return this.field;
    }

    @Override
    public DexReference toReference() {
        return this.field;
    }

    @Override
    public boolean isDexEncodedField() {
        return true;
    }

    @Override
    public DexEncodedField asDexEncodedField() {
        return this;
    }

    public boolean isFinal() {
        return this.accessFlags.isFinal();
    }

    @Override
    public boolean isStatic() {
        return this.accessFlags.isStatic();
    }

    public boolean isPrivate() {
        return this.accessFlags.isPrivate();
    }

    @Override
    public boolean isStaticMember() {
        return this.isStatic();
    }

    public boolean hasAnnotation() {
        return !this.annotations.isEmpty();
    }

    public boolean hasExplicitStaticValue() {
        assert (this.accessFlags.isStatic());
        return this.staticValue != null;
    }

    public void setStaticValue(DexValue staticValue) {
        assert (this.accessFlags.isStatic());
        assert (staticValue != null);
        this.staticValue = staticValue;
    }

    public DexValue getStaticValue() {
        assert (this.accessFlags.isStatic());
        return this.staticValue == null ? DexValue.defaultForType(this.field.type) : this.staticValue;
    }

    public Instruction valueAsConstInstruction(IRCode code, DebugLocalInfo local, AppView<AppInfoWithLiveness> appView) {
        SingleValue singleValue;
        boolean isWritten = appView.appInfo().isFieldWrittenByFieldPutInstruction(this);
        if (!isWritten) {
            DexValue value = this.isStatic() ? this.getStaticValue() : DexValue.defaultForType(this.field.type);
            return value.asConstInstruction(appView, code, local);
        }
        AbstractValue abstractValue = this.getOptimizationInfo().getAbstractValue();
        if (abstractValue.isSingleValue() && (singleValue = abstractValue.asSingleValue()).isMaterializableInContext(appView, code.method.method.holder)) {
            TypeLatticeElement type = TypeLatticeElement.fromDexType(this.field.type, Nullability.maybeNull(), appView);
            return singleValue.createMaterializingInstruction(appView, code, TypeAndLocalInfoSupplier.create(type, local));
        }
        if (this.accessFlags.isFinal() && this.isStatic()) {
            DexClass clazz = appView.definitionFor(this.field.holder);
            if (clazz == null || clazz.hasClassInitializer()) {
                return null;
            }
            DexValue staticValue = this.getStaticValue();
            if (!staticValue.isDefault(this.field.type)) {
                return staticValue.asConstInstruction(appView, code, local);
            }
        }
        return null;
    }

    public boolean mayTriggerClassInitializationSideEffects(AppView<AppInfoWithLiveness> appView, DexType context) {
        if (!this.isStatic()) {
            return false;
        }
        DexClass clazz = appView.definitionFor(this.field.holder);
        if (clazz == null) {
            return true;
        }
        if (clazz.classInitializationMayHaveSideEffects(appView, type -> appView.isSubtype(context, (DexType)type).isTrue())) {
            boolean ignore = appView.withGeneratedExtensionRegistryShrinker(shrinker -> shrinker.isDeadProtoExtensionField(this.field), false);
            return !ignore;
        }
        return false;
    }

    public DexEncodedField toTypeSubstitutedField(DexField field) {
        if (this.field == field) {
            return this;
        }
        DexEncodedField result = new DexEncodedField(field, this.accessFlags, this.annotations, this.staticValue);
        result.optimizationInfo = this.optimizationInfo.isMutableFieldOptimizationInfo() ? this.optimizationInfo.asMutableFieldOptimizationInfo().mutableCopy() : DefaultFieldOptimizationInfo.getInstance();
        return result;
    }
}

