/*
 * Decompiled with CFR 0.152.
 */
package shadow.bundletool.com.android.tools.r8.graph;

import java.util.Map;
import java.util.TreeSet;
import shadow.bundletool.com.android.tools.r8.com.google.common.collect.ImmutableMap;
import shadow.bundletool.com.android.tools.r8.graph.DebugLocalInfo;
import shadow.bundletool.com.android.tools.r8.graph.DexMethod;
import shadow.bundletool.com.android.tools.r8.graph.DexString;
import shadow.bundletool.com.android.tools.r8.ir.code.Position;
import shadow.bundletool.com.android.tools.r8.utils.StringUtils;

public class DexDebugEntry {
    public final boolean lineEntry;
    public final int address;
    public final int line;
    public final DexString sourceFile;
    public final boolean prologueEnd;
    public final boolean epilogueBegin;
    public final Map<Integer, DebugLocalInfo> locals;
    public final DexMethod method;
    public final Position callerPosition;

    public DexDebugEntry(boolean lineEntry, int address, int line, DexString sourceFile, boolean prologueEnd, boolean epilogueBegin, ImmutableMap<Integer, DebugLocalInfo> locals, DexMethod method, Position callerPosition) {
        this.lineEntry = lineEntry;
        this.address = address;
        this.line = line;
        this.sourceFile = sourceFile;
        this.prologueEnd = prologueEnd;
        this.epilogueBegin = epilogueBegin;
        this.locals = locals;
        this.method = method;
        assert (method != null);
        this.callerPosition = callerPosition;
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean withPcPrefix) {
        StringBuilder builder = new StringBuilder();
        if (withPcPrefix) {
            builder.append("pc ");
        }
        builder.append(StringUtils.hexString(this.address, 2));
        if (this.sourceFile != null) {
            builder.append(", file ").append(this.sourceFile);
        }
        builder.append(", line ").append(this.line);
        if (this.callerPosition != null) {
            builder.append(":").append(this.method.name);
            Position caller = this.callerPosition;
            while (caller != null) {
                builder.append(";").append(caller.line).append(":").append(caller.method.name);
                caller = caller.callerPosition;
            }
        }
        if (this.prologueEnd) {
            builder.append(", prologue_end = true");
        }
        if (this.epilogueBegin) {
            builder.append(", epilogue_begin = true");
        }
        if (!this.locals.isEmpty()) {
            builder.append(", locals: [");
            TreeSet<Integer> keys2 = new TreeSet<Integer>(this.locals.keySet());
            boolean first = true;
            for (Integer register : keys2) {
                if (first) {
                    first = false;
                } else {
                    builder.append(", ");
                }
                builder.append(register).append(" -> ").append(this.locals.get(register));
            }
            builder.append("]");
        }
        return builder.toString();
    }
}

