/*
 * Decompiled with CFR 0.152.
 */
package shadow.bundletool.com.android.tools.r8;

import java.io.IOException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import shadow.bundletool.com.android.tools.r8.ArchiveClassFileProvider;
import shadow.bundletool.com.android.tools.r8.PrintSeeds;
import shadow.bundletool.com.android.tools.r8.com.google.common.collect.Maps;
import shadow.bundletool.com.android.tools.r8.com.google.common.collect.Sets;
import shadow.bundletool.com.android.tools.r8.dex.ApplicationReader;
import shadow.bundletool.com.android.tools.r8.graph.AppInfoWithSubtyping;
import shadow.bundletool.com.android.tools.r8.graph.DexAnnotation;
import shadow.bundletool.com.android.tools.r8.graph.DexApplication;
import shadow.bundletool.com.android.tools.r8.graph.DexCallSite;
import shadow.bundletool.com.android.tools.r8.graph.DexClass;
import shadow.bundletool.com.android.tools.r8.graph.DexEncodedField;
import shadow.bundletool.com.android.tools.r8.graph.DexEncodedMethod;
import shadow.bundletool.com.android.tools.r8.graph.DexField;
import shadow.bundletool.com.android.tools.r8.graph.DexItem;
import shadow.bundletool.com.android.tools.r8.graph.DexItemFactory;
import shadow.bundletool.com.android.tools.r8.graph.DexMethod;
import shadow.bundletool.com.android.tools.r8.graph.DexProgramClass;
import shadow.bundletool.com.android.tools.r8.graph.DexType;
import shadow.bundletool.com.android.tools.r8.graph.DexValue;
import shadow.bundletool.com.android.tools.r8.graph.ResolutionResult;
import shadow.bundletool.com.android.tools.r8.graph.UseRegistry;
import shadow.bundletool.com.android.tools.r8.ir.desugar.LambdaDescriptor;
import shadow.bundletool.com.android.tools.r8.utils.AndroidApp;
import shadow.bundletool.com.android.tools.r8.utils.InternalOptions;
import shadow.bundletool.com.android.tools.r8.utils.StringUtils;
import shadow.bundletool.com.android.tools.r8.utils.Timing;

public class PrintUses {
    private static final String USAGE = "Arguments: [--keeprules, --keeprules-allowobfuscation] <rt.jar> <r8.jar> <sample.jar>\n\nPrintUses prints the classes, interfaces, methods and fields used by <sample.jar>,\nrestricted to classes and interfaces in <r8.jar> that are not in <sample.jar>.\n<rt.jar> and <r8.jar> should point to libraries used by <sample.jar>.\n\nThe output is in the same format as what is printed when specifying -printseeds in\na ProGuard configuration file. Use --keeprules or --keeprules-allowobfuscation for outputting proguard keep rules. See also the " + PrintSeeds.class.getSimpleName() + " program in R8.";
    private final Set<String> descriptors;
    private final Printer printer;
    private final boolean allowObfuscation;
    private Set<DexType> types = Sets.newIdentityHashSet();
    private Map<DexType, Set<DexMethod>> methods = Maps.newIdentityHashMap();
    private Map<DexType, Set<DexField>> fields = Maps.newIdentityHashMap();
    private Set<DexType> noObfuscationTypes = Sets.newIdentityHashSet();
    private Set<String> keepPackageNames = Sets.newHashSet();
    private final DexApplication application;
    private final AppInfoWithSubtyping appInfo;
    private int errors;

    public static void main(String ... args) throws Exception {
        if (args.length != 3 && args.length != 4) {
            System.out.println(USAGE.replace("\n", System.lineSeparator()));
            return;
        }
        int argumentIndex = 0;
        boolean printKeep = false;
        boolean allowObfuscation = false;
        if (args[0].equals("--keeprules") || args[0].equals("--keeprules-allowobfuscation")) {
            printKeep = true;
            ++argumentIndex;
            allowObfuscation = args[0].equals("--keeprules-allowobfuscation");
            for (int i = 1; i < args.length; ++i) {
                if (!args[i].startsWith("-keeprules")) continue;
                System.out.println("Use either --keeprules or --keeprules-allowobfuscation, not both.");
                System.out.println(USAGE.replace("\n", System.lineSeparator()));
                return;
            }
        }
        AndroidApp.Builder builder = AndroidApp.builder();
        Path rtJar = Paths.get(args[argumentIndex++], new String[0]);
        builder.addLibraryFile(rtJar);
        Path r8Jar = Paths.get(args[argumentIndex++], new String[0]);
        builder.addLibraryFile(r8Jar);
        Path sampleJar = Paths.get(args[argumentIndex], new String[0]);
        builder.addProgramFile(sampleJar);
        HashSet<String> descriptors = new HashSet<String>(PrintUses.getDescriptors(r8Jar));
        descriptors.removeAll(PrintUses.getDescriptors(sampleJar));
        Printer printer = printKeep ? new KeepPrinter() : new DefaultPrinter();
        PrintUses printUses = new PrintUses(descriptors, builder.build(), printer, allowObfuscation);
        printUses.analyze();
        printUses.print();
        if (printUses.errors > 0) {
            System.err.println(printUses.errors + " errors");
            System.exit(1);
        }
    }

    private static Set<String> getDescriptors(Path path) throws IOException {
        return new ArchiveClassFileProvider(path).getClassDescriptors();
    }

    private PrintUses(Set<String> descriptors, AndroidApp inputApp, Printer printer, boolean allowObfuscation) throws Exception {
        this.descriptors = descriptors;
        this.printer = printer;
        this.allowObfuscation = allowObfuscation;
        InternalOptions options = new InternalOptions();
        this.application = new ApplicationReader(inputApp, options, new Timing("PrintUses")).read().toDirect();
        this.appInfo = new AppInfoWithSubtyping(this.application);
    }

    private void analyze() {
        UseCollector useCollector = new UseCollector(this.appInfo.dexItemFactory());
        for (DexProgramClass dexProgramClass : this.application.classes()) {
            useCollector.setContext(dexProgramClass);
            useCollector.registerSuperType(dexProgramClass, dexProgramClass.superType);
            for (DexType implementsType : dexProgramClass.interfaces.values) {
                useCollector.registerSuperType(dexProgramClass, implementsType);
            }
            dexProgramClass.forEachMethod(x$0 -> useCollector.registerMethod(x$0));
            dexProgramClass.forEachField(x$0 -> useCollector.registerField(x$0));
        }
    }

    private void print() {
        this.errors = this.printer.print(this.application, this.types, this.noObfuscationTypes, this.keepPackageNames, this.methods, this.fields);
    }

    private static class KeepPrinter
    extends Printer {
        private KeepPrinter() {
        }

        @Override
        public void printTypeHeader(DexClass dexClass, boolean allowObfuscation) {
            this.append(allowObfuscation ? "-keep,allowobfuscation" : "-keep");
            if (dexClass.isInterface()) {
                this.append(" interface " + dexClass.type.toSourceString() + " {\n");
            } else if (dexClass.accessFlags.isEnum()) {
                this.append(" enum " + dexClass.type.toSourceString() + " {\n");
            } else {
                this.append(" class " + dexClass.type.toSourceString() + " {\n");
            }
        }

        @Override
        public void printConstructorName(DexEncodedMethod encodedMethod) {
            this.append("<init>");
        }

        @Override
        public void printField(DexClass dexClass, DexField field) {
            this.append("  " + field.type.toSourceString() + " " + field.name.toString() + ";\n");
        }

        @Override
        public void printMethod(DexEncodedMethod encodedMethod, String typeName) {
            if (encodedMethod.accessFlags.isConstructor() && encodedMethod.accessFlags.isStatic()) {
                return;
            }
            this.append("  ");
            if (encodedMethod.isPublicMethod()) {
                this.append("public ");
            } else if (encodedMethod.isPrivateMethod()) {
                this.append("private ");
            }
            if (encodedMethod.isStatic()) {
                this.append("static ");
            }
            this.printNameAndReturn(encodedMethod);
            this.printArguments(encodedMethod.method);
            this.appendLine(";");
        }

        @Override
        void printPackageNames(List<String> packageNames) {
            this.append("-keeppackagenames " + StringUtils.join(packageNames, ",") + "\n");
        }

        @Override
        public void printTypeFooter() {
            this.appendLine("}");
        }
    }

    private static class DefaultPrinter
    extends Printer {
        private DefaultPrinter() {
        }

        @Override
        public void printConstructorName(DexEncodedMethod encodedMethod) {
            if (encodedMethod.accessFlags.isStatic()) {
                this.append("<clinit>");
            } else {
                String holderName = encodedMethod.method.holder.toSourceString();
                String constructorName = holderName.substring(holderName.lastIndexOf(46) + 1);
                this.append(constructorName);
            }
        }

        @Override
        void printMethod(DexEncodedMethod encodedMethod, String typeName) {
            this.append(typeName + ": ");
            this.printNameAndReturn(encodedMethod);
            this.printArguments(encodedMethod.method);
            this.appendLine("");
        }

        @Override
        void printPackageNames(List<String> packageNames) {
        }

        @Override
        void printTypeHeader(DexClass dexClass, boolean allowObfuscation) {
            this.appendLine(dexClass.type.toSourceString());
        }

        @Override
        void printTypeFooter() {
        }

        @Override
        void printField(DexClass dexClass, DexField field) {
            this.appendLine(dexClass.type.toSourceString() + ": " + field.type.toSourceString() + " " + field.name.toString());
        }
    }

    private static abstract class Printer {
        private Printer() {
        }

        void append(String string) {
            System.out.print(string);
        }

        void appendLine(String string) {
            System.out.println(string);
        }

        void printArguments(DexMethod method) {
            this.append("(");
            for (int i = 0; i < method.getArity(); ++i) {
                if (i != 0) {
                    this.append(",");
                }
                this.append(method.proto.parameters.values[i].toSourceString());
            }
            this.append(")");
        }

        abstract void printConstructorName(DexEncodedMethod var1);

        void printError(String message) {
            this.appendLine("# Error: " + message);
        }

        abstract void printField(DexClass var1, DexField var2);

        abstract void printMethod(DexEncodedMethod var1, String var2);

        abstract void printPackageNames(List<String> var1);

        void printNameAndReturn(DexEncodedMethod encodedMethod) {
            if (encodedMethod.accessFlags.isConstructor()) {
                this.printConstructorName(encodedMethod);
            } else {
                DexMethod method = encodedMethod.method;
                this.append(method.proto.returnType.toSourceString());
                this.append(" ");
                this.append(method.name.toSourceString());
            }
        }

        abstract void printTypeHeader(DexClass var1, boolean var2);

        abstract void printTypeFooter();

        int print(DexApplication application, Set<DexType> types, Set<DexType> noObfuscationTypes, Set<String> keepPackageNames, Map<DexType, Set<DexMethod>> methods, Map<DexType, Set<DexField>> fields) {
            int errors = 0;
            ArrayList<DexType> sortedTypes = new ArrayList<DexType>(types);
            sortedTypes.sort(Comparator.comparing(DexType::toSourceString));
            for (DexType type : sortedTypes) {
                DexClass dexClass = application.definitionFor(type);
                if (dexClass == null) {
                    this.printError("Could not find definition for type " + type.toSourceString());
                    ++errors;
                    continue;
                }
                this.printTypeHeader(dexClass, !noObfuscationTypes.contains(type));
                ArrayList<DexEncodedMethod> methodDefinitions = new ArrayList<DexEncodedMethod>(methods.size());
                for (DexMethod method : methods.get(type)) {
                    DexEncodedMethod encodedMethod = dexClass.lookupMethod(method);
                    if (encodedMethod == null) {
                        this.printError("Could not find definition for method " + method.toSourceString());
                        ++errors;
                        continue;
                    }
                    methodDefinitions.add(encodedMethod);
                }
                methodDefinitions.sort(Comparator.comparing(x -> x.method.name.toSourceString()));
                for (DexEncodedMethod encodedMethod : methodDefinitions) {
                    this.printMethod(encodedMethod, dexClass.type.toSourceString());
                }
                ArrayList<DexField> sortedFields = new ArrayList<DexField>((Collection)fields.get(type));
                sortedFields.sort(Comparator.comparing(DexField::toSourceString));
                for (DexField field : sortedFields) {
                    this.printField(dexClass, field);
                }
                this.printTypeFooter();
            }
            ArrayList<String> packageNamesToKeep = new ArrayList<String>(keepPackageNames);
            Collections.sort(packageNamesToKeep);
            this.printPackageNames(packageNamesToKeep);
            return errors;
        }
    }

    class UseCollector
    extends UseRegistry {
        private DexProgramClass context;

        UseCollector(DexItemFactory factory) {
            super(factory);
        }

        public void setContext(DexProgramClass context) {
            this.context = context;
        }

        @Override
        public boolean registerInvokeVirtual(DexMethod method) {
            DexEncodedMethod target = PrintUses.this.appInfo.lookupVirtualTarget(method.holder, method);
            if (target != null && target.method != method) {
                this.addType(method.holder);
                this.addMethod(target.method);
            } else {
                this.addMethod(method);
            }
            return false;
        }

        @Override
        public boolean registerInvokeDirect(DexMethod method) {
            this.addMethod(method);
            return false;
        }

        @Override
        public boolean registerInvokeStatic(DexMethod method) {
            DexEncodedMethod target = PrintUses.this.appInfo.lookupStaticTarget(method);
            if (target != null && target.method != method) {
                this.addType(method.holder);
                this.addMethod(target.method);
            } else {
                this.addMethod(method);
            }
            return false;
        }

        @Override
        public boolean registerInvokeInterface(DexMethod method) {
            return this.registerInvokeVirtual(method);
        }

        @Override
        public boolean registerInvokeSuper(DexMethod method) {
            DexEncodedMethod superTarget = PrintUses.this.appInfo.lookupSuperTarget(method, method.holder);
            if (superTarget != null) {
                this.addMethod(superTarget.method);
            } else {
                this.addMethod(method);
            }
            return false;
        }

        @Override
        public boolean registerInstanceFieldWrite(DexField field) {
            this.addField(field, false);
            return false;
        }

        @Override
        public boolean registerInstanceFieldRead(DexField field) {
            this.addField(field, false);
            return false;
        }

        @Override
        public boolean registerNewInstance(DexType type) {
            this.addType(type);
            return false;
        }

        @Override
        public boolean registerStaticFieldRead(DexField field) {
            this.addField(field, true);
            return false;
        }

        @Override
        public boolean registerStaticFieldWrite(DexField field) {
            this.addField(field, true);
            return false;
        }

        @Override
        public boolean registerTypeReference(DexType type) {
            this.addType(type);
            return false;
        }

        private void addType(DexType type) {
            if (this.isTargetType(type) && PrintUses.this.types.add(type)) {
                DexClass clazz = PrintUses.this.appInfo.definitionFor(type);
                if (clazz == null || !PrintUses.this.allowObfuscation) {
                    PrintUses.this.noObfuscationTypes.add(type);
                }
                if (clazz != null && clazz.accessFlags.isVisibilityDependingOnPackage()) {
                    PrintUses.this.keepPackageNames.add(clazz.type.getPackageName());
                }
                PrintUses.this.methods.put(type, Sets.newIdentityHashSet());
                PrintUses.this.fields.put(type, Sets.newIdentityHashSet());
            }
        }

        private boolean isTargetType(DexType type) {
            return PrintUses.this.descriptors.contains(type.toDescriptorString());
        }

        private void addField(DexField field, boolean isStatic) {
            DexEncodedField baseField;
            this.addType(field.type);
            DexEncodedField dexEncodedField = baseField = isStatic ? PrintUses.this.appInfo.lookupStaticTarget(field.holder, field) : PrintUses.this.appInfo.lookupInstanceTarget(field.holder, field);
            if (baseField != null && baseField.field.holder != field.holder) {
                field = baseField.field;
            }
            this.addType(field.holder);
            Set typeFields = (Set)PrintUses.this.fields.get(field.holder);
            if (typeFields != null) {
                assert (baseField != null);
                if (!PrintUses.this.allowObfuscation) {
                    PrintUses.this.noObfuscationTypes.add(field.holder);
                }
                if (baseField.accessFlags.isVisibilityDependingOnPackage()) {
                    PrintUses.this.keepPackageNames.add(baseField.field.holder.getPackageName());
                }
                typeFields.add(field);
            }
        }

        private void addMethod(DexMethod method) {
            this.addType(method.holder);
            for (DexType parameterType : method.proto.parameters.values) {
                this.addType(parameterType);
            }
            this.addType(method.proto.returnType);
            Set typeMethods = (Set)PrintUses.this.methods.get(method.holder);
            if (typeMethods != null) {
                DexEncodedMethod encodedMethod = PrintUses.this.appInfo.definitionFor(method);
                assert (encodedMethod != null) : "Could not find method " + method.toString();
                if (!PrintUses.this.allowObfuscation) {
                    PrintUses.this.noObfuscationTypes.add(method.holder);
                }
                if (encodedMethod.accessFlags.isVisibilityDependingOnPackage()) {
                    PrintUses.this.keepPackageNames.add(encodedMethod.method.holder.getPackageName());
                }
                typeMethods.add(method);
            }
        }

        private void registerField(DexEncodedField field) {
            this.registerTypeReference(field.field.type);
        }

        private void registerMethod(DexEncodedMethod method) {
            DexEncodedMethod superTarget = PrintUses.this.appInfo.resolveMethod(method.method.holder, method.method).lookupInvokeSpecialTarget(this.context, PrintUses.this.appInfo);
            if (superTarget != null) {
                this.addMethod(superTarget.method);
            }
            for (DexType dexType : method.method.proto.parameters.values) {
                this.registerTypeReference(dexType);
            }
            for (DexItem dexItem : method.annotations.annotations) {
                if (((DexAnnotation)dexItem).annotation.type != ((PrintUses)PrintUses.this).appInfo.dexItemFactory().annotationThrows) continue;
                DexValue.DexValueArray dexValues = (DexValue.DexValueArray)((DexAnnotation)dexItem).annotation.elements[0].value;
                for (DexValue dexValType : dexValues.getValues()) {
                    this.registerTypeReference((DexType)((DexValue.DexValueType)dexValType).value);
                }
            }
            this.registerTypeReference(method.method.proto.returnType);
            method.registerCodeReferences(this);
        }

        private void registerSuperType(DexProgramClass clazz, DexType superType) {
            this.registerTypeReference(superType);
            clazz.forEachMethod(method -> {
                ResolutionResult resolutionResult = PrintUses.this.appInfo.resolveMethod(superType, method.method);
                DexEncodedMethod dexEncodedMethod = resolutionResult.getSingleTarget();
                if (dexEncodedMethod != null) {
                    this.addMethod(dexEncodedMethod.method);
                }
            });
        }

        @Override
        public void registerCallSite(DexCallSite callSite) {
            super.registerCallSite(callSite);
            List<DexType> directInterfaces = LambdaDescriptor.getInterfaces(callSite, PrintUses.this.appInfo);
            if (directInterfaces != null) {
                for (DexType directInterface : directInterfaces) {
                    DexClass clazz = PrintUses.this.appInfo.definitionFor(directInterface);
                    if (clazz == null) continue;
                    for (DexEncodedMethod encodedMethod : clazz.virtualMethods()) {
                        if (!encodedMethod.method.name.equals(callSite.methodName)) continue;
                        this.registerMethod(encodedMethod);
                    }
                }
            }
        }
    }
}

