/*
 * Decompiled with CFR 0.152.
 */
package shadow.bundletool.com.android.tools.r8;

import java.nio.file.Path;
import java.util.Collection;
import java.util.List;
import java.util.function.BiPredicate;
import shadow.bundletool.com.android.tools.r8.AssertionsConfiguration;
import shadow.bundletool.com.android.tools.r8.BaseCommand;
import shadow.bundletool.com.android.tools.r8.BaseCompilerCommand;
import shadow.bundletool.com.android.tools.r8.ClassFileConsumer;
import shadow.bundletool.com.android.tools.r8.ClassFileResourceProvider;
import shadow.bundletool.com.android.tools.r8.CompilationMode;
import shadow.bundletool.com.android.tools.r8.D8CommandParser;
import shadow.bundletool.com.android.tools.r8.DesugarGraphConsumer;
import shadow.bundletool.com.android.tools.r8.DexFilePerClassFileConsumer;
import shadow.bundletool.com.android.tools.r8.Diagnostic;
import shadow.bundletool.com.android.tools.r8.DiagnosticsHandler;
import shadow.bundletool.com.android.tools.r8.Keep;
import shadow.bundletool.com.android.tools.r8.ProgramConsumer;
import shadow.bundletool.com.android.tools.r8.StringConsumer;
import shadow.bundletool.com.android.tools.r8.errors.DexFileOverflowDiagnostic;
import shadow.bundletool.com.android.tools.r8.graph.DexItemFactory;
import shadow.bundletool.com.android.tools.r8.ir.desugar.DesugaredLibraryConfiguration;
import shadow.bundletool.com.android.tools.r8.origin.Origin;
import shadow.bundletool.com.android.tools.r8.utils.AndroidApiLevel;
import shadow.bundletool.com.android.tools.r8.utils.AndroidApp;
import shadow.bundletool.com.android.tools.r8.utils.AssertionConfigurationWithDefault;
import shadow.bundletool.com.android.tools.r8.utils.InternalOptions;
import shadow.bundletool.com.android.tools.r8.utils.Reporter;
import shadow.bundletool.com.android.tools.r8.utils.StringDiagnostic;

@Keep
public final class D8Command
extends BaseCompilerCommand {
    static final String USAGE_MESSAGE = D8CommandParser.USAGE_MESSAGE;
    private final boolean intermediate;
    private final DesugarGraphConsumer desugarGraphConsumer;
    private final StringConsumer desugaredLibraryKeepRuleConsumer;
    private final DesugaredLibraryConfiguration libraryConfiguration;
    private final DexItemFactory factory;

    public static Builder builder() {
        return new Builder();
    }

    public static Builder builder(DiagnosticsHandler diagnosticsHandler) {
        return new Builder(diagnosticsHandler);
    }

    static Builder builder(AndroidApp app) {
        return new Builder(app);
    }

    public static Builder parse(String[] args, Origin origin) {
        return D8CommandParser.parse(args, origin);
    }

    public static Builder parse(String[] args, Origin origin, DiagnosticsHandler handler) {
        return D8CommandParser.parse(args, origin, handler);
    }

    private D8Command(AndroidApp inputApp, CompilationMode mode, ProgramConsumer programConsumer, StringConsumer mainDexListConsumer, int minApiLevel, Reporter diagnosticsHandler, boolean enableDesugaring, boolean intermediate, boolean optimizeMultidexForLinearAlloc, boolean encodeChecksum, BiPredicate<String, Long> dexClassChecksumFilter, DesugarGraphConsumer desugarGraphConsumer, StringConsumer desugaredLibraryKeepRuleConsumer, DesugaredLibraryConfiguration libraryConfiguration, List<AssertionsConfiguration> assertionsConfiguration, DexItemFactory factory) {
        super(inputApp, mode, programConsumer, mainDexListConsumer, minApiLevel, diagnosticsHandler, enableDesugaring, optimizeMultidexForLinearAlloc, encodeChecksum, dexClassChecksumFilter, assertionsConfiguration);
        this.intermediate = intermediate;
        this.desugarGraphConsumer = desugarGraphConsumer;
        this.desugaredLibraryKeepRuleConsumer = desugaredLibraryKeepRuleConsumer;
        this.libraryConfiguration = libraryConfiguration;
        this.factory = factory;
    }

    private D8Command(boolean printHelp, boolean printVersion) {
        super(printHelp, printVersion);
        this.intermediate = false;
        this.desugarGraphConsumer = null;
        this.desugaredLibraryKeepRuleConsumer = null;
        this.libraryConfiguration = null;
        this.factory = null;
    }

    @Override
    InternalOptions getInternalOptions() {
        InternalOptions internal = new InternalOptions(this.factory, this.getReporter());
        assert (!internal.debug);
        internal.debug = this.getMode() == CompilationMode.DEBUG;
        internal.programConsumer = this.getProgramConsumer();
        internal.mainDexListConsumer = this.getMainDexListConsumer();
        internal.minimalMainDex = internal.debug;
        internal.minApiLevel = this.getMinApiLevel();
        internal.intermediate = this.intermediate;
        internal.readCompileTimeAnnotations = this.intermediate;
        internal.desugarGraphConsumer = this.desugarGraphConsumer;
        assert (!internal.isShrinking());
        assert (!internal.isMinifying());
        assert (!internal.passthroughDexCode);
        internal.passthroughDexCode = true;
        assert (internal.neverMergePrefixes.contains("j$."));
        assert (!internal.enableDynamicTypeOptimization);
        assert (!internal.enableInlining);
        assert (!internal.enableClassInlining);
        assert (!internal.enableHorizontalClassMerging);
        assert (!internal.enableVerticalClassMerging);
        assert (!internal.enableClassStaticizer);
        assert (!internal.enableEnumValueOptimization);
        assert (!internal.outline.enabled);
        assert (!internal.enableValuePropagation);
        assert (!internal.enableLambdaMerging);
        assert (!internal.enableTreeShakingOfLibraryMethodOverrides);
        internal.enableNonNullTracking = false;
        internal.enableDesugaring = this.getEnableDesugaring();
        internal.encodeChecksums = this.getIncludeClassesChecksum();
        internal.dexClassChecksumFilter = this.getDexClassChecksumFilter();
        internal.enableInheritanceClassInDexDistributor = this.isOptimizeMultidexForLinearAlloc();
        internal.desugaredLibraryConfiguration = this.libraryConfiguration;
        internal.desugaredLibraryKeepRuleConsumer = this.desugaredLibraryKeepRuleConsumer;
        assert (internal.assertionsConfiguration == null);
        internal.assertionsConfiguration = new AssertionConfigurationWithDefault(AssertionsConfiguration.AssertionTransformation.DISABLE, this.getAssertionsConfiguration());
        return internal;
    }

    @Keep
    public static class Builder
    extends BaseCompilerCommand.Builder<D8Command, Builder> {
        private boolean intermediate = false;
        private DesugarGraphConsumer desugarGraphConsumer = null;
        private StringConsumer desugaredLibraryKeepRuleConsumer = null;

        private Builder() {
            this(new DefaultD8DiagnosticsHandler());
        }

        private Builder(DiagnosticsHandler diagnosticsHandler) {
            super(diagnosticsHandler);
        }

        private Builder(AndroidApp app) {
            super(app);
        }

        @Override
        public Builder addDexProgramData(byte[] data2, Origin origin) {
            this.guard(() -> this.getAppBuilder().addDexProgramData(data2, origin));
            return this.self();
        }

        @Override
        public Builder addClasspathFiles(Path ... files) {
            return (Builder)super.addClasspathFiles(files);
        }

        @Override
        public Builder addClasspathFiles(Collection<Path> files) {
            return (Builder)super.addClasspathFiles(files);
        }

        @Override
        public Builder addClasspathResourceProvider(ClassFileResourceProvider provider) {
            return (Builder)super.addClasspathResourceProvider(provider);
        }

        public Builder setIntermediate(boolean value) {
            this.intermediate = value;
            return this.self();
        }

        public Builder setDesugaredLibraryKeepRuleConsumer(StringConsumer keepRuleConsumer) {
            this.desugaredLibraryKeepRuleConsumer = keepRuleConsumer;
            return this.self();
        }

        public DesugarGraphConsumer getDesugarGraphConsumer() {
            return this.desugarGraphConsumer;
        }

        public Builder setDesugarGraphConsumer(DesugarGraphConsumer desugarGraphConsumer) {
            this.desugarGraphConsumer = desugarGraphConsumer;
            return this.self();
        }

        @Override
        Builder self() {
            return this;
        }

        @Override
        CompilationMode defaultCompilationMode() {
            return CompilationMode.DEBUG;
        }

        @Override
        void validate() {
            Reporter reporter = this.getReporter();
            if (this.getProgramConsumer() instanceof ClassFileConsumer) {
                reporter.error("D8 does not support compiling to Java class files");
            }
            if (this.getAppBuilder().hasMainDexList()) {
                if (this.intermediate) {
                    reporter.error("Option --main-dex-list cannot be used with --intermediate");
                }
                if (this.getProgramConsumer() instanceof DexFilePerClassFileConsumer) {
                    reporter.error("Option --main-dex-list cannot be used with --file-per-class");
                }
            } else if (this.getMainDexListConsumer() != null) {
                reporter.error("Option --main-dex-list-output require --main-dex-list");
            }
            if (this.getMinApiLevel() >= AndroidApiLevel.L.getLevel() && (this.getMainDexListConsumer() != null || this.getAppBuilder().hasMainDexList())) {
                reporter.error("D8 does not support main-dex inputs and outputs when compiling to API level " + AndroidApiLevel.L.getLevel() + " and above");
            }
            if (this.hasDesugaredLibraryConfiguration() && this.getDisableDesugaring()) {
                reporter.error("Using desugared library configuration requires desugaring to be enabled");
            }
            super.validate();
        }

        @Override
        D8Command makeCommand() {
            if (this.isPrintHelp() || this.isPrintVersion()) {
                return new D8Command(this.isPrintHelp(), this.isPrintVersion());
            }
            this.intermediate |= this.getProgramConsumer() instanceof DexFilePerClassFileConsumer;
            DexItemFactory factory = new DexItemFactory();
            DesugaredLibraryConfiguration libraryConfiguration = this.getDesugaredLibraryConfiguration(factory, false);
            return new D8Command(this.getAppBuilder().build(), this.getMode(), this.getProgramConsumer(), this.getMainDexListConsumer(), this.getMinApiLevel(), this.getReporter(), !this.getDisableDesugaring(), this.intermediate, this.isOptimizeMultidexForLinearAlloc(), this.getIncludeClassesChecksum(), this.getDexClassChecksumFilter(), this.getDesugarGraphConsumer(), this.desugaredLibraryKeepRuleConsumer, libraryConfiguration, this.getAssertionsConfiguration(), factory);
        }
    }

    private static class DefaultD8DiagnosticsHandler
    implements DiagnosticsHandler {
        private DefaultD8DiagnosticsHandler() {
        }

        @Override
        public void error(Diagnostic error) {
            DexFileOverflowDiagnostic overflowDiagnostic;
            if (error instanceof DexFileOverflowDiagnostic && !(overflowDiagnostic = (DexFileOverflowDiagnostic)error).hasMainDexSpecification()) {
                DiagnosticsHandler.super.error(new StringDiagnostic(overflowDiagnostic.getDiagnosticMessage() + ". Try supplying a main-dex list"));
                return;
            }
            DiagnosticsHandler.super.error(error);
        }
    }

    private static class ClasspathInputOrigin
    extends BaseCommand.InputFileOrigin {
        public ClasspathInputOrigin(Path file) {
            super("classpath input", file);
        }
    }
}

