/*
 * Decompiled with CFR 0.152.
 */
package shadow.bundletool.com.android.utils;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import shadow.bundletool.com.android.utils.StringHelper;

public class StringHelperWindows
extends StringHelper {
    public static List<String> splitCommandLine(String commandLine) {
        ArrayList commands = Lists.newArrayList();
        boolean quoting = false;
        boolean escapingQuotes = false;
        boolean escapingOthers = false;
        int commandStart = 0;
        int length = commandLine.length();
        for (int i3 = 0; i3 < length; ++i3) {
            char c3 = commandLine.charAt(i3);
            if (c3 == '\"' && !escapingQuotes) {
                quoting = !quoting;
                continue;
            }
            if (escapingQuotes) {
                escapingQuotes = false;
            } else if (c3 == '\\') {
                escapingQuotes = true;
                continue;
            }
            if (escapingOthers) {
                escapingOthers = false;
                continue;
            }
            if (c3 == '^') {
                escapingOthers = true;
                continue;
            }
            if (quoting || commandLine.charAt(i3) != '&') continue;
            commands.add(commandLine.substring(commandStart, i3));
            if (commandLine.length() <= ++i3 || commandLine.charAt(i3) == '&') {
                // empty if block
            }
            commandStart = ++i3;
        }
        if (commandStart < length) {
            commands.add(commandLine.substring(commandStart));
        }
        return commands;
    }

    public static List<String> tokenizeCommandLineToEscaped(String commandLine) {
        return StringHelperWindows.tokenizeCommandLine(commandLine, true);
    }

    public static List<String> tokenizeCommandLineToRaw(String commandLine) {
        return StringHelperWindows.tokenizeCommandLine(commandLine, false);
    }

    private static List<String> tokenizeCommandLine(String commandLine, boolean returnEscaped) {
        ArrayList tokens = Lists.newArrayList();
        StringBuilder token = new StringBuilder();
        boolean quoting = false;
        boolean escapingQuotes = false;
        boolean escapingOthers = false;
        boolean skipping = true;
        for (int i3 = 0; i3 < commandLine.length(); ++i3) {
            char c3 = commandLine.charAt(i3);
            if (skipping) {
                if (Character.isWhitespace(c3)) continue;
                skipping = false;
            }
            if (!(!quoting && Character.isWhitespace(c3) || returnEscaped)) {
                token.append(c3);
            }
            if (c3 == '\"') {
                if (returnEscaped) {
                    for (int j3 = token.length() - 2; j3 >= 0 && token.charAt(j3) == '\\' && token.charAt(j3 + 1) == '\\'; j3 -= 2) {
                        token.deleteCharAt(j3);
                    }
                }
                if (escapingQuotes) {
                    if (returnEscaped) {
                        token.deleteCharAt(token.length() - 1);
                    }
                } else {
                    quoting = !quoting;
                    continue;
                }
            }
            if (escapingQuotes) {
                escapingQuotes = false;
            } else if (c3 == '\\') {
                escapingQuotes = true;
            }
            if (escapingOthers) {
                escapingOthers = false;
                if (c3 == '\n') {
                    continue;
                }
            } else if (!quoting && c3 == '^') {
                escapingOthers = true;
                continue;
            }
            if (!quoting && Character.isWhitespace(c3)) {
                skipping = true;
                if (token.length() > 0) {
                    tokens.add(token.toString());
                }
                token.setLength(0);
                continue;
            }
            if (!returnEscaped) continue;
            token.append(c3);
        }
        if (token.length() > 0) {
            tokens.add(token.toString());
        }
        return tokens;
    }
}

