/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.build.bundletool.mergers;

import com.android.aapt.Resources;
import com.android.bundle.Devices;
import com.android.bundle.Targeting;
import com.android.tools.build.bundletool.device.ApkMatcher;
import com.android.tools.build.bundletool.mergers.DexMerger;
import com.android.tools.build.bundletool.mergers.MergingUtils;
import com.android.tools.build.bundletool.mergers.ResourceTableMerger;
import com.android.tools.build.bundletool.model.AndroidManifest;
import com.android.tools.build.bundletool.model.BundleMetadata;
import com.android.tools.build.bundletool.model.BundleModule;
import com.android.tools.build.bundletool.model.BundleModuleName;
import com.android.tools.build.bundletool.model.FileSystemModuleEntry;
import com.android.tools.build.bundletool.model.InputStreamSupplier;
import com.android.tools.build.bundletool.model.ModuleEntry;
import com.android.tools.build.bundletool.model.ModuleSplit;
import com.android.tools.build.bundletool.model.ShardedSystemSplits;
import com.android.tools.build.bundletool.model.SuffixManager;
import com.android.tools.build.bundletool.model.ZipPath;
import com.android.tools.build.bundletool.model.exceptions.CommandExecutionException;
import com.android.tools.build.bundletool.model.utils.files.BufferedIo;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicates;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.ImmutableCollection;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.ListMultimap;
import com.google.common.collect.SetMultimap;
import com.google.common.io.ByteStreams;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class ModuleSplitsToShardMerger {
    private final DexMerger dexMerger;
    private final Path globalTempDir;

    public ModuleSplitsToShardMerger(DexMerger dexMerger, Path globalTempDir) {
        this.dexMerger = dexMerger;
        this.globalTempDir = globalTempDir;
    }

    public ImmutableList<ModuleSplit> merge(ImmutableList<ImmutableList<ModuleSplit>> unfusedShards, BundleMetadata bundleMetadata) {
        HashMap<ImmutableSet<ModuleEntry>, ImmutableList<Path>> mergedDexCache = new HashMap<ImmutableSet<ModuleEntry>, ImmutableList<Path>>();
        ImmutableList.Builder shards = ImmutableList.builder();
        for (ImmutableList unfusedShard : unfusedShards) {
            shards.add((Object)this.mergeSingleShard((ImmutableCollection<ModuleSplit>)unfusedShard, bundleMetadata, mergedDexCache));
        }
        return shards.build();
    }

    public ShardedSystemSplits mergeSystemShard(ImmutableCollection<ModuleSplit> splits, ImmutableSet<BundleModuleName> modulesToFuse, BundleMetadata bundleMetadata, Devices.DeviceSpec deviceSpec) {
        ApkMatcher deviceSpecMatcher = new ApkMatcher(deviceSpec);
        ImmutableSet splitsForTheSystemApk = (ImmutableSet)splits.stream().filter(split -> modulesToFuse.contains((Object)split.getModuleName())).filter(split -> !split.getApkTargeting().hasLanguageTargeting() || deviceSpecMatcher.matchesModuleSplitByTargeting((ModuleSplit)split)).collect(ImmutableSet.toImmutableSet());
        ModuleSplit fusedSplit = this.mergeSingleShard((ImmutableCollection<ModuleSplit>)splitsForTheSystemApk, bundleMetadata, new HashMap<ImmutableSet<ModuleEntry>, ImmutableList<Path>>());
        ImmutableList otherSplits = (ImmutableList)splits.stream().filter(Predicates.not(arg_0 -> ((ImmutableSet)splitsForTheSystemApk).contains(arg_0))).collect(Collectors.groupingBy(ModuleSplit::getModuleName)).values().stream().flatMap(ModuleSplitsToShardMerger::writeSplitIdInManifestHavingSameModule).collect(ImmutableList.toImmutableList());
        return ShardedSystemSplits.builder().setSystemImageSplit(fusedSplit).setAdditionalSplits((ImmutableList<ModuleSplit>)otherSplits).build();
    }

    @VisibleForTesting
    ModuleSplit mergeSingleShard(ImmutableCollection<ModuleSplit> splitsOfShard, BundleMetadata bundleMetadata, Map<ImmutableSet<ModuleEntry>, ImmutableList<Path>> mergedDexCache) {
        ArrayListMultimap dexFilesToMergeByModule = ArrayListMultimap.create();
        HashMultimap androidManifestsToMergeByModule = HashMultimap.create();
        HashMap<ZipPath, ModuleEntry> mergedEntriesByPath = new HashMap<ZipPath, ModuleEntry>();
        Optional<Resources.ResourceTable> mergedResourceTable = Optional.empty();
        Targeting.ApkTargeting mergedSplitTargeting = Targeting.ApkTargeting.getDefaultInstance();
        for (ModuleSplit split : splitsOfShard) {
            mergedResourceTable = this.mergeResourceTables(mergedResourceTable, split);
            mergedSplitTargeting = this.mergeSplitTargetings(mergedSplitTargeting, split);
            androidManifestsToMergeByModule.put((Object)split.getModuleName(), (Object)split.getAndroidManifest());
            for (ModuleEntry entry : split.getEntries()) {
                if (entry.getPath().startsWith(BundleModule.DEX_DIRECTORY) && !entry.isDirectory()) {
                    dexFilesToMergeByModule.put((Object)split.getModuleName(), (Object)entry);
                    continue;
                }
                ModuleSplitsToShardMerger.mergeEntries(mergedEntriesByPath, split, entry);
            }
        }
        AndroidManifest mergedAndroidManifest = this.mergeAndroidManifests((SetMultimap<BundleModuleName, AndroidManifest>)androidManifestsToMergeByModule);
        Collection<ModuleEntry> mergedDexFiles = this.mergeDexFilesAndCache((ListMultimap<BundleModuleName, ModuleEntry>)dexFilesToMergeByModule, bundleMetadata, mergedAndroidManifest, mergedDexCache);
        ImmutableList<String> fusedModuleNames = ModuleSplitsToShardMerger.getUniqueModuleNames(splitsOfShard);
        AndroidManifest finalAndroidManifest = mergedAndroidManifest.toEditor().setFusedModuleNames(fusedModuleNames).save();
        return this.buildShard(mergedEntriesByPath.values(), mergedDexFiles, mergedSplitTargeting, finalAndroidManifest, mergedResourceTable);
    }

    public ImmutableList<ModuleSplit> mergeApex(ImmutableList<ImmutableList<ModuleSplit>> unfusedShards) {
        return (ImmutableList)unfusedShards.stream().map(this::mergeSingleApexShard).collect(ImmutableList.toImmutableList());
    }

    @VisibleForTesting
    ModuleSplit mergeSingleApexShard(ImmutableList<ModuleSplit> splitsOfShard) {
        Preconditions.checkState((!splitsOfShard.isEmpty() ? 1 : 0) != 0, (Object)"A shard is made of at least one split.");
        HashMap<ZipPath, ModuleEntry> mergedEntriesByPath = new HashMap<ZipPath, ModuleEntry>();
        Targeting.ApkTargeting splitTargeting = Targeting.ApkTargeting.getDefaultInstance();
        for (ModuleSplit split : splitsOfShard) {
            splitTargeting = splitTargeting.hasMultiAbiTargeting() ? splitTargeting : split.getApkTargeting();
            for (ModuleEntry entry : split.getEntries()) {
                ModuleSplitsToShardMerger.mergeEntries(mergedEntriesByPath, split, entry);
            }
        }
        ModuleSplit shard = this.buildShard(mergedEntriesByPath.values(), (Collection<ModuleEntry>)ImmutableList.of(), splitTargeting, ((ModuleSplit)splitsOfShard.get(0)).getAndroidManifest(), Optional.empty());
        return shard.toBuilder().setApexConfig(((ModuleSplit)splitsOfShard.get(0)).getApexConfig().get()).build();
    }

    private ModuleSplit buildShard(Collection<ModuleEntry> entriesByPath, Collection<ModuleEntry> mergedDexFiles, Targeting.ApkTargeting splitTargeting, AndroidManifest androidManifest, Optional<Resources.ResourceTable> mergedResourceTable) {
        ImmutableList entries = ImmutableList.builder().addAll(entriesByPath).addAll(mergedDexFiles).build();
        ModuleSplit.Builder shard = ModuleSplit.builder().setAndroidManifest(androidManifest).setEntries((List<ModuleEntry>)entries).setApkTargeting(splitTargeting).setSplitType(ModuleSplit.SplitType.STANDALONE).setMasterSplit(false).setModuleName(BundleModuleName.BASE_MODULE_NAME).setVariantTargeting(Targeting.VariantTargeting.getDefaultInstance());
        mergedResourceTable.ifPresent(shard::setResourceTable);
        return shard.build();
    }

    private AndroidManifest mergeAndroidManifests(SetMultimap<BundleModuleName, AndroidManifest> manifestsToMergeByModule) {
        return ModuleSplitsToShardMerger.getOnlyBaseAndroidManifest(manifestsToMergeByModule);
    }

    private Collection<ModuleEntry> mergeDexFilesAndCache(ListMultimap<BundleModuleName, ModuleEntry> dexFilesToMergeByModule, BundleMetadata bundleMetadata, AndroidManifest androidManifest, Map<ImmutableSet<ModuleEntry>, ImmutableList<Path>> mergedDexCache) {
        if (dexFilesToMergeByModule.keySet().size() <= 1) {
            return dexFilesToMergeByModule.values();
        }
        ImmutableList dexEntries = ImmutableList.copyOf((Collection)dexFilesToMergeByModule.values());
        ImmutableList mergedDexFiles = mergedDexCache.computeIfAbsent((ImmutableSet<ModuleEntry>)ImmutableSet.copyOf((Collection)dexEntries), key -> this.mergeDexFiles((List<ModuleEntry>)dexEntries, bundleMetadata, androidManifest));
        return (Collection)mergedDexFiles.stream().map(filePath -> FileSystemModuleEntry.ofFile(BundleModule.DEX_DIRECTORY.resolve(filePath.getFileName().toString()), filePath)).collect(ImmutableList.toImmutableList());
    }

    private ImmutableList<Path> mergeDexFiles(List<ModuleEntry> dexEntries, BundleMetadata bundleMetadata, AndroidManifest androidManifest) {
        try {
            Path dexOriginalDir = Files.createTempDirectory(this.globalTempDir, "dex-merging-in", new FileAttribute[0]);
            Path dexMergedDir = Files.createTempDirectory(this.globalTempDir, "dex-merging-out", new FileAttribute[0]);
            Optional<Path> mainDexListFile = this.writeMainDexListFileIfPresent(bundleMetadata);
            ImmutableList<Path> dexFiles = ModuleSplitsToShardMerger.writeModuleEntriesToIndexedFiles(dexEntries, dexOriginalDir, ".dex");
            ImmutableList<Path> mergedDexFiles = this.dexMerger.merge(dexFiles, dexMergedDir, mainDexListFile, androidManifest.getEffectiveApplicationDebuggable(), androidManifest.getEffectiveMinSdkVersion());
            return mergedDexFiles;
        }
        catch (IOException e3) {
            throw CommandExecutionException.builder().withCause(e3).withMessage("I/O error while merging dex files.").build();
        }
    }

    private static void mergeEntries(Map<ZipPath, ModuleEntry> mergedEntriesByPath, ModuleSplit split, ModuleEntry entry) {
        ModuleEntry existingEntry = mergedEntriesByPath.putIfAbsent(entry.getPath(), entry);
        Preconditions.checkState((existingEntry == null || ModuleEntry.equal(existingEntry, entry) ? 1 : 0) != 0, (String)"Module '%s' and some other module(s) contain entry '%s' with different contents.", (Object)split.getModuleName(), (Object)entry.getPath());
    }

    private Optional<Resources.ResourceTable> mergeResourceTables(Optional<Resources.ResourceTable> merged, ModuleSplit split) {
        if (!merged.isPresent()) {
            return split.getResourceTable();
        }
        if (split.getResourceTable().isPresent()) {
            try {
                return Optional.of(new ResourceTableMerger().merge(merged.get(), split.getResourceTable().get()));
            }
            catch (CommandExecutionException | IllegalStateException e3) {
                throw CommandExecutionException.builder().withCause(e3).withMessage("Failed to merge with resource table of module '%s'.", split.getModuleName()).build();
            }
        }
        return merged;
    }

    private Targeting.ApkTargeting mergeSplitTargetings(Targeting.ApkTargeting merged, ModuleSplit split) {
        try {
            return MergingUtils.mergeShardTargetings(merged, split.getApkTargeting());
        }
        catch (CommandExecutionException | IllegalStateException e3) {
            throw CommandExecutionException.builder().withCause(e3).withMessage("Failed to merge with targeting of module '%s'.", split.getModuleName()).build();
        }
    }

    private Optional<Path> writeMainDexListFileIfPresent(BundleMetadata bundleMetadata) throws IOException {
        Optional<InputStreamSupplier> mainDexListFileData = bundleMetadata.getFileData("com.android.tools.build.bundletool", "mainDexList.txt");
        if (!mainDexListFileData.isPresent()) {
            return Optional.empty();
        }
        Path mainDexListFile = Files.createTempFile(this.globalTempDir, "mainDexList", ".txt", new FileAttribute[0]);
        try (InputStream inputStream = mainDexListFileData.get().get();){
            Files.copy(inputStream, mainDexListFile, StandardCopyOption.REPLACE_EXISTING);
        }
        return Optional.of(mainDexListFile);
    }

    private static AndroidManifest getOnlyBaseAndroidManifest(SetMultimap<BundleModuleName, AndroidManifest> manifestsToMergeByModule) {
        Set baseManifests = manifestsToMergeByModule.get((Object)BundleModuleName.BASE_MODULE_NAME);
        if (baseManifests.size() != 1) {
            throw CommandExecutionException.builder().withMessage("Expected exactly one base module manifest, but found %d.", baseManifests.size()).build();
        }
        return (AndroidManifest)Iterables.getOnlyElement((Iterable)baseManifests);
    }

    private static ImmutableList<String> getUniqueModuleNames(ImmutableCollection<ModuleSplit> splits) {
        return (ImmutableList)splits.stream().map(ModuleSplit::getModuleName).map(BundleModuleName::getName).distinct().collect(ImmutableList.toImmutableList());
    }

    private static ImmutableList<Path> writeModuleEntriesToIndexedFiles(List<ModuleEntry> moduleEntries, Path toDirectory, String fileSuffix) throws IOException {
        ImmutableList.Builder files = ImmutableList.builder();
        for (int i3 = 0; i3 < moduleEntries.size(); ++i3) {
            Path fileName = toDirectory.resolve(i3 + fileSuffix);
            ModuleSplitsToShardMerger.writeModuleEntryToFile(moduleEntries.get(i3), fileName);
            files.add((Object)fileName);
        }
        return files.build();
    }

    private static void writeModuleEntryToFile(ModuleEntry entry, Path toFile) throws IOException {
        try (InputStream is = entry.getContent();
             OutputStream os = BufferedIo.outputStream(toFile);){
            ByteStreams.copy((InputStream)is, (OutputStream)os);
        }
    }

    private static Stream<ModuleSplit> writeSplitIdInManifestHavingSameModule(List<ModuleSplit> splits) {
        Preconditions.checkState((splits.stream().map(ModuleSplit::getModuleName).distinct().count() == 1L ? 1 : 0) != 0);
        SuffixManager suffixManager = new SuffixManager();
        return splits.stream().map(split -> split.writeSplitIdInManifest(suffixManager.createSuffix((ModuleSplit)split)));
    }
}

