/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8.optimize;

import com.android.tools.r8.com.google.common.collect.ImmutableSet;
import com.android.tools.r8.com.google.common.collect.Sets;
import com.android.tools.r8.graph.AppView;
import com.android.tools.r8.graph.DexClass;
import com.android.tools.r8.graph.DexEncodedField;
import com.android.tools.r8.graph.DexEncodedMethod;
import com.android.tools.r8.graph.DexField;
import com.android.tools.r8.graph.DexMethod;
import com.android.tools.r8.graph.DexProgramClass;
import com.android.tools.r8.graph.DexType;
import com.android.tools.r8.graph.GraphLense;
import com.android.tools.r8.ir.code.Invoke;
import com.android.tools.r8.ir.optimize.Inliner;
import com.android.tools.r8.optimize.MemberRebindingLense;
import com.android.tools.r8.shaking.Enqueuer;
import com.android.tools.r8.utils.InternalOptions;
import java.util.Collections;
import java.util.IdentityHashMap;
import java.util.Map;
import java.util.Set;
import java.util.function.BiFunction;
import java.util.function.Function;

public class MemberRebindingAnalysis {
    private final Enqueuer.AppInfoWithLiveness appInfo;
    private final GraphLense lense;
    private final InternalOptions options;
    private final MemberRebindingLense.Builder builder;

    public MemberRebindingAnalysis(AppView<Enqueuer.AppInfoWithLiveness> appView, InternalOptions options) {
        assert (appView.graphLense().isContextFreeForMethods());
        this.appInfo = appView.appInfo();
        this.lense = appView.graphLense();
        this.options = options;
        this.builder = MemberRebindingLense.builder(this.appInfo);
    }

    private DexMethod validTargetFor(DexMethod target, DexMethod original) {
        DexClass clazz = this.appInfo.definitionFor(target.getHolder());
        assert (clazz != null);
        if (!clazz.isLibraryClass()) {
            return target;
        }
        DexType newHolder = clazz.isInterface() ? this.firstLibraryClassForInterfaceTarget(target, original.getHolder(), DexClass::lookupMethod) : this.firstLibraryClass(target.getHolder(), original.getHolder());
        return this.appInfo.dexItemFactory.createMethod(newHolder, original.proto, original.name);
    }

    private DexField validTargetFor(DexField target, DexField original, BiFunction<DexClass, DexField, DexEncodedField> lookup) {
        DexClass clazz = this.appInfo.definitionFor(target.getHolder());
        assert (clazz != null);
        if (!clazz.isLibraryClass()) {
            return target;
        }
        DexType newHolder = clazz.isInterface() ? this.firstLibraryClassForInterfaceTarget(target, original.getHolder(), lookup) : this.firstLibraryClass(target.getHolder(), original.getHolder());
        return this.appInfo.dexItemFactory.createField(newHolder, original.type, original.name);
    }

    private <T> DexType firstLibraryClassForInterfaceTarget(T target, DexType current, BiFunction<DexClass, T, ?> lookup) {
        DexType matchingSuper;
        DexClass clazz = this.appInfo.definitionFor(current);
        Object potential = lookup.apply(clazz, (DexClass)target);
        if (potential != null) {
            return current;
        }
        if (clazz.superType != null && (matchingSuper = this.firstLibraryClassForInterfaceTarget(target, clazz.superType, lookup)) != null) {
            return clazz.isLibraryClass() ? current : matchingSuper;
        }
        for (DexType iface : clazz.interfaces.values) {
            DexType matchingIface = this.firstLibraryClassForInterfaceTarget(target, iface, lookup);
            if (matchingIface == null) continue;
            return clazz.isLibraryClass() ? current : matchingIface;
        }
        return null;
    }

    private DexType firstLibraryClass(DexType top, DexType bottom) {
        assert (this.appInfo.definitionFor(top).isLibraryClass());
        DexClass searchClass = this.appInfo.definitionFor(bottom);
        while (!searchClass.isLibraryClass()) {
            searchClass = this.appInfo.definitionFor(searchClass.superType);
        }
        return searchClass.type;
    }

    private DexEncodedMethod classLookup(DexMethod method) {
        return this.appInfo.resolveMethodOnClass(method.getHolder(), method).asResultOfResolve();
    }

    private DexEncodedMethod interfaceLookup(DexMethod method) {
        return this.appInfo.resolveMethodOnInterface(method.getHolder(), method).asResultOfResolve();
    }

    private DexEncodedMethod anyLookup(DexMethod method) {
        return this.appInfo.resolveMethod(method.getHolder(), method).asResultOfResolve();
    }

    private void computeMethodRebinding(Map<DexMethod, Set<DexEncodedMethod>> methodsWithContexts, Function<DexMethod, DexEncodedMethod> lookupTarget, Invoke.Type invokeType) {
        for (DexMethod method : methodsWithContexts.keySet()) {
            DexEncodedMethod target;
            DexClass originalClass;
            if (!method.getHolder().isClassType() || (originalClass = this.appInfo.definitionFor(method.holder)) == null || originalClass.isLibraryClass() || (target = lookupTarget.apply(method)) == null || target.method == method) continue;
            DexClass targetClass = this.appInfo.definitionFor(target.method.holder);
            if (this.needsBridgeForInterfaceMethod(originalClass, targetClass, invokeType)) {
                target = this.insertBridgeForInterfaceMethod(method, target, originalClass.asProgramClass(), targetClass, lookupTarget);
            }
            DexEncodedMethod finalTarget = target;
            Set<DexEncodedMethod> contexts = methodsWithContexts.get(method);
            if (contexts.stream().anyMatch(context -> this.mayNeedBridgeForVisibility(context.method.getHolder(), finalTarget))) {
                target = this.insertBridgeForVisibilityIfNeeded(method, target, originalClass, targetClass, lookupTarget);
            }
            this.builder.map(method, this.lense.lookupMethod(this.validTargetFor(target.method, method)));
        }
    }

    private boolean needsBridgeForInterfaceMethod(DexClass originalClass, DexClass targetClass, Invoke.Type invokeType) {
        return this.options.isGeneratingClassFiles() && invokeType == Invoke.Type.SUPER && targetClass != originalClass && targetClass.accessFlags.isInterface();
    }

    private DexEncodedMethod insertBridgeForInterfaceMethod(DexMethod method, DexEncodedMethod target, DexProgramClass originalClass, DexClass targetClass, Function<DexMethod, DexEncodedMethod> lookupTarget) {
        DexProgramClass bridgeHolder = this.findHolderForInterfaceMethodBridge(originalClass, targetClass.type);
        assert (bridgeHolder != null);
        assert (bridgeHolder != targetClass);
        DexEncodedMethod bridgeMethod = target.toForwardingMethod(bridgeHolder, this.appInfo.dexItemFactory);
        bridgeHolder.addMethod(bridgeMethod);
        assert (lookupTarget.apply(method) == bridgeMethod);
        return bridgeMethod;
    }

    private DexProgramClass findHolderForInterfaceMethodBridge(DexProgramClass clazz, DexType iface) {
        if (clazz.accessFlags.isInterface()) {
            return clazz;
        }
        DexClass superClass = this.appInfo.definitionFor(clazz.superType);
        if (superClass == null || superClass.isLibraryClass() || !superClass.type.isSubtypeOf(iface, this.appInfo)) {
            return clazz;
        }
        return this.findHolderForInterfaceMethodBridge(superClass.asProgramClass(), iface);
    }

    private boolean mayNeedBridgeForVisibility(DexType context, DexEncodedMethod method) {
        DexType holderType = method.method.getHolder();
        DexClass holder = this.appInfo.definitionFor(holderType);
        if (holder == null) {
            return false;
        }
        Inliner.ConstraintWithTarget classVisibility = Inliner.ConstraintWithTarget.deriveConstraint(context, holderType, holder.accessFlags, this.appInfo);
        Inliner.ConstraintWithTarget methodVisibility = Inliner.ConstraintWithTarget.deriveConstraint(context, holderType, method.accessFlags, this.appInfo);
        return classVisibility == Inliner.ConstraintWithTarget.NEVER && methodVisibility != Inliner.ConstraintWithTarget.NEVER;
    }

    private DexEncodedMethod insertBridgeForVisibilityIfNeeded(DexMethod method, DexEncodedMethod target, DexClass originalClass, DexClass targetClass, Function<DexMethod, DexEncodedMethod> lookupTarget) {
        String packageDescriptor;
        String string = packageDescriptor = originalClass.accessFlags.isPublic() ? null : method.holder.getPackageDescriptor();
        if (packageDescriptor == null || !packageDescriptor.equals(targetClass.type.getPackageDescriptor())) {
            DexProgramClass bridgeHolder = this.findHolderForVisibilityBridge(originalClass, targetClass, packageDescriptor);
            assert (bridgeHolder != null);
            DexEncodedMethod bridgeMethod = target.toForwardingMethod(bridgeHolder, this.appInfo.dexItemFactory);
            bridgeHolder.addMethod(bridgeMethod);
            assert (lookupTarget.apply(method) == bridgeMethod);
            return bridgeMethod;
        }
        return target;
    }

    private DexProgramClass findHolderForVisibilityBridge(DexClass originalClass, DexClass targetClass, String packageDescriptor) {
        if (originalClass == targetClass || originalClass.isLibraryClass()) {
            return null;
        }
        DexProgramClass newHolder = null;
        if (originalClass.superType.isSubtypeOf(targetClass.type, this.appInfo)) {
            DexClass superClass = this.appInfo.definitionFor(originalClass.superType);
            newHolder = this.findHolderForVisibilityBridge(superClass, targetClass, packageDescriptor);
        } else {
            for (DexType iface : originalClass.interfaces.values) {
                if (!iface.isSubtypeOf(targetClass.type, this.appInfo)) continue;
                DexClass interfaceClass = this.appInfo.definitionFor(iface);
                newHolder = this.findHolderForVisibilityBridge(interfaceClass, targetClass, packageDescriptor);
            }
        }
        if (newHolder != null) {
            return newHolder;
        }
        if (originalClass.accessFlags.isPublic() || originalClass.type.getPackageDescriptor().equals(packageDescriptor)) {
            return originalClass.asProgramClass();
        }
        return null;
    }

    private void computeFieldRebinding(Map<DexField, Set<DexEncodedMethod>> fieldsWithContexts, BiFunction<DexType, DexField, DexEncodedField> lookup, BiFunction<DexClass, DexField, DexEncodedField> lookupTargetOnClass) {
        for (DexField field : fieldsWithContexts.keySet()) {
            DexEncodedField target = lookup.apply(field.getHolder(), field);
            Set<DexEncodedMethod> contexts = fieldsWithContexts.get(field);
            if (target == null || target.field == field || !contexts.stream().allMatch(context -> this.isVisibleFromOriginalContext(context.method.getHolder(), target))) continue;
            this.builder.map(field, this.lense.lookupField(this.validTargetFor(target.field, field, lookupTargetOnClass)));
        }
    }

    private boolean isVisibleFromOriginalContext(DexType context, DexEncodedField field) {
        DexType holderType = field.field.getHolder();
        DexClass holder = this.appInfo.definitionFor(holderType);
        if (holder == null) {
            return false;
        }
        Inliner.ConstraintWithTarget classVisibility = Inliner.ConstraintWithTarget.deriveConstraint(context, holderType, holder.accessFlags, this.appInfo);
        if (classVisibility == Inliner.ConstraintWithTarget.NEVER) {
            return false;
        }
        Inliner.ConstraintWithTarget fieldVisibility = Inliner.ConstraintWithTarget.deriveConstraint(context, holderType, field.accessFlags, this.appInfo);
        return fieldVisibility != Inliner.ConstraintWithTarget.NEVER;
    }

    private Map<DexField, Set<DexEncodedMethod>> mergeFieldAccessContexts(Map<DexField, Set<DexEncodedMethod>> reads, Map<DexField, Set<DexEncodedMethod>> writes) {
        IdentityHashMap result = new IdentityHashMap();
        Sets.SetView<DexField> fields = Sets.union(reads.keySet(), writes.keySet());
        for (DexField field : fields) {
            Set contexts = Sets.newIdentityHashSet();
            contexts.addAll(reads.getOrDefault(field, ImmutableSet.of()));
            contexts.addAll(writes.getOrDefault(field, ImmutableSet.of()));
            result.put(field, contexts);
        }
        return Collections.unmodifiableMap(result);
    }

    public GraphLense run() {
        this.computeMethodRebinding(this.appInfo.virtualInvokes, this::classLookup, Invoke.Type.VIRTUAL);
        this.computeMethodRebinding(this.appInfo.interfaceInvokes, this::interfaceLookup, Invoke.Type.INTERFACE);
        this.computeMethodRebinding(this.appInfo.superInvokes, this::anyLookup, Invoke.Type.SUPER);
        this.computeMethodRebinding(this.appInfo.directInvokes, this::anyLookup, Invoke.Type.DIRECT);
        this.computeMethodRebinding(this.appInfo.staticInvokes, this::anyLookup, Invoke.Type.STATIC);
        this.computeFieldRebinding(this.mergeFieldAccessContexts(this.appInfo.staticFieldReads, this.appInfo.staticFieldWrites), this.appInfo::resolveFieldOn, DexClass::lookupField);
        this.computeFieldRebinding(this.mergeFieldAccessContexts(this.appInfo.instanceFieldReads, this.appInfo.instanceFieldWrites), this.appInfo::resolveFieldOn, DexClass::lookupField);
        return this.builder.build(this.lense);
    }
}

