/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8.ir.optimize.peepholes;

import com.android.tools.r8.ir.code.Instruction;
import com.android.tools.r8.ir.code.InstructionListIterator;
import com.android.tools.r8.ir.code.Load;
import com.android.tools.r8.ir.code.StackValue;
import com.android.tools.r8.ir.code.StackValues;
import com.android.tools.r8.ir.code.Store;
import com.android.tools.r8.ir.code.Swap;
import com.android.tools.r8.ir.optimize.peepholes.BasicBlockPeephole;
import com.android.tools.r8.ir.optimize.peepholes.Match;
import com.android.tools.r8.ir.optimize.peepholes.PeepholeHelper;
import com.android.tools.r8.ir.optimize.peepholes.PeepholeLayout;
import com.android.tools.r8.ir.optimize.peepholes.Point;
import com.android.tools.r8.ir.optimize.peepholes.Wildcard;
import java.util.List;

public class StoreSequenceLoadPeephole
implements BasicBlockPeephole {
    private Store store;
    private int stackHeight = 0;
    private final Point storeExp = new Point(i -> {
        if (!i.isStore() || i.asStore().src().getTypeLattice().isWide() || i.outValue().hasLocalInfo() || i.asStore().outValue().numberOfAllUsers() != 1) {
            return false;
        }
        this.store = i.asStore();
        this.stackHeight = 0;
        return true;
    });
    private final Wildcard seqExp = new Wildcard(i -> {
        if (this.stackHeight == 1 && i.isLoad() && i.asLoad().src() == this.store.outValue()) {
            return false;
        }
        this.stackHeight -= PeepholeHelper.numberOfValuesConsumedFromStack(i);
        if (this.stackHeight < 0) {
            this.store = null;
            return false;
        }
        this.stackHeight += PeepholeHelper.numberOfValuesPutOnStack(i);
        return true;
    });
    private final Point loadExp = new Point(i -> this.store != null && i.isLoad() && !i.asLoad().src().hasLocalInfo() && i.asLoad().src() == this.store.outValue());
    private final PeepholeLayout layout = PeepholeLayout.lookForward(this.storeExp, this.seqExp, this.loadExp);

    @Override
    public boolean match(InstructionListIterator it) {
        Match match = this.layout.test(it);
        if (match == null || this.store == null) {
            return false;
        }
        Store store = this.storeExp.get(match).asStore();
        List<Instruction> seq = this.seqExp.get(match);
        Load load = this.loadExp.get(match).asLoad();
        Instruction last = seq.get(seq.size() - 1);
        StackValue lastOut = null;
        if (last.outValue() instanceof StackValue) {
            lastOut = (StackValue)last.outValue();
        } else if (last.outValue() instanceof StackValues) {
            StackValue[] stackValues = ((StackValues)last.outValue()).getStackValues();
            lastOut = stackValues[stackValues.length - 1];
        }
        if (lastOut == null || lastOut.getTypeLattice().isWide()) {
            return false;
        }
        StackValue source = (StackValue)store.src();
        store.outValue().removeUser(load);
        load.outValue().replaceUsers(source);
        it.removeOrReplaceByDebugLocalRead();
        it.nextUntil(i -> i == load);
        StackValue swapLastOut = lastOut.duplicate(source.getHeight());
        StackValue swapSource = source.duplicate(swapLastOut.getHeight() + 1);
        source.replaceUsers(swapSource);
        lastOut.replaceUsers(swapLastOut);
        it.replaceCurrentInstruction(new Swap(swapLastOut, swapSource, source, lastOut));
        PeepholeHelper.resetNext(it, 2);
        return true;
    }

    @Override
    public boolean resetAfterMatch() {
        return false;
    }
}

