/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8.ir.optimize.peepholes;

import com.android.tools.r8.ir.code.Instruction;
import com.android.tools.r8.ir.code.InstructionListIterator;
import com.android.tools.r8.ir.code.Load;
import com.android.tools.r8.ir.code.Store;
import com.android.tools.r8.ir.optimize.peepholes.BasicBlockPeephole;
import com.android.tools.r8.ir.optimize.peepholes.Match;
import com.android.tools.r8.ir.optimize.peepholes.PeepholeHelper;
import com.android.tools.r8.ir.optimize.peepholes.PeepholeLayout;
import com.android.tools.r8.ir.optimize.peepholes.Point;

public class StoreLoadPeephole
implements BasicBlockPeephole {
    private final Point storeExp = new Point(PeepholeHelper.withoutLocalInfo(Instruction::isStore));
    private final Point loadExp = new Point(Instruction::isLoad);
    private final PeepholeLayout layout = PeepholeLayout.lookForward(this.storeExp, this.loadExp);

    @Override
    public boolean match(InstructionListIterator it) {
        Match match = this.layout.test(it);
        if (match == null) {
            return false;
        }
        Store store = this.storeExp.get(match).asStore();
        Load load = this.loadExp.get(match).asLoad();
        if (load.src() != store.outValue() || store.outValue().numberOfAllUsers() != 1) {
            return false;
        }
        load.outValue().replaceUsers(store.src());
        store.src().removeUser(store);
        load.src().removeUser(load);
        it.removeOrReplaceByDebugLocalRead();
        it.next();
        it.removeOrReplaceByDebugLocalRead();
        PeepholeHelper.resetNext(it, 1);
        return true;
    }

    @Override
    public boolean resetAfterMatch() {
        return false;
    }
}

