/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8.ir.optimize;

import com.android.tools.r8.com.google.common.collect.Sets;
import com.android.tools.r8.errors.CompilationError;
import com.android.tools.r8.graph.DebugLocalInfo;
import com.android.tools.r8.graph.DexClass;
import com.android.tools.r8.graph.DexDefinition;
import com.android.tools.r8.graph.DexEncodedField;
import com.android.tools.r8.graph.DexEncodedMethod;
import com.android.tools.r8.graph.DexField;
import com.android.tools.r8.graph.DexMethod;
import com.android.tools.r8.graph.DexReference;
import com.android.tools.r8.graph.DexType;
import com.android.tools.r8.ir.analysis.type.TypeAnalysis;
import com.android.tools.r8.ir.analysis.type.TypeLatticeElement;
import com.android.tools.r8.ir.code.BasicBlock;
import com.android.tools.r8.ir.code.ConstNumber;
import com.android.tools.r8.ir.code.FieldInstruction;
import com.android.tools.r8.ir.code.IRCode;
import com.android.tools.r8.ir.code.Instruction;
import com.android.tools.r8.ir.code.InstructionIterator;
import com.android.tools.r8.ir.code.InstructionListIterator;
import com.android.tools.r8.ir.code.InvokeMethod;
import com.android.tools.r8.ir.code.StaticGet;
import com.android.tools.r8.ir.code.Value;
import com.android.tools.r8.shaking.Enqueuer;
import com.android.tools.r8.shaking.ProguardMemberRule;
import java.util.ListIterator;
import java.util.Set;
import java.util.function.Predicate;

public class MemberValuePropagation {
    private final Enqueuer.AppInfoWithLiveness appInfo;

    public MemberValuePropagation(Enqueuer.AppInfoWithLiveness appInfo) {
        this.appInfo = appInfo;
    }

    private ProguardMemberRuleLookup lookupMemberRule(DexDefinition definition) {
        if (definition == null) {
            return null;
        }
        DexReference reference = definition.toReference();
        ProguardMemberRule rule = this.appInfo.noSideEffects.get(reference);
        if (rule != null) {
            return new ProguardMemberRuleLookup(RuleType.ASSUME_NO_SIDE_EFFECTS, rule);
        }
        rule = this.appInfo.assumedValues.get(reference);
        if (rule != null) {
            return new ProguardMemberRuleLookup(RuleType.ASSUME_VALUES, rule);
        }
        return null;
    }

    private Instruction constantReplacementFromProguardRule(ProguardMemberRule rule, IRCode code, Instruction instruction) {
        Instruction replacement = null;
        TypeLatticeElement typeLattice = instruction.outValue().getTypeLattice();
        if (rule != null && rule.hasReturnValue() && rule.getReturnValue().isSingleValue()) {
            replacement = MemberValuePropagation.createConstNumberReplacement(code, rule.getReturnValue().getSingleValue(), typeLattice, instruction.getLocalInfo());
        }
        if (replacement == null && rule != null && rule.hasReturnValue() && rule.getReturnValue().isField()) {
            DexField field = rule.getReturnValue().getField();
            assert (TypeLatticeElement.fromDexType(field.type, true, this.appInfo) == typeLattice);
            DexEncodedField staticField = this.appInfo.lookupStaticTarget(field.clazz, field);
            if (staticField != null) {
                Value value = code.createValue(typeLattice, instruction.getLocalInfo());
                replacement = staticField.getStaticValue().asConstInstruction(false, value);
            } else {
                throw new CompilationError(field.clazz.toSourceString() + "." + field.name.toString() + " used in assumevalues rule does not exist.");
            }
        }
        return replacement;
    }

    private static ConstNumber createConstNumberReplacement(IRCode code, long constant, TypeLatticeElement typeLattice, DebugLocalInfo debugLocalInfo) {
        assert (!typeLattice.isReference() || constant == 0L);
        Value returnedValue = code.createValue(typeLattice.isReference() ? TypeLatticeElement.NULL : typeLattice, debugLocalInfo);
        return new ConstNumber(returnedValue, constant);
    }

    private void setValueRangeFromProguardRule(ProguardMemberRule rule, Value value) {
        if (rule.hasReturnValue() && rule.getReturnValue().isValueRange()) {
            assert (!rule.getReturnValue().isSingleValue());
            value.setValueRange(rule.getReturnValue().getValueRange());
        }
    }

    private boolean tryConstantReplacementFromProguard(IRCode code, Set<Value> affectedValues, ListIterator<BasicBlock> blocks, InstructionListIterator iterator2, Instruction current, ProguardMemberRuleLookup lookup) {
        Instruction replacement = this.constantReplacementFromProguardRule(lookup.rule, code, current);
        if (replacement == null) {
            this.setValueRangeFromProguardRule(lookup.rule, current.outValue());
            return false;
        }
        affectedValues.add(replacement.outValue());
        if (lookup.type == RuleType.ASSUME_NO_SIDE_EFFECTS) {
            iterator2.replaceCurrentInstruction(replacement);
        } else {
            assert (lookup.type == RuleType.ASSUME_VALUES);
            if (current.outValue() != null) {
                assert (replacement.outValue() != null);
                current.outValue().replaceUsers(replacement.outValue());
            }
            replacement.setPosition(current.getPosition());
            if (current.getBlock().hasCatchHandlers()) {
                iterator2.split(code, blocks).listIterator().add(replacement);
            } else {
                iterator2.add(replacement);
            }
        }
        return true;
    }

    private void rewriteInvokeMethodWithConstantValues(IRCode code, DexType callingContext, Set<Value> affectedValues, ListIterator<BasicBlock> blocks, InstructionListIterator iterator2, InvokeMethod current) {
        DexMethod invokedMethod = current.getInvokedMethod();
        DexType invokedHolder = invokedMethod.getHolder();
        if (!invokedHolder.isClassType()) {
            return;
        }
        DexEncodedMethod definition = this.appInfo.lookup(current.getType(), invokedMethod, callingContext);
        ProguardMemberRuleLookup lookup = this.lookupMemberRule(definition);
        boolean invokeReplaced = false;
        if (lookup != null) {
            boolean outValueNullOrNotUsed;
            boolean bl = outValueNullOrNotUsed = current.outValue() == null || !current.outValue().isUsed();
            if (lookup.type == RuleType.ASSUME_NO_SIDE_EFFECTS && outValueNullOrNotUsed) {
                iterator2.removeOrReplaceByDebugLocalRead();
                invokeReplaced = true;
            } else if (!outValueNullOrNotUsed) {
                invokeReplaced = this.tryConstantReplacementFromProguard(code, affectedValues, blocks, iterator2, current, lookup);
            }
        }
        if (invokeReplaced || current.outValue() == null) {
            return;
        }
        DexEncodedMethod target = current.lookupSingleTarget(this.appInfo, callingContext);
        if (target == null) {
            return;
        }
        if (target.getOptimizationInfo().neverReturnsNull() && current.outValue().canBeNull()) {
            Value knownToBeNonNullValue = current.outValue();
            knownToBeNonNullValue.markNeverNull();
            TypeLatticeElement typeLattice = knownToBeNonNullValue.getTypeLattice();
            assert (typeLattice.isNullable() && typeLattice.isReference());
            knownToBeNonNullValue.narrowing(this.appInfo, typeLattice.asNonNullable());
            affectedValues.addAll(knownToBeNonNullValue.affectedValues());
        }
        if (target.getOptimizationInfo().returnsConstant()) {
            long constant = target.getOptimizationInfo().getReturnedConstant();
            ConstNumber replacement = MemberValuePropagation.createConstNumberReplacement(code, constant, current.outValue().getTypeLattice(), current.getLocalInfo());
            affectedValues.add(replacement.outValue());
            current.outValue().replaceUsers(replacement.outValue());
            current.setOutValue(null);
            replacement.setPosition(current.getPosition());
            current.moveDebugValues(replacement);
            if (current.getBlock().hasCatchHandlers()) {
                iterator2.split(code, blocks).listIterator().add(replacement);
            } else {
                iterator2.add(replacement);
            }
        }
    }

    private void rewriteStaticGetWithConstantValues(IRCode code, Predicate<DexEncodedMethod> isProcessedConcurrently, Set<Value> affectedValues, ListIterator<BasicBlock> blocks, InstructionListIterator iterator2, StaticGet current) {
        DexClass holderDefinition;
        DexField field = current.getField();
        DexEncodedField target = this.appInfo.lookupStaticTarget(field.getHolder(), field);
        if (target == null) {
            return;
        }
        Instruction replacement = target.valueAsConstInstruction(this.appInfo, current.dest());
        if (replacement != null) {
            affectedValues.add(replacement.outValue());
            iterator2.replaceCurrentInstruction(replacement);
            return;
        }
        ProguardMemberRuleLookup lookup = this.lookupMemberRule(target);
        if (lookup != null && lookup.type == RuleType.ASSUME_VALUES && this.tryConstantReplacementFromProguard(code, affectedValues, blocks, iterator2, current, lookup)) {
            return;
        }
        if (current.dest() != null && (holderDefinition = this.appInfo.definitionFor(field.getHolder())) != null && holderDefinition.accessFlags.isFinal() && !field.getHolder().initializationOfParentTypesMayHaveSideEffects(this.appInfo)) {
            DexEncodedMethod.TrivialInitializer info;
            Value outValue = current.dest();
            DexEncodedMethod classInitializer = holderDefinition.getClassInitializer();
            if (classInitializer != null && !isProcessedConcurrently.test(classInitializer) && (info = classInitializer.getOptimizationInfo().getTrivialInitializerInfo()) != null && ((DexEncodedMethod.TrivialInitializer.TrivialClassInitializer)info).field == field && !this.appInfo.isPinned(field) && outValue.canBeNull()) {
                outValue.markNeverNull();
                TypeLatticeElement typeLattice = outValue.getTypeLattice();
                assert (typeLattice.isNullable() && typeLattice.isReference());
                outValue.narrowing(this.appInfo, typeLattice.asNonNullable());
                affectedValues.addAll(outValue.affectedValues());
            }
        }
    }

    private void rewritePutWithConstantValues(InstructionIterator iterator2, FieldInstruction current) {
        DexEncodedField target;
        DexField field = current.getField();
        DexEncodedField dexEncodedField = target = current.isInstancePut() ? this.appInfo.lookupInstanceTarget(field.getHolder(), field) : this.appInfo.lookupStaticTarget(field.getHolder(), field);
        if (target != null && !this.appInfo.isFieldRead(target.field)) {
            iterator2.removeOrReplaceByDebugLocalRead();
        }
    }

    public void rewriteWithConstantValues(IRCode code, DexType callingContext, Predicate<DexEncodedMethod> isProcessedConcurrently) {
        Set<Value> affectedValues = Sets.newIdentityHashSet();
        ListIterator<BasicBlock> blocks = code.blocks.listIterator();
        while (blocks.hasNext()) {
            BasicBlock block = (BasicBlock)blocks.next();
            InstructionListIterator iterator2 = block.listIterator();
            while (iterator2.hasNext()) {
                Instruction current = (Instruction)iterator2.next();
                if (current.isInvokeMethod()) {
                    this.rewriteInvokeMethodWithConstantValues(code, callingContext, affectedValues, blocks, iterator2, current.asInvokeMethod());
                    continue;
                }
                if (current.isInstancePut() || current.isStaticPut()) {
                    this.rewritePutWithConstantValues(iterator2, current.asFieldInstruction());
                    continue;
                }
                if (!current.isStaticGet()) continue;
                this.rewriteStaticGetWithConstantValues(code, isProcessedConcurrently, affectedValues, blocks, iterator2, current.asStaticGet());
            }
        }
        if (!affectedValues.isEmpty()) {
            new TypeAnalysis(this.appInfo, code.method).narrowing(affectedValues);
        }
        assert (code.isConsistentSSA());
    }

    private static class ProguardMemberRuleLookup {
        final RuleType type;
        final ProguardMemberRule rule;

        ProguardMemberRuleLookup(RuleType type, ProguardMemberRule rule) {
            this.type = type;
            this.rule = rule;
        }
    }

    private static enum RuleType {
        NONE,
        ASSUME_NO_SIDE_EFFECTS,
        ASSUME_VALUES;

    }
}

