/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8.ir.code;

import com.android.tools.r8.cf.LoadStoreHelper;
import com.android.tools.r8.cf.code.CfStackInstruction;
import com.android.tools.r8.com.google.common.collect.ImmutableList;
import com.android.tools.r8.errors.Unreachable;
import com.android.tools.r8.graph.DexType;
import com.android.tools.r8.ir.code.Instruction;
import com.android.tools.r8.ir.code.InstructionListIterator;
import com.android.tools.r8.ir.code.StackValue;
import com.android.tools.r8.ir.code.StackValues;
import com.android.tools.r8.ir.code.Value;
import com.android.tools.r8.ir.conversion.CfBuilder;
import com.android.tools.r8.ir.conversion.DexBuilder;
import com.android.tools.r8.ir.optimize.Inliner;
import com.android.tools.r8.ir.optimize.InliningConstraints;

public class Swap
extends Instruction {
    public Swap(StackValue destBottom, StackValue destTop, Value srcBottom, Value srcTop) {
        this(new StackValues(destBottom, destTop), srcBottom, srcTop);
    }

    private Swap(StackValues dest, Value src1, Value src2) {
        super((Value)dest, ImmutableList.of(src1, src2));
        assert (src1.isValueOnStack() && !(src1 instanceof StackValues));
        assert (src2.isValueOnStack() && !(src2 instanceof StackValues));
        assert (!src1.getTypeLattice().isWide() && !src2.getTypeLattice().isWide());
    }

    @Override
    public void setOutValue(Value value) {
        assert (this.outValue == null || !this.outValue.hasUsersInfo() || !this.outValue.isUsed() || value instanceof StackValues);
        this.outValue = value;
        for (StackValue val : ((StackValues)value).getStackValues()) {
            val.definition = this;
        }
    }

    private StackValue[] getStackValues() {
        return ((StackValues)this.outValue()).getStackValues();
    }

    public StackValue outBottom() {
        return this.getStackValues()[0];
    }

    public StackValue outTop() {
        return this.getStackValues()[1];
    }

    @Override
    public void buildDex(DexBuilder builder) {
        throw new Unreachable("This classfile-specific IR should not be inserted in the Dex backend.");
    }

    @Override
    public void buildCf(CfBuilder builder) {
        builder.add(new CfStackInstruction(CfStackInstruction.Opcode.Swap));
    }

    @Override
    public boolean identicalNonValueNonPositionParts(Instruction other) {
        return other.isSwap();
    }

    @Override
    public int maxInValueRegister() {
        return 0;
    }

    @Override
    public int maxOutValueRegister() {
        throw new Unreachable();
    }

    @Override
    public Inliner.ConstraintWithTarget inliningConstraint(InliningConstraints inliningConstraints, DexType invocationContext) {
        return inliningConstraints.forSwap();
    }

    @Override
    public void insertLoadAndStores(InstructionListIterator it, LoadStoreHelper helper) {
    }

    @Override
    public boolean hasInvariantOutType() {
        return false;
    }

    @Override
    public boolean isSwap() {
        return true;
    }

    @Override
    public Swap asSwap() {
        return this;
    }
}

