/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8.experimental.graphinfo;

import com.android.tools.r8.Keep;
import com.android.tools.r8.experimental.graphinfo.GraphNode;
import com.android.tools.r8.origin.Origin;
import com.android.tools.r8.position.Position;
import com.android.tools.r8.position.TextPosition;
import com.android.tools.r8.position.TextRange;
import com.android.tools.r8.shaking.ProguardKeepRule;

@Keep
public final class KeepRuleGraphNode
extends GraphNode {
    private final ProguardKeepRule rule;

    public KeepRuleGraphNode(ProguardKeepRule rule) {
        super(false);
        assert (rule != null);
        this.rule = rule;
    }

    @Override
    public boolean equals(Object o) {
        return this == o || o instanceof KeepRuleGraphNode && ((KeepRuleGraphNode)o).rule == this.rule;
    }

    @Override
    public int hashCode() {
        return this.rule.hashCode();
    }

    public Origin getOrigin() {
        return this.rule.getOrigin();
    }

    public Position getPosition() {
        return this.rule.getPosition();
    }

    public String getContent() {
        return this.rule.getSource();
    }

    @Override
    public String toString() {
        return (this.getOrigin() == Origin.unknown() ? this.getContent() : this.getOrigin()) + ":" + KeepRuleGraphNode.shortPositionInfo(this.getPosition());
    }

    private static String shortPositionInfo(Position position) {
        if (position instanceof TextRange) {
            TextPosition start = ((TextRange)position).getStart();
            return start.getLine() + ":" + start.getColumn();
        }
        if (position instanceof TextPosition) {
            TextPosition start = (TextPosition)position;
            return start.getLine() + ":" + start.getColumn();
        }
        return position.getDescription();
    }
}

