/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8.shaking;

import com.android.tools.r8.com.google.common.base.Equivalence;
import com.android.tools.r8.graph.DexEncodedMethod;
import com.android.tools.r8.graph.DexMethod;
import com.android.tools.r8.utils.MethodSignatureEquivalence;
import java.util.HashMap;
import java.util.Map;

class ScopedDexMethodSet {
    private static final Equivalence<DexMethod> METHOD_EQUIVALENCE = MethodSignatureEquivalence.get();
    private final ScopedDexMethodSet parent;
    private final Map<Equivalence.Wrapper<DexMethod>, DexEncodedMethod> items = new HashMap<Equivalence.Wrapper<DexMethod>, DexEncodedMethod>();

    public ScopedDexMethodSet() {
        this(null);
    }

    private ScopedDexMethodSet(ScopedDexMethodSet parent) {
        this.parent = parent;
    }

    public ScopedDexMethodSet newNestedScope() {
        return new ScopedDexMethodSet(this);
    }

    private DexEncodedMethod lookup(Equivalence.Wrapper<DexMethod> item) {
        DexEncodedMethod ownMethod = this.items.get(item);
        return ownMethod != null ? ownMethod : (this.parent != null ? this.parent.lookup(item) : null);
    }

    private boolean contains(Equivalence.Wrapper<DexMethod> item) {
        return this.lookup(item) != null;
    }

    public boolean addMethod(DexEncodedMethod method) {
        Equivalence.Wrapper<DexMethod> wrapped = METHOD_EQUIVALENCE.wrap(method.method);
        if (this.contains(wrapped)) {
            return false;
        }
        this.items.put(wrapped, method);
        return true;
    }

    public boolean addMethodIfMoreVisible(DexEncodedMethod method) {
        Equivalence.Wrapper<DexMethod> wrapped = METHOD_EQUIVALENCE.wrap(method.method);
        DexEncodedMethod existing = this.lookup(wrapped);
        if (existing == null || method.accessFlags.isMoreVisibleThan(existing.accessFlags)) {
            this.items.put(wrapped, method);
            return true;
        }
        return false;
    }

    public ScopedDexMethodSet getParent() {
        return this.parent;
    }
}

