/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8.kotlin;

import com.android.tools.r8.jetbrains.kotlinx.metadata.Flag;
import com.android.tools.r8.jetbrains.kotlinx.metadata.KmClassVisitor;
import com.android.tools.r8.jetbrains.kotlinx.metadata.KmConstructorVisitor;
import com.android.tools.r8.jetbrains.kotlinx.metadata.KmFunctionVisitor;
import com.android.tools.r8.jetbrains.kotlinx.metadata.KmPropertyVisitor;
import com.android.tools.r8.jetbrains.kotlinx.metadata.jvm.KotlinClassMetadata;
import com.android.tools.r8.kotlin.KotlinInfo;
import com.android.tools.r8.kotlin.NonNullParameterHintCollector;

public class KotlinClass
extends KotlinInfo<KotlinClassMetadata.Class> {
    static KotlinClass fromKotlinClassMetadata(KotlinClassMetadata kotlinClassMetadata) {
        assert (kotlinClassMetadata instanceof KotlinClassMetadata.Class);
        KotlinClassMetadata.Class kClass = (KotlinClassMetadata.Class)kotlinClassMetadata;
        return new KotlinClass(kClass);
    }

    private KotlinClass(KotlinClassMetadata.Class metadata) {
        super(metadata);
    }

    @Override
    void processMetadata(KotlinClassMetadata.Class metadata) {
        metadata.accept(new ClassVisitorForNonNullParameterHints());
    }

    @Override
    public KotlinInfo.Kind getKind() {
        return KotlinInfo.Kind.Class;
    }

    @Override
    public boolean isClass() {
        return true;
    }

    @Override
    public KotlinClass asClass() {
        return this;
    }

    private class ClassVisitorForNonNullParameterHints
    extends KmClassVisitor {
        private ClassVisitorForNonNullParameterHints() {
        }

        @Override
        public KmFunctionVisitor visitFunction(int functionFlags, String functionName) {
            return new NonNullParameterHintCollector.FunctionVisitor(KotlinClass.this.nonNullparamHints);
        }

        @Override
        public KmConstructorVisitor visitConstructor(int ctorFlags) {
            return new NonNullParameterHintCollector.ConstructorVisitor(KotlinClass.this.nonNullparamHints);
        }

        @Override
        public KmPropertyVisitor visitProperty(int propertyFlags, String name, int getterFlags, int setterFlags) {
            if (Flag.Property.IS_VAR.invoke(propertyFlags)) {
                return new NonNullParameterHintCollector.PropertyVisitor(KotlinClass.this.nonNullparamHints);
            }
            return null;
        }
    }
}

